/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Absorption;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AbsorptionNote;
import uk.ac.ebi.kraken.parser.CommentHelper;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.EvidencedValueHandler;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class AbsorptionHandler
implements GenericHandler<Absorption, CommentType.Absorption> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final EvidenceReferenceHandler evRefHandler;
    private final EvidencedValueHandler evidencedValueHandler;

    public AbsorptionHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler referenceHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evRefHandler = referenceHandler;
        this.evidencedValueHandler = new EvidencedValueHandler(objectFactory, referenceHandler);
    }

    @Override
    public Absorption fromXmlBinding(CommentType.Absorption absorptionXML) {
        Absorption absorption = this.commentFactory.buildAbsorption();
        if (absorptionXML != null) {
            if (absorptionXML.getMax() != null) {
                String max = absorptionXML.getMax().getValue();
                CommentHelper.parseAbsortion(max, absorption);
                if (!absorptionXML.getMax().getEvidence().isEmpty()) {
                    absorption.getEvidenceIds().addAll(this.evRefHandler.parseEvidenceIDs(absorptionXML.getMax().getEvidence()));
                }
            }
            if (!absorptionXML.getText().isEmpty()) {
                AbsorptionNote absorptionNote = this.commentFactory.buildAbsorptionNote();
                ArrayList<EvidencedValue> evValues = new ArrayList<EvidencedValue>();
                for (EvidencedStringType evStr : absorptionXML.getText()) {
                    evValues.add(this.evidencedValueHandler.fromXmlBinding(evStr));
                }
                absorptionNote.setTexts(evValues);
                absorption.setNote(absorptionNote);
            }
            return absorption;
        }
        return null;
    }

    @Override
    public CommentType.Absorption toXmlBinding(Absorption absorption) {
        if (absorption != null) {
            List<Integer> evs;
            CommentType.Absorption absorptionXML = this.objectFactory.createCommentTypeAbsorption();
            EvidencedStringType maxAbsorption = this.objectFactory.createEvidencedStringType();
            maxAbsorption.setValue(CommentHelper.getXmlValueString(absorption));
            absorptionXML.setMax(maxAbsorption);
            if (!absorption.getEvidenceIds().isEmpty() && !(evs = this.evRefHandler.writeEvidenceIDs(absorption.getEvidenceIds())).isEmpty()) {
                absorptionXML.getMax().getEvidence().addAll(evs);
            }
            if (absorption.hasNote()) {
                for (EvidencedValue evValue : absorption.getNote().getTexts()) {
                    EvidencedStringType textAbsorption = this.evidencedValueHandler.toXmlBinding(evValue);
                    absorptionXML.getText().add(textAbsorption);
                }
            }
            return absorptionXML;
        }
        return null;
    }
}

