/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations.xrefs;

import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationXrefs;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.PubMedId;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.Constants;
import uk.ac.ebi.kraken.xml.uniprot.citations.xrefs.CitationXrefsStrategy;

public class PubMedStrategy
implements CitationXrefsStrategy {
    private final GenericHandler<PubMedId, String> pubMedIdHandler;
    private final ObjectFactory objectFactory;

    public PubMedStrategy(GenericHandler<PubMedId, String> pubMedIdHandler, ObjectFactory objectFactory) {
        this.pubMedIdHandler = pubMedIdHandler;
        this.objectFactory = objectFactory;
    }

    @Override
    public void fromJAXB(DbReferenceType referenceType, CitationXrefs citationXrefs) {
        if (referenceType.getType().equalsIgnoreCase(Constants.PUBMED_XMLTAG.getValue())) {
            citationXrefs.setPubMedId(this.pubMedIdHandler.fromXmlBinding(referenceType.getId()));
        }
    }

    @Override
    public DbReferenceType toJAXB(CitationXrefs xrefs) {
        DbReferenceType dbReferenceXML = this.objectFactory.createDbReferenceType();
        String id = this.pubMedIdHandler.toXmlBinding(xrefs.getPubmedId());
        if (id != null && id.length() > 0) {
            String name = Constants.PUBMED_XMLTAG.getValue();
            dbReferenceXML.setType(name);
            dbReferenceXML.setId(id);
            return dbReferenceXML;
        }
        return null;
    }
}

