/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.factories.EvidenceFactory;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeyListProxy;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.Keyword;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.Evidence;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.Entry;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.GeneType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.KeywordType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.OrganismType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.SequenceType;
import uk.ac.ebi.kraken.xml.uniprot.KeyListProxyFromFF;
import uk.ac.ebi.kraken.xml.uniprot.MetaUpdater;
import uk.ac.ebi.kraken.xml.uniprot.SourceProcessor;
import uk.ac.ebi.kraken.xml.uniprot.citations.BookHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationReferenceHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.ElectronicArticleHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.JournalArticleHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.PatentHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.SubmissionHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.ThesisHandler;
import uk.ac.ebi.kraken.xml.uniprot.citations.UnpublishedObservationsHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.CommentHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.CommentStatusHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.InteractionCommentHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.humdiseaselist.DiseaseIdListFileReader;
import uk.ac.ebi.kraken.xml.uniprot.comment.humdiseaselist.DiseaseIdListRetrieval;
import uk.ac.ebi.kraken.xml.uniprot.comment.humdiseaselist.DiseaseIdListRetrievalImpl;
import uk.ac.ebi.kraken.xml.uniprot.comment.subcell.SubcellLocationReader;
import uk.ac.ebi.kraken.xml.uniprot.comment.subcell.SubcellLocations;
import uk.ac.ebi.kraken.xml.uniprot.dbxref.DbXrefHandler;
import uk.ac.ebi.kraken.xml.uniprot.dbxref.DbXrefHandlerFactory;
import uk.ac.ebi.kraken.xml.uniprot.description.DescriptionHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.EcNumberHandler;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceHandler;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;
import uk.ac.ebi.kraken.xml.uniprot.feature.FeatureHandler;
import uk.ac.ebi.kraken.xml.uniprot.feature.FeatureHandlerFactory;
import uk.ac.ebi.kraken.xml.uniprot.gene.GeneHandler;
import uk.ac.ebi.kraken.xml.uniprot.keyword.KeywordHandler;
import uk.ac.ebi.kraken.xml.uniprot.organelle.OrganelleHandler;
import uk.ac.ebi.kraken.xml.uniprot.organism.NameUpdater;
import uk.ac.ebi.kraken.xml.uniprot.organism.NcbiTaxonHandler;
import uk.ac.ebi.kraken.xml.uniprot.organism.NcbiTaxonomyIdsUpdater;
import uk.ac.ebi.kraken.xml.uniprot.organism.OrganismHandler;
import uk.ac.ebi.kraken.xml.uniprot.organism.OrganismHostHandler;
import uk.ac.ebi.kraken.xml.uniprot.sequence.EntryUpdater;
import uk.ac.ebi.kraken.xml.uniprot.sequence.ProteinDescriptionUpdater;
import uk.ac.ebi.kraken.xml.uniprot.sequence.SequenceHandler;

public class UniProtEntryHandler
implements GenericHandler<UniProtEntry, Entry> {
    private UniProtFactory uniProtFactory;
    private ObjectFactory objectFactory;
    private MetaUpdater metaUpdater;
    private DescriptionHandler descriptionHandler;
    private EcNumberHandler ecNumberHandler;
    private GeneHandler geneHandler;
    private SequenceHandler sequenceHandler;
    private EntryUpdater entryUpdater;
    private ProteinDescriptionUpdater proteinDescriptionUpdater;
    private OrganismHandler organismHandler;
    private NcbiTaxonomyIdsUpdater ncbiTaxonomyIdsUpdater;
    private NcbiTaxonHandler ncbiTaxonHandler;
    private OrganismHostHandler organismHostHandler;
    private CitationHandler citationHandler;
    private CommentHandler commentHandler;
    private InteractionCommentHandler interactionCommentHandler;
    private DbXrefHandler dbXrefHandler;
    private KeywordHandler keywordHandler;
    private EvidenceReferenceHandler evidenceReferenceHandler;
    private KeyListProxy keywordListProxy;
    private OrganelleHandler organelleHandler;
    private DiseaseIdListRetrieval diseaseListHandler;
    private SubcellLocations subcellLocations;
    private EvidenceHandler evidenceHandler;
    private static UniProtEntryHandler INSTANCE = null;
    private static final String DESEASE_URI = "https://www.uniprot.org/docs/humdisease.txt";
    private static final String KEYWORD_URI = "https://www.uniprot.org/docs/keywlist.txt";
    private static final String SUBCELL_URI = "https://www.uniprot.org/docs/subcell.txt";

    public static UniProtEntryHandler createInstance() {
        return UniProtEntryHandler.createInstance(DESEASE_URI, KEYWORD_URI, SUBCELL_URI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UniProtEntryHandler getInstance(DiseaseIdListRetrieval diseaseIdListRetrieval, KeyListProxy keywordListProxy) {
        if (INSTANCE != null) return INSTANCE;
        Class<UniProtEntryHandler> clazz = UniProtEntryHandler.class;
        synchronized (UniProtEntryHandler.class) {
            if (INSTANCE != null) return INSTANCE;
            UniProtEntryHandler entryHandler = new UniProtEntryHandler();
            entryHandler.diseaseListHandler = diseaseIdListRetrieval;
            entryHandler.keywordListProxy = keywordListProxy;
            entryHandler.subcellLocations = new SubcellLocations(new SubcellLocationReader());
            entryHandler.init();
            INSTANCE = entryHandler;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UniProtEntryHandler createInstance(String diseaseFile, String keywordFile, String subcellFile) {
        if (INSTANCE != null) return INSTANCE;
        Class<UniProtEntryHandler> clazz = UniProtEntryHandler.class;
        synchronized (UniProtEntryHandler.class) {
            if (INSTANCE != null) return INSTANCE;
            DiseaseIdListFileReader diseaseListReader = new DiseaseIdListFileReader(diseaseFile);
            DiseaseIdListRetrievalImpl diseaseIdListRetrieval = new DiseaseIdListRetrievalImpl(diseaseListReader);
            KeyListProxyFromFF keyListProxy = new KeyListProxyFromFF(keywordFile);
            UniProtEntryHandler entryHandler = new UniProtEntryHandler();
            entryHandler.diseaseListHandler = diseaseIdListRetrieval;
            entryHandler.keywordListProxy = keyListProxy;
            entryHandler.subcellLocations = new SubcellLocations(new SubcellLocationReader(subcellFile));
            entryHandler.init();
            INSTANCE = entryHandler;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static UniProtEntryHandler createNewInstance(String diseaseFile, String keywordFile, String subcellFile) {
        DiseaseIdListFileReader diseaseListReader = new DiseaseIdListFileReader(diseaseFile);
        DiseaseIdListRetrievalImpl diseaseIdListRetrieval = new DiseaseIdListRetrievalImpl(diseaseListReader);
        KeyListProxyFromFF keyListProxy = new KeyListProxyFromFF(keywordFile);
        UniProtEntryHandler entryHandler = new UniProtEntryHandler();
        entryHandler.diseaseListHandler = diseaseIdListRetrieval;
        entryHandler.keywordListProxy = keyListProxy;
        entryHandler.subcellLocations = new SubcellLocations(new SubcellLocationReader(subcellFile));
        entryHandler.init();
        return entryHandler;
    }

    private UniProtEntryHandler() {
    }

    private void init() {
        this.evidenceReferenceHandler = new EvidenceReferenceHandler();
        this.entryUpdater = new EntryUpdater();
        this.objectFactory = new ObjectFactory();
        this.uniProtFactory = DefaultUniProtFactory.getInstance();
        this.ncbiTaxonHandler = new NcbiTaxonHandler(this.uniProtFactory, this.objectFactory);
        NameUpdater nameUpdater = new NameUpdater(this.uniProtFactory, this.objectFactory);
        this.organismHandler = new OrganismHandler(nameUpdater, this.uniProtFactory, this.objectFactory);
        this.proteinDescriptionUpdater = new ProteinDescriptionUpdater();
        this.sequenceHandler = new SequenceHandler(this.uniProtFactory, this.objectFactory);
        this.metaUpdater = new MetaUpdater(this.uniProtFactory, this.objectFactory);
        DefaultCitationNewFactory citationFactory = DefaultCitationNewFactory.getInstance();
        JournalArticleHandler journalArticleHandler = new JournalArticleHandler(this.objectFactory, citationFactory, this.evidenceReferenceHandler);
        BookHandler bookHandler = new BookHandler(this.objectFactory, citationFactory, this.evidenceReferenceHandler);
        PatentHandler patentHandler = new PatentHandler(this.objectFactory, citationFactory, this.evidenceReferenceHandler);
        ThesisHandler thesisHandler = new ThesisHandler(this.objectFactory, citationFactory, this.evidenceReferenceHandler);
        SubmissionHandler submissionHandler = new SubmissionHandler(this.objectFactory, citationFactory, this.evidenceReferenceHandler);
        ElectronicArticleHandler electronicArticleHandler = new ElectronicArticleHandler(this.objectFactory, citationFactory, this.evidenceReferenceHandler);
        UnpublishedObservationsHandler unpublishedObservationsHandler = new UnpublishedObservationsHandler(citationFactory, this.objectFactory, this.evidenceReferenceHandler);
        this.citationHandler = new CitationHandler();
        this.citationHandler.setJournalArticleHandler(journalArticleHandler);
        this.citationHandler.setElectronicArticleHandler(electronicArticleHandler);
        this.citationHandler.setPatentHandler(patentHandler);
        this.citationHandler.setBookHandler(bookHandler);
        this.citationHandler.setThesisHandler(thesisHandler);
        this.citationHandler.setSubmissionHandler(submissionHandler);
        this.citationHandler.setUnpublishedObservationsHandler(unpublishedObservationsHandler);
        this.ncbiTaxonomyIdsUpdater = new NcbiTaxonomyIdsUpdater(this.uniProtFactory, this.evidenceReferenceHandler, this.objectFactory);
        this.organismHostHandler = new OrganismHostHandler(this.uniProtFactory, this.objectFactory, this.evidenceReferenceHandler, nameUpdater);
        this.geneHandler = new GeneHandler(this.uniProtFactory, this.objectFactory, this.evidenceReferenceHandler);
        this.organelleHandler = new OrganelleHandler(this.uniProtFactory, this.objectFactory, this.evidenceReferenceHandler);
        DefaultCommentFactory commentFactory = DefaultCommentFactory.getInstance();
        CommentStatusHandler commentStatusHandler = new CommentStatusHandler();
        this.commentHandler = new CommentHandler(commentFactory, this.objectFactory, this.evidenceReferenceHandler, commentStatusHandler, this.diseaseListHandler, this.subcellLocations);
        this.interactionCommentHandler = new InteractionCommentHandler(commentFactory, this.objectFactory, this.evidenceReferenceHandler);
        this.keywordHandler = new KeywordHandler(this.uniProtFactory, this.objectFactory, this.keywordListProxy, this.evidenceReferenceHandler);
        DbXrefHandlerFactory handlerFactory = new DbXrefHandlerFactory(this.objectFactory, DefaultXRefFactory.getInstance());
        this.dbXrefHandler = new DbXrefHandler(handlerFactory);
        this.evidenceHandler = new EvidenceHandler(this.objectFactory, this.uniProtFactory);
    }

    @Override
    public UniProtEntry fromXmlBinding(Entry xmlEntry) {
        UniProtEntry uniProtEntry = this.uniProtFactory.buildEntry();
        Map<EvidenceId, Integer> evIdMap = this.fromXmlBindingForEvidences(xmlEntry, uniProtEntry);
        this.evidenceReferenceHandler.reset(evIdMap);
        this.ecNumberHandler = new EcNumberHandler(this.objectFactory, this.evidenceReferenceHandler);
        this.descriptionHandler = new DescriptionHandler(this.uniProtFactory, this.objectFactory, this.evidenceReferenceHandler, this.ecNumberHandler);
        this.fromXmlBindingForMetaInformation(xmlEntry, uniProtEntry);
        this.fromXmlBindingForDescription(xmlEntry, uniProtEntry);
        this.fromXmlBindingForGene(xmlEntry, uniProtEntry);
        this.fromXmlBindingForOrganelles(xmlEntry, uniProtEntry);
        this.fromXmlBindingForOrganism(xmlEntry, uniProtEntry);
        this.fromXmlBindingForCitations(xmlEntry, uniProtEntry);
        this.fromXmlBindingForComments(xmlEntry, uniProtEntry);
        this.fromXmlBindingForDatabaseCrossReferences(xmlEntry, uniProtEntry);
        this.fromXmlBindingForKeywords(xmlEntry, uniProtEntry);
        this.fromXmlBindingForFeature(xmlEntry, uniProtEntry);
        this.fromXmlBindingForSequence(xmlEntry, uniProtEntry);
        this.fromXmlBindingForOrganismHost(xmlEntry, uniProtEntry);
        return uniProtEntry;
    }

    @Override
    public Entry toXmlBinding(UniProtEntry uniProtEntry) {
        Entry xmlEntry = this.objectFactory.createEntry();
        Map<EvidenceId, Integer> evIdMap = this.toXmlBindingForEvidences(xmlEntry, uniProtEntry);
        this.evidenceReferenceHandler.reset(evIdMap);
        this.ecNumberHandler = new EcNumberHandler(this.objectFactory, this.evidenceReferenceHandler);
        this.descriptionHandler = new DescriptionHandler(this.uniProtFactory, this.objectFactory, this.evidenceReferenceHandler, this.ecNumberHandler);
        CitationReferenceHandler citationReferenceHandler = new CitationReferenceHandler();
        this.citationHandler.setCitationReferenceHandler(citationReferenceHandler);
        this.toXmlBindingForMetaInformation(xmlEntry, uniProtEntry);
        this.toXmlBindingForDescription(xmlEntry, uniProtEntry);
        this.toXmlBindingForGene(xmlEntry, uniProtEntry);
        this.toXmlBindingForOrganelles(xmlEntry, uniProtEntry);
        this.toXmlBindingForOrganism(xmlEntry, uniProtEntry);
        this.toXmlBindingForCitations(xmlEntry, uniProtEntry);
        this.toXmlBindingForComments(xmlEntry, uniProtEntry);
        this.toXmlBindingForDescriptionToDbReference(xmlEntry);
        this.toXmlBindingForDatabaseCrossReferences(xmlEntry, uniProtEntry);
        this.toXmlBindingForKeywords(xmlEntry, uniProtEntry);
        this.toXmlBindingForFeature(xmlEntry, uniProtEntry, citationReferenceHandler);
        this.toXmlBindingForSequence(xmlEntry, uniProtEntry);
        this.toXmlBindingForOrganismHost(xmlEntry, uniProtEntry);
        return xmlEntry;
    }

    private Map<EvidenceId, Integer> fromXmlBindingForEvidences(Entry xmlEntry, UniProtEntry uniProtEntry) {
        HashMap<EvidenceId, Integer> evIdMap = new HashMap<EvidenceId, Integer>();
        for (EvidenceType xmlEvidence : xmlEntry.getEvidence()) {
            Evidence evidence = this.evidenceHandler.fromXmlBinding(xmlEvidence);
            evIdMap.put(evidence.getEvidenceId(), xmlEvidence.getKey().intValue());
            uniProtEntry.getEvidences().add(evidence);
        }
        return evIdMap;
    }

    private void fromXmlBindingForMetaInformation(Entry xmlEntry, UniProtEntry uniProtEntry) {
        this.metaUpdater.fromXmlBinding(uniProtEntry, xmlEntry);
    }

    private void fromXmlBindingForDescription(Entry xmlEntry, UniProtEntry uniProtEntry) {
        ProteinDescription proteinDescripton = this.descriptionHandler.fromXmlBinding(xmlEntry.getProtein());
        uniProtEntry.setProteinDescription(proteinDescripton);
    }

    private void fromXmlBindingForGene(Entry xmlEntry, UniProtEntry uniProtEntry) {
        for (GeneType gene : xmlEntry.getGene()) {
            uniProtEntry.getGenes().add(this.geneHandler.fromXmlBinding(gene));
        }
    }

    private void fromXmlBindingForOrganelles(Entry xmlEntry, UniProtEntry uniProtEntry) {
        uniProtEntry.getOrganelles().addAll(this.organelleHandler.fromXmlBinding(xmlEntry.getGeneLocation()));
    }

    private void fromXmlBindingForOrganism(Entry xmlEntry, UniProtEntry uniProtEntry) {
        uniProtEntry.setOrganism(this.organismHandler.fromXmlBinding(xmlEntry.getOrganism()));
        this.ncbiTaxonomyIdsUpdater.fromXmlBinding(uniProtEntry.getNcbiTaxonomyIds(), xmlEntry.getOrganism());
        uniProtEntry.getTaxonomy().addAll(this.ncbiTaxonHandler.fromXmlBinding(xmlEntry.getOrganism().getLineage()));
    }

    private void fromXmlBindingForCitations(Entry xmlEntry, UniProtEntry uniProtEntry) {
        List<ReferenceType> references = xmlEntry.getReference();
        for (ReferenceType referenceType : references) {
            uniProtEntry.getCitationsNew().add(this.citationHandler.fromXmlBinding(referenceType));
        }
    }

    private void fromXmlBindingForComments(Entry xmlEntry, UniProtEntry uniProtEntry) {
        List<uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType> comments = xmlEntry.getComment();
        boolean interactionsFirst = true;
        for (uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentType : comments) {
            if (commentType.getType().equals("interaction")) {
                if (!interactionsFirst) continue;
                interactionsFirst = false;
                uniProtEntry.getComments().add(this.interactionCommentHandler.fromXmlBinding(comments));
                continue;
            }
            uniProtEntry.getComments().add(this.commentHandler.fromXmlBinding(commentType));
        }
    }

    private void fromXmlBindingForDatabaseCrossReferences(Entry xmlEntry, UniProtEntry uniProtEntry) {
        for (DbReferenceType dbReference : xmlEntry.getDbReference()) {
            try {
                DatabaseCrossReference reference = this.dbXrefHandler.fromXmlBinding(dbReference);
                if (reference.getDatabase() == DatabaseType.UNKNOWN) continue;
                uniProtEntry.addDatabaseCrossReference(reference);
            }
            catch (Exception exception) {}
        }
    }

    private void fromXmlBindingForKeywords(Entry xmlEntry, UniProtEntry uniProtEntry) {
        for (KeywordType keyword : xmlEntry.getKeyword()) {
            uniProtEntry.getKeywords().add(this.keywordHandler.fromXmlBinding(keyword));
        }
    }

    private void fromXmlBindingForSequence(Entry xmlEntry, UniProtEntry uniProtEntry) {
        SequenceType sequenceXML = xmlEntry.getSequence();
        uniProtEntry.setSequence(this.sequenceHandler.fromXmlBinding(sequenceXML));
        this.entryUpdater.fromXmlBinding(uniProtEntry.getEntryAudit(), sequenceXML);
        this.proteinDescriptionUpdater.fromXmlBinding(uniProtEntry.getProteinDescription(), sequenceXML);
    }

    private void fromXmlBindingForOrganismHost(Entry xmlEntry, UniProtEntry uniProtEntry) {
        uniProtEntry.getOrganismHosts().addAll(this.organismHostHandler.fromXmlBinding(xmlEntry.getOrganismHost()));
    }

    private void fromXmlBindingForFeature(Entry xmlEntry, UniProtEntry uniProtEntry) {
        for (uk.ac.ebi.kraken.xml.jaxb.uniprot.FeatureType feature : xmlEntry.getFeature()) {
            FeatureHandler<FeatureType> handler = FeatureHandlerFactory.getInstance().createFeatureHandler(FeatureType.typeOf(feature.getType()), this.evidenceReferenceHandler);
            FeatureType featureModel = handler.fromXmlBinding(feature);
            uniProtEntry.getFeatures().add((Feature)((Object)featureModel));
        }
    }

    private void toXmlBindingForMetaInformation(Entry xmlEntry, UniProtEntry uniProtEntry) {
        this.metaUpdater.toXmlBinding(xmlEntry, uniProtEntry);
    }

    private void toXmlBindingForDescription(Entry xmlEntry, UniProtEntry uniProtEntry) {
        xmlEntry.setProtein(this.descriptionHandler.toXmlBinding(uniProtEntry.getProteinDescription()));
    }

    private void toXmlBindingForOrganism(Entry xmlEntry, UniProtEntry uniProtEntry) {
        OrganismType organismXml = this.organismHandler.toXmlBinding(uniProtEntry.getOrganism());
        this.ncbiTaxonomyIdsUpdater.toXmlBinding(organismXml, uniProtEntry.getNcbiTaxonomyIds());
        organismXml.setLineage(this.ncbiTaxonHandler.toXmlBinding(uniProtEntry.getTaxonomy()));
        xmlEntry.setOrganism(organismXml);
    }

    private void toXmlBindingForGene(Entry xmlEntry, UniProtEntry uniProtEntry) {
        for (Gene gene : uniProtEntry.getGenes()) {
            xmlEntry.getGene().add(this.geneHandler.toXmlBinding(gene));
        }
    }

    private void toXmlBindingForOrganelles(Entry xmlEntry, UniProtEntry uniProtEntry) {
        xmlEntry.getGeneLocation().addAll(this.organelleHandler.toXmlBinding(uniProtEntry.getOrganelles()));
    }

    private void toXmlBindingForCitations(Entry xmlEntry, UniProtEntry uniProtEntry) {
        int keyVal = 0;
        for (Citation citation : uniProtEntry.getCitationsNew()) {
            ReferenceType referenceType = this.citationHandler.toXmlBinding(citation);
            referenceType.setKey(String.valueOf(++keyVal));
            xmlEntry.getReference().add(referenceType);
            this.citationHandler.addIndex(keyVal);
        }
    }

    private void toXmlBindingForComments(Entry xmlEntry, UniProtEntry uniProtEntry) {
        for (Comment comment : uniProtEntry.getComments()) {
            if (comment.getCommentType() == CommentType.INTERACTION) {
                xmlEntry.getComment().addAll(this.interactionCommentHandler.toXmlBinding((InteractionComment)comment));
                continue;
            }
            xmlEntry.getComment().add(this.commentHandler.toXmlBinding(comment));
        }
    }

    private void toXmlBindingForDescriptionToDbReference(Entry xmlEntry) {
        xmlEntry.getDbReference().addAll(this.ecNumberHandler.getDbRefTypeList());
    }

    private void toXmlBindingForDatabaseCrossReferences(Entry xmlEntry, UniProtEntry uniProtEntry) {
        for (DatabaseCrossReference xRef : uniProtEntry.getDatabaseCrossReferences()) {
            xmlEntry.getDbReference().add(this.dbXrefHandler.toXmlBinding(xRef));
        }
    }

    private void toXmlBindingForKeywords(Entry xmlEntry, UniProtEntry uniProtEntry) {
        for (Keyword keyword : uniProtEntry.getKeywords()) {
            xmlEntry.getKeyword().add(this.keywordHandler.toXmlBinding(keyword));
        }
    }

    private void toXmlBindingForFeature(Entry xmlEntry, UniProtEntry uniProtEntry, CitationReferenceHandler citationReferenceHandler) {
        for (Feature feature : uniProtEntry.getFeatures()) {
            FeatureHandler handler = FeatureHandlerFactory.getInstance().createFeatureHandler(feature.getType(), this.evidenceReferenceHandler, citationReferenceHandler);
            uk.ac.ebi.kraken.xml.jaxb.uniprot.FeatureType featureXml = handler.toXmlBinding(feature);
            xmlEntry.getFeature().add(featureXml);
        }
    }

    private void toXmlBindingForSequence(Entry xmlEntry, UniProtEntry uniProtEntry) {
        SequenceType sequenceXml = this.sequenceHandler.toXmlBinding(uniProtEntry.getSequence());
        xmlEntry.setSequence(sequenceXml);
        this.entryUpdater.toXmlBinding(sequenceXml, uniProtEntry.getEntryAudit());
        this.proteinDescriptionUpdater.toXmlBinding(sequenceXml, uniProtEntry.getProteinDescription());
    }

    private void toXmlBindingForOrganismHost(Entry xmlEntry, UniProtEntry uniProtEntry) {
        xmlEntry.getOrganismHost().addAll(this.organismHostHandler.toXmlBinding(uniProtEntry.getOrganismHosts()));
    }

    private Map<EvidenceId, Integer> toXmlBindingForEvidences(Entry xmlEntry, UniProtEntry uniProtEntry) {
        EvidenceFactory evidenceFactory = this.uniProtFactory.buildEvidenceFactory();
        SourceProcessor sourceProcessor = new SourceProcessor(evidenceFactory);
        sourceProcessor.setObjectFactory(this.objectFactory);
        Integer evCount = 0;
        HashMap<EvidenceId, Integer> evIdMap = new HashMap<EvidenceId, Integer>();
        for (Evidence evidence : uniProtEntry.getEvidences()) {
            Integer n = evCount;
            Integer n2 = evCount = Integer.valueOf(evCount + 1);
            EvidenceType xmlEvidence = this.evidenceHandler.toXmlBinding(evidence);
            xmlEvidence.setKey(BigInteger.valueOf(evCount.intValue()));
            xmlEntry.getEvidence().add(xmlEvidence);
            evIdMap.put(evidence.getEvidenceId(), evCount);
        }
        return evIdMap;
    }
}

