/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeyListProxy;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordCategory;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordEntry;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordNotRecognizedException;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordSynonym;
import uk.ac.ebi.kraken.parser.keywordlist.CategoryParser;
import uk.ac.ebi.kraken.parser.keywordlist.KeywordListParser;

public class KeyListProxyFromFF
implements KeyListProxy {
    private static final Logger LOG = LoggerFactory.getLogger(KeyListProxyFromFF.class);
    private List<KeywordEntry> entriesList = new ArrayList<KeywordEntry>();
    private Map<String, String> nameToId = new HashMap<String, String>();
    private Map<String, String> idToName = new HashMap<String, String>();

    public KeyListProxyFromFF(String keywordFile) {
        this.initKeywords(keywordFile);
    }

    private void initKeywords(String keywordFile) {
        try {
            Collection<KeywordEntry> entries;
            InputStream is = this.getInputStream(keywordFile);
            if (is != null) {
                LOG.debug("Use inputstream from url:" + keywordFile);
                Map<String, KeywordCategory> categoryMap = CategoryParser.buildCategoryMap(new InputStreamReader(is));
                is.close();
                is = this.getInputStream(keywordFile);
                KeywordListParser parser = new KeywordListParser(new InputStreamReader(is));
                entries = parser.parse(categoryMap);
            } else {
                LOG.debug("Use file directly:" + keywordFile);
                File file = new File(keywordFile);
                entries = KeywordListParser.parseAll(file);
            }
            this.entriesList.addAll(entries);
            for (KeywordEntry keywordEntry : entries) {
                this.nameToId.put(keywordEntry.getIdentifier().getValue(), keywordEntry.getAccession().getValue());
                this.idToName.put(keywordEntry.getAccession().getValue(), keywordEntry.getIdentifier().getValue());
                for (KeywordSynonym synonym : keywordEntry.getSynonyms()) {
                    this.nameToId.put(synonym.getValue(), keywordEntry.getAccession().getValue());
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private InputStream getInputStream(String keywordFile) {
        try {
            URL url = new URL(keywordFile);
            URLConnection con = url.openConnection(Proxy.NO_PROXY);
            return con.getInputStream();
        }
        catch (IOException e) {
            LOG.debug("Failed to create inputStream from url:" + keywordFile);
            return null;
        }
    }

    @Override
    public String getIdForName(String name) {
        String id = this.nameToId.get(name);
        if (id == null) {
            throw new KeywordNotRecognizedException("Keyword with name \"" + name + "\" does not exist. Please check if keywordlist file is correct");
        }
        return id;
    }

    @Override
    public String getNameForId(String id) {
        String name = this.idToName.get(id);
        if (name == null) {
            throw new KeywordNotRecognizedException("Keyword with id \"" + id + "\" does not exist. Please check if keywordlist file is correct");
        }
        return name;
    }

    @Override
    public List<KeywordEntry> getKeywordList() {
        return this.entriesList;
    }

    @Override
    public boolean keywordExists(String name) {
        return this.nameToId.containsKey(name);
    }
}

