/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniparc;

import com.sun.xml.bind.marshaller.DataWriter;
import com.sun.xml.bind.marshaller.XMLWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.xml.sax.ContentHandler;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.kraken.parser.UniProtEntryIteratorException;
import uk.ac.ebi.kraken.xml.common.KrakenDatatypeConverter;
import uk.ac.ebi.kraken.xml.common.KrakenXMLIterator;
import uk.ac.ebi.kraken.xml.common.XMLWriterException;
import uk.ac.ebi.kraken.xml.jaxb.uniparc.Entry;
import uk.ac.ebi.kraken.xml.jaxb.uniparc.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniparc.UniParcEntryJAXBConverter;

public class UniParcXMLWriter {
    private static final String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<uniparc>";
    private static final String footer = "</uniparc>";
    private ObjectFactory objectFactory = new ObjectFactory();
    private UniParcEntryJAXBConverter entryJAXBConverter = new UniParcEntryJAXBConverter();
    private JAXBContext jaxbContext;
    private boolean writeHeaderFooter = true;
    private List<String> unparsedEntries;
    private List<String> invalidEntries;
    private Writer writer;
    private boolean quiet = false;

    public UniParcXMLWriter(Writer writer) {
        this.init(writer);
    }

    public UniParcXMLWriter(File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        this.init(writer);
    }

    public UniParcXMLWriter(OutputStream outputStream) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.init(writer);
    }

    private void init(Writer writer) {
        this.writer = writer;
        this.unparsedEntries = new ArrayList<String>();
        this.invalidEntries = new ArrayList<String>();
    }

    public void write(UniParcEntry entry) throws IOException {
        if (entry == null) {
            throw new IllegalArgumentException("Entry to convert should not be null");
        }
        if (this.writeHeaderFooter) {
            this.writeHeader();
        }
        this.writeEntry(entry, this.getXMLWriter(this.writer));
        if (this.writeHeaderFooter) {
            this.writeFooter();
        }
    }

    public void write(List<UniParcEntry> entries) throws IOException {
        if (this.writeHeaderFooter) {
            this.writeHeader();
        }
        XMLWriter xmlWriter = this.getXMLWriter(this.writer);
        for (UniParcEntry entry : entries) {
            try {
                this.writeEntry(entry, xmlWriter);
            }
            catch (XMLWriterException e) {
                if (this.isQuiet()) continue;
                throw e;
            }
        }
        if (this.writeHeaderFooter) {
            this.writeFooter();
        }
    }

    public void write(KrakenXMLIterator<UniParcEntry> iterator) throws IOException {
        if (this.writeHeaderFooter) {
            this.writeHeader();
        }
        XMLWriter xmlWriter = this.getXMLWriter(this.writer);
        UniParcEntry entry = null;
        while (iterator.hasNext()) {
            try {
                entry = iterator.next();
                this.writeEntry(entry, xmlWriter);
            }
            catch (UniProtEntryIteratorException e) {
                this.unparsedEntries.add(e.getUnparsedEntry());
                System.err.println("FF entry is not parsed. Check unparsedEntries list");
            }
            catch (XMLWriterException e) {
                System.err.println("Entry is not converted to XML. Check invalidEntries list");
                this.addInvalidEntry(entry, e.getMessage());
            }
        }
        if (this.writeHeaderFooter) {
            this.writeFooter();
        }
    }

    public void writeFooter() throws IOException {
        this.writer.append(footer);
        this.writer.flush();
    }

    public void writeHeader() throws IOException {
        this.writer.append(header);
    }

    private void writeEntry(UniParcEntry entry, XMLWriter xmlWriter) {
        Marshaller m = null;
        try {
            m = this.prepareSpecialMarshaller();
        }
        catch (JAXBException e) {
            throw new XMLWriterException("Cannot initiate Marshaller");
        }
        try {
            Entry xmlEntry = this.objectFactory.createEntry();
            this.entryJAXBConverter.toJAXB(entry, xmlEntry);
            xmlWriter.reset();
            m.marshal((Object)xmlEntry, (ContentHandler)xmlWriter);
        }
        catch (Exception e) {
            throw new XMLWriterException("Entry was not converted to XML: " + e.getMessage(), e, entry.getUniParcId().getValue());
        }
    }

    private void addInvalidEntry(UniParcEntry entry, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append(entry.getUniParcId().getValue());
        sb.append("\n");
        sb.append(message);
        this.invalidEntries.add(sb.toString());
    }

    private JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext == null) {
            DatatypeConverter.setDatatypeConverter((DatatypeConverterInterface)new KrakenDatatypeConverter());
            this.jaxbContext = JAXBContext.newInstance((String)"uk.ac.ebi.kraken.xml.jaxb.uniparc");
        }
        return this.jaxbContext;
    }

    protected Marshaller prepareSpecialMarshaller() throws JAXBException {
        Marshaller m = this.getJaxbContext().createMarshaller();
        DatatypeConverter.setDatatypeConverter((DatatypeConverterInterface)new KrakenDatatypeConverter());
        m.setProperty("com.sun.xml.bind.xmlDeclaration", (Object)Boolean.FALSE);
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return m;
    }

    private XMLWriter getXMLWriter(Writer out) {
        DataWriter xmlWriter = new DataWriter(out, "UTF-8");
        xmlWriter.setIndentStep("  ");
        return xmlWriter;
    }

    public void setWriteHeaderFooter(boolean b) {
        this.writeHeaderFooter = b;
    }

    public List<String> getUnparsedEntries() {
        return this.unparsedEntries;
    }

    public List<String> getInvalidEntries() {
        return this.invalidEntries;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }
}

