/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.merge;

import java.io.IOException;
import java.time.Duration;
import java.time.LocalTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.xml.merge.XmlFileMergeConfigure;
import uk.ac.ebi.kraken.xml.merge.XmlFileMergeConfigureImpl;
import uk.ac.ebi.kraken.xml.merge.XmlFileMerger;
import uk.ac.ebi.kraken.xml.merge.XmlFileMergerImpl2;

public class XmlFileMergeMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlFileMergeMain.class);

    public static void main(String[] args) {
        LocalTime start = LocalTime.now();
        XmlFileMergeConfigure configure = XmlFileMergeConfigureImpl.fromCommandLine(args);
        if (!configure.isValid()) {
            System.out.println(configure.getUsage());
            System.exit(1);
        }
        List<String> inputFiles = configure.getInputFiles();
        LOGGER.info("merge files from ... " + inputFiles);
        LOGGER.info("merge to ... " + configure.getOutputFile());
        XmlFileMerger xmFileMerger = XmlFileMergeMain.createMerger();
        if (xmFileMerger == null) {
            System.exit(1);
        }
        try {
            xmFileMerger.mergeFiles(configure.getOutputFile(), inputFiles, configure.includeHeaderFooder());
            Duration duration = Duration.between(start, LocalTime.now());
            LOGGER.info("Total time: " + duration.getSeconds() + " seconds");
        }
        catch (IOException e) {
            LOGGER.error("failed to merge", (Throwable)e);
            System.exit(1);
        }
    }

    private static XmlFileMerger createMerger() {
        return new XmlFileMergerImpl2("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<uniprot xmlns=\"http://uniprot.org/uniprot\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xsi:schemaLocation=\"http://uniprot.org/uniprot http://www.uniprot.org/docs/uniprot.xsd\">\n", "<copyright>\nCopyrighted by the UniProt Consortium, see https://www.uniprot.org/terms Distributed under the Creative Commons Attribution (CC BY 4.0) License\n</copyright>\n</uniprot>");
    }
}

