/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.wrapper;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.util.wrapper.Rule;
import uk.ac.ebi.kraken.util.wrapper.TransformableValue;

public abstract class RuleChain<T extends TransformableValue<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(RuleChain.class);
    private List<Rule<T>> rules = new ArrayList<Rule<T>>();

    public abstract void buildRuleChain();

    public abstract String getRuleChainId();

    public T applyRuleChain(T input) {
        for (Rule<T> r : this.rules) {
            LOG.debug("Begin rule: {}", (Object)r.getClass().getSimpleName());
            boolean ruleRequired = r.transform(input);
            String ruleRequiredStr = " (not needed)";
            if (ruleRequired) {
                ruleRequiredStr = " (needed)";
            }
            LOG.debug("End rule: {}{}", (Object)r.getClass().getSimpleName(), (Object)ruleRequiredStr);
        }
        return input;
    }

    public void appendRule(Rule<T> rule) {
        this.rules.add(rule);
    }

    public String toString() {
        return "RuleChain: " + this.getRuleChainId();
    }
}

