/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.stringrange;

import java.util.Objects;
import uk.ac.ebi.kraken.util.stringrange.StringRange;

public class ContainsStringRange
implements StringRange {
    private final String value;

    public ContainsStringRange(String value) {
        this.value = Objects.requireNonNull(value, "value must not be null");
    }

    @Override
    public boolean isInRange(String target, boolean ignoreCase) {
        String temp;
        if (ignoreCase) {
            target = target.toLowerCase();
            temp = this.value.toLowerCase();
        } else {
            temp = this.value;
        }
        return target.contains(temp.subSequence(0, temp.length()));
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "ContainsStringRange{value='" + this.value + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainsStringRange that = (ContainsStringRange)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

