/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.stringrange;

import java.util.Objects;
import uk.ac.ebi.kraken.util.stringrange.StringRange;

public class ClosedStringRange
implements StringRange {
    private final String start;
    private final String end;
    private final boolean leftClosed;
    private final boolean rightClosed;

    public ClosedStringRange(String start, String end, boolean leftClosed, boolean rightClosed) {
        this.start = Objects.requireNonNull(start, "start must not be null");
        this.end = Objects.requireNonNull(end, "end must not be null");
        this.leftClosed = leftClosed;
        this.rightClosed = rightClosed;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public boolean isLeftClosed() {
        return this.leftClosed;
    }

    public boolean isRightClosed() {
        return this.rightClosed;
    }

    @Override
    public boolean isInRange(String target, boolean ignoreCase) {
        String tempEnd;
        String tempStart;
        if (ignoreCase) {
            target = target.toLowerCase();
            tempStart = this.start.toLowerCase();
            tempEnd = this.start.toLowerCase();
        } else {
            tempStart = this.start;
            tempEnd = this.end;
        }
        if (!(this.leftClosed && tempStart.compareTo(target) <= 0 || !this.leftClosed && tempStart.compareTo(target) < 0)) {
            return false;
        }
        return this.rightClosed && tempEnd.compareTo(target) >= 0 || !this.rightClosed && tempEnd.compareTo(target) > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClosedStringRange)) {
            return false;
        }
        ClosedStringRange closedStringRange = (ClosedStringRange)o;
        if (!this.end.equals(closedStringRange.end)) {
            return false;
        }
        return this.start.equals(closedStringRange.start);
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = 29 * result + this.end.hashCode();
        return result;
    }

    public String toString() {
        return "ClosedStringRange{start='" + this.start + "', end='" + this.end + "', leftClosed=" + this.leftClosed + ", rightClosed=" + this.rightClosed + "}";
    }
}

