/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.report;

public enum ExitCode {
    SUCCEEDED(0, "Succeeded"),
    WARNING(1, "Succeeded with warning"),
    FAILED(10, "Failed"),
    FATAL(11, "Fatal failure");

    int value;
    String sValue;

    private ExitCode(int value, String sValue) {
        this.value = value;
        this.sValue = sValue;
    }

    public ExitCode merge(ExitCode ec) {
        if (ec.getValue() > this.getValue()) {
            return ec;
        }
        return this;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.sValue;
    }

    public static ExitCode typeOf(int value) {
        for (ExitCode pubType : ExitCode.values()) {
            if (pubType.getValue() != value) continue;
            return pubType;
        }
        throw new IllegalArgumentException(String.format("The ExitCode with value %s does not exist", value));
    }
}

