/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.jaxb;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import uk.ac.ebi.kraken.util.jaxb.CustomBindingValidationHandler;

public class JAXBHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBHelper.class);

    private JAXBHelper() {
    }

    public static JAXBContext createJAXBContext(String jaxbClassesPackage) throws JAXBException {
        return JAXBContext.newInstance((String)jaxbClassesPackage);
    }

    public static Unmarshaller createUnmarshaller(String jaxbClassesPackage) throws JAXBException {
        JAXBContext jaxbContext = JAXBHelper.createJAXBContext(jaxbClassesPackage);
        return jaxbContext.createUnmarshaller();
    }

    public static Schema createSchemaValidation(String filePath) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema xrefSchema = schemaFactory.newSchema(new File(filePath));
        return xrefSchema;
    }

    public static Schema createSchemaValidation(URL url) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema xrefSchema = schemaFactory.newSchema(url);
        return xrefSchema;
    }

    public static Schema createSchemaValidation(InputStream inputStream) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema xrefSchema = schemaFactory.newSchema(new StreamSource(inputStream));
        return xrefSchema;
    }

    public static Object unmarshal(String xmlDocumentPath, String xmlSchemaPath, String namePackageJaxbClasses) {
        Unmarshaller unmarshaller = null;
        Object object = null;
        try {
            unmarshaller = JAXBHelper.createUnmarshaller(namePackageJaxbClasses);
            Schema schema = JAXBHelper.createSchemaValidation(xmlSchemaPath);
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler((ValidationEventHandler)new CustomBindingValidationHandler());
            object = unmarshaller.unmarshal(new File(xmlDocumentPath));
        }
        catch (JAXBException | SAXException e) {
            LOGGER.error(e.getMessage(), e);
            throw new RuntimeException();
        }
        return object;
    }

    public static Object unmarshal(String xmlDocumentPath, URL xmlSchemaUrl, String namePackageJaxbClasses) {
        Unmarshaller unmarshaller = null;
        Object object = null;
        try {
            unmarshaller = JAXBHelper.createUnmarshaller(namePackageJaxbClasses);
            Schema schema = JAXBHelper.createSchemaValidation(xmlSchemaUrl);
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler((ValidationEventHandler)new CustomBindingValidationHandler());
            object = unmarshaller.unmarshal(new File(xmlDocumentPath));
        }
        catch (JAXBException | SAXException e) {
            LOGGER.error(e.getMessage(), e);
            throw new RuntimeException();
        }
        return object;
    }

    public static Object unmarshal(String xmlDocumentPath, InputStream xmlSchema, String namePackageJaxbClasses) {
        Unmarshaller unmarshaller = null;
        Object object = null;
        try {
            unmarshaller = JAXBHelper.createUnmarshaller(namePackageJaxbClasses);
            Schema schema = JAXBHelper.createSchemaValidation(xmlSchema);
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler((ValidationEventHandler)new CustomBindingValidationHandler());
            object = unmarshaller.unmarshal(new File(xmlDocumentPath));
        }
        catch (JAXBException | SAXException e) {
            LOGGER.error(e.getMessage(), e);
            throw new RuntimeException();
        }
        return object;
    }

    public static Object unmarshal(InputStream xmlDocument, InputStream xmlSchema, String namePackageJaxbClasses) {
        Unmarshaller unmarshaller = null;
        Object object = null;
        try {
            unmarshaller = JAXBHelper.createUnmarshaller(namePackageJaxbClasses);
            Schema schema = JAXBHelper.createSchemaValidation(xmlSchema);
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler((ValidationEventHandler)new CustomBindingValidationHandler());
            object = unmarshaller.unmarshal(xmlDocument);
        }
        catch (JAXBException | SAXException e) {
            LOGGER.error(e.getMessage(), e);
            throw new RuntimeException();
        }
        return object;
    }

    public static Object unmarshal(InputStream xmlDocument, URL xmlSchemaUrl, String namePackageJaxbClasses) {
        Unmarshaller unmarshaller = null;
        Object object = null;
        try {
            unmarshaller = JAXBHelper.createUnmarshaller(namePackageJaxbClasses);
            Schema schema = JAXBHelper.createSchemaValidation(xmlSchemaUrl);
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler((ValidationEventHandler)new CustomBindingValidationHandler());
            object = unmarshaller.unmarshal(xmlDocument);
        }
        catch (JAXBException | SAXException e) {
            LOGGER.error(e.getMessage(), e);
            throw new RuntimeException();
        }
        return object;
    }

    public static Marshaller createMarshaller(String jaxbClassesPackage) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)jaxbClassesPackage);
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return marshaller;
    }
}

