/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.generator;

import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class TokenTree {
    private TreeModel tm = null;
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode();
    private DefaultMutableTreeNode marker = null;

    public TokenTree() {
        this.tm = new DefaultTreeModel(this.root);
    }

    public void addToken(String token) {
        this.marker = this.root;
        for (int iii = 0; iii < token.length(); ++iii) {
            this.push(Character.toString(token.charAt(iii)));
        }
    }

    private void push(String token) {
        boolean found = false;
        for (int iii = 0; iii < this.marker.getChildCount(); ++iii) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.marker.getChildAt(iii);
            if (!node.getUserObject().equals(token)) continue;
            found = true;
            this.marker = node;
            break;
        }
        if (!found) {
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(token);
            this.marker.add(newNode);
            this.marker = newNode;
        }
    }

    public String toCCSwitchStatement() {
        StringBuffer sb = new StringBuffer();
        sb.append("switch (LA(1)) {\n");
        for (int iii = 0; iii < this.root.getChildCount(); ++iii) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.root.getChildAt(iii);
            sb.append("  case '" + child.getUserObject() + "':\n");
            sb.append(this.getCCSuffix(child, 2));
        }
        sb.append("}\n");
        return sb.toString();
    }

    private String getCCSuffix(DefaultMutableTreeNode node, int indentLevel) {
        StringBuffer indentBuffer = new StringBuffer();
        for (int iii = 0; iii < indentLevel; ++iii) {
            indentBuffer.append(' ');
        }
        String indent = indentBuffer.toString();
        StringBuffer sb = new StringBuffer();
        if (this.isUnique(node)) {
            String token = this.getBranch(node);
            sb.append(indent + "  match(\"" + token + "\");\n");
            sb.append(indent + "  t = makeToken(" + token.substring(0, token.lastIndexOf(58)).replaceAll(" ", "_") + ");\n");
            sb.append(indent + "  block = BLOCK_NONE;\n");
            sb.append(indent + "  return t;\n");
        } else {
            DefaultMutableTreeNode splitNode = this.getSplitNode(node);
            sb.append(indent + "    switch (LA(" + (splitNode.getLevel() + 1) + ")) {\n");
            for (int iii = 0; iii < splitNode.getChildCount(); ++iii) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)splitNode.getChildAt(iii);
                sb.append(indent + "      case '" + child.getUserObject() + "':\n");
                sb.append(this.getCCSuffix(child, indentLevel + 6));
            }
            sb.append(indent + "    }\n");
        }
        return sb.toString();
    }

    public String toDRSwitchStatement() {
        StringBuffer sb = new StringBuffer();
        sb.append("switch (LA(1)) {\n");
        for (int iii = 0; iii < this.root.getChildCount(); ++iii) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.root.getChildAt(iii);
            sb.append("  case '" + child.getUserObject() + "':\n");
            sb.append(this.getDRSuffix(child, 2));
        }
        sb.append("}\n");
        return sb.toString();
    }

    private String getDRSuffix(DefaultMutableTreeNode node, int indentLevel) {
        StringBuffer indentBuffer = new StringBuffer();
        for (int iii = 0; iii < indentLevel; ++iii) {
            indentBuffer.append(' ');
        }
        String indent = indentBuffer.toString();
        StringBuffer sb = new StringBuffer();
        if (this.isUnique(node)) {
            String token = this.getBranch(node);
            StringTokenizer st = new StringTokenizer(token, "\n");
            String type = st.nextToken();
            String text = st.nextToken();
            sb.append(indent + "  match(\"" + type + "\");\n");
            sb.append(indent + "  t = makeToken(" + text + ");\n");
            sb.append(indent + "  block = BLOCK_NONE;\n");
            sb.append(indent + "  return t;\n");
        } else {
            DefaultMutableTreeNode splitNode = this.getSplitNode(node);
            sb.append(indent + "    switch (LA(" + (splitNode.getLevel() + 1) + ")) {\n");
            for (int iii = 0; iii < splitNode.getChildCount(); ++iii) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)splitNode.getChildAt(iii);
                sb.append(indent + "      case '" + child.getUserObject() + "':\n");
                sb.append(this.getDRSuffix(child, indentLevel + 6));
            }
            sb.append(indent + "    }\n");
        }
        return sb.toString();
    }

    private DefaultMutableTreeNode getSplitNode(DefaultMutableTreeNode child) {
        if (child.getChildCount() > 1) {
            return child;
        }
        if (child.getChildCount() == 1) {
            return this.getSplitNode((DefaultMutableTreeNode)child.getChildAt(0));
        }
        return null;
    }

    private boolean isUnique(DefaultMutableTreeNode child) {
        if (child.getChildCount() > 1) {
            return false;
        }
        if (child.getChildCount() == 1) {
            return this.isUnique((DefaultMutableTreeNode)child.getChildAt(0));
        }
        return true;
    }

    private String getBranch(DefaultMutableTreeNode child) {
        StringBuffer result = new StringBuffer();
        result.append(child.getUserObject());
        DefaultMutableTreeNode node = child;
        while (node.getParent() != null) {
            if ((node = (DefaultMutableTreeNode)node.getParent()).getUserObject() == null) continue;
            result.insert(0, node.getUserObject());
        }
        node = child;
        while (node.getChildCount() > 0) {
            if ((node = (DefaultMutableTreeNode)node.getChildAt(0)).getUserObject() == null) continue;
            result.append(node.getUserObject());
        }
        return result.toString();
    }
}

