/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.translator;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CatalyticActivityCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PhysiologicalDirectionType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PhysiologicalReaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Reaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.ReactionReference;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.ReactionReferenceType;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.parser.translator.CommentTranslator;
import uk.ac.ebi.kraken.parser.translator.CommentTranslatorHelper;
import uk.ac.ebi.uniprot.parser.impl.EvidenceHelper;

public class CatalyticActivityCommentTranslator
implements CommentTranslator<CatalyticActivityCommentStructured> {
    private static final DefaultCommentFactory FACTORY = DefaultCommentFactory.getInstance();
    private static final CommentType COMMENT_TYPE = CommentType.CATALYTIC_ACTIVITY;
    private static final String CATALYTIC_ACTIVITY_REGEX = "^([\\w/-]+(\\s[\\w/-]+)*:)?(\\s*(Reaction=(.+?));( (Xref=([^;]+));)?( EC=(([0-9]|\\.|n)+);)?( Evidence=\\{([^;]+)\\};)?)(([ \\t\\r\\n\\f]+)(PhysiologicalDirection=([^;]+)); (Xref=([^;]+));( Evidence=\\{([^;]+)\\};)?)?(([ \\t\\r\\n\\f]+)(PhysiologicalDirection=([^;]+)); (Xref=([^;]+));( Evidence=\\{([^;]+)\\};)?)?";
    public static final Pattern ATALYTIC_ACTIVITY_PATTERN = Pattern.compile("^([\\w/-]+(\\s[\\w/-]+)*:)?(\\s*(Reaction=(.+?));( (Xref=([^;]+));)?( EC=(([0-9]|\\.|n)+);)?( Evidence=\\{([^;]+)\\};)?)(([ \\t\\r\\n\\f]+)(PhysiologicalDirection=([^;]+)); (Xref=([^;]+));( Evidence=\\{([^;]+)\\};)?)?(([ \\t\\r\\n\\f]+)(PhysiologicalDirection=([^;]+)); (Xref=([^;]+));( Evidence=\\{([^;]+)\\};)?)?");

    @Override
    public CatalyticActivityCommentStructured translate(String annotation) {
        CatalyticActivityCommentStructured comment = (CatalyticActivityCommentStructured)FACTORY.buildComment(COMMENT_TYPE);
        annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE);
        this.translate(annotation, comment);
        return comment;
    }

    private String updateMolecule(String annotation, CatalyticActivityCommentStructured comment) {
        if (annotation.startsWith("[") && annotation.contains("]")) {
            int index = annotation.indexOf("]");
            String molecule = annotation.substring(1, index);
            molecule = molecule.replaceAll("\n", " ");
            comment.setMolecule(molecule);
            annotation = annotation.substring(index + 2).trim();
            if (annotation.startsWith("\n")) {
                annotation = annotation.substring(1);
            }
            return annotation;
        }
        return annotation;
    }

    @Override
    public void translate(String annotation, CatalyticActivityCommentStructured obj) {
        ArrayList<PhysiologicalReaction> pds;
        Matcher matcher = ATALYTIC_ACTIVITY_PATTERN.matcher(annotation = this.updateMolecule(annotation, obj));
        if (matcher.matches()) {
            String reactionName = matcher.group(5);
            String reactionXref = matcher.group(8);
            String reactionEc = matcher.group(10);
            String reactionEvidence = matcher.group(13);
            String pdName1 = matcher.group(17);
            String pdXref1 = matcher.group(19);
            String pdEvidence1 = matcher.group(21);
            String pdName2 = matcher.group(25);
            String pdXref2 = matcher.group(27);
            String pdEvidence2 = matcher.group(29);
            Reaction reaction = this.createReaction(reactionName, reactionXref, reactionEc, reactionEvidence);
            obj.setReaction(reaction);
            pds = new ArrayList<PhysiologicalReaction>();
            if (!Strings.isNullOrEmpty((String)pdName1)) {
                pds.add(this.createPhysiologicalDirection(pdName1, pdXref1, pdEvidence1));
            }
            if (!Strings.isNullOrEmpty((String)pdName2)) {
                pds.add(this.createPhysiologicalDirection(pdName2, pdXref2, pdEvidence2));
            }
        } else {
            throw new IllegalArgumentException("Unable to convert annotation to CATALYTIC_ACTIVITY comment: " + annotation);
        }
        obj.setPhysiologicalReactions(pds);
    }

    private PhysiologicalReaction createPhysiologicalDirection(String name, String xref, String evidence) {
        PhysiologicalReaction pd = FACTORY.buildPhysiologicalReaction();
        pd.setDirectionType(PhysiologicalDirectionType.typeOf(name));
        if (!Strings.isNullOrEmpty((String)xref)) {
            pd.setReactionReference(this.convertReactionReference(xref));
        }
        if (!Strings.isNullOrEmpty((String)evidence)) {
            pd.setEvidenceIds(EvidenceHelper.convert(Arrays.stream(evidence.split(", ")).collect(Collectors.toList())));
        }
        return pd;
    }

    private Reaction createReaction(String name, String xref, String ec, String evidence) {
        Reaction reaction = FACTORY.buildReaction();
        reaction.setName(name);
        if (!Strings.isNullOrEmpty((String)ec)) {
            reaction.setECNumber(ec);
        }
        if (!Strings.isNullOrEmpty((String)xref)) {
            reaction.setReactionReferences(Arrays.stream(xref.split(", ")).map(this::convertReactionReference).collect(Collectors.toList()));
        }
        if (!Strings.isNullOrEmpty((String)evidence)) {
            reaction.setEvidenceIds(EvidenceHelper.convert(Arrays.stream(evidence.split(", ")).collect(Collectors.toList())));
        }
        return reaction;
    }

    private ReactionReference convertReactionReference(String val) {
        ReactionReference ref = FACTORY.buildReactionReference();
        int index = val.indexOf(58);
        String type = val.substring(0, index);
        String id = val.substring(index + 1);
        ref.setType(ReactionReferenceType.typeOf(type));
        ref.setId(id);
        return ref;
    }
}

