/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.modelcreation;

import java.util.ArrayList;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Position;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingLocationType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingNote;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.uniprot.evidences.EvidenceIdImpl;
import uk.ac.ebi.kraken.parser.CommentHelper;
import uk.ac.ebi.kraken.parser.translator.CommentTranslatorHelper;

public class RnaEditingBuilder
extends CommentHelper {
    public static void createComment(String value, RnaEditingComment comment) {
        RnaEditingNote rnaEditingNote = DefaultCommentFactory.getInstance().buildRnaEditingNote();
        comment.setRnaEditingNote(rnaEditingNote);
        RnaEditingBuilder.setLocationType(value, comment);
        comment.setPositions(new ArrayList<Position>());
        String[] divided = new String[]{};
        String[] strings = value.split(";");
        if (strings.length >= 1) {
            String modifiedPositions = strings[0];
            if (modifiedPositions.contains("Modified_positions=")) {
                divided = modifiedPositions.split("=");
            }
            if (strings.length > 1 && strings[1].contains("Note=")) {
                int noteStart = strings[1].lastIndexOf("Note=");
                String s = strings[1].substring(noteStart + 5);
                comment.getRnaEditingNote().setTexts(CommentTranslatorHelper.parseEvidencedValues(s, false));
            }
        }
        if (!comment.getLocationType().equals((Object)RnaEditingLocationType.Not_applicable) && !comment.getLocationType().equals((Object)RnaEditingLocationType.Undetermined)) {
            if (divided.length == 0) {
                return;
            }
            if (divided[1].endsWith(".")) {
                divided[1] = divided[1].substring(0, divided[1].length() - 1);
            }
            if (divided[1].contains("}")) {
                String[] positionsWithEvidences = divided[1].split("}");
                RnaEditingBuilder.processEvidences(comment, positionsWithEvidences);
            } else {
                RnaEditingBuilder.createPositionListWithoutEvidences(comment, divided[1]);
            }
        }
    }

    private static void setLocationType(String value, RnaEditingComment comment) {
        if (value.contains("Modified_positions=")) {
            String locType;
            int startOfModPos = value.indexOf("Modified_positions=") + "Modified_positions=".length();
            int endOfMosPos = value.indexOf(59, startOfModPos);
            if (endOfMosPos == -1) {
                endOfMosPos = value.length();
            }
            if ((locType = value.substring(startOfModPos, endOfMosPos)).endsWith(".")) {
                locType = locType.substring(0, locType.length() - 1);
            }
            comment.setLocationType(RnaEditingLocationType.getType(locType));
        }
    }

    private static void processEvidences(RnaEditingComment comment, String[] positionsWithEvidences) {
        for (String aPosition : positionsWithEvidences) {
            if (aPosition.contains("{")) {
                String rightBrace = "\\{";
                String[] numbers = aPosition.split(rightBrace);
                String[] positions = numbers[0].split(",");
                for (int i = 0; i < positions.length; ++i) {
                    if (positions[i].trim().equals("")) continue;
                    if (i == positions.length - 1) {
                        String[] positionNos = numbers[1].split(",");
                        ArrayList<EvidenceId> evidenceList = new ArrayList<EvidenceId>();
                        for (String evidenceId : positionNos) {
                            EvidenceIdImpl id = new EvidenceIdImpl();
                            id.setValue(evidenceId);
                            evidenceList.add(id);
                        }
                        Position position = DefaultCommentFactory.getInstance().buildRnaEditingPosition();
                        position.setPosition(positions[i].trim());
                        position.setEvidenceIds(evidenceList);
                        comment.getPositionsWithEvidences().add(position);
                        continue;
                    }
                    ArrayList<EvidenceId> evidenceList = new ArrayList<EvidenceId>();
                    Position position = DefaultCommentFactory.getInstance().buildRnaEditingPosition();
                    position.setPosition(positions[i].trim());
                    position.setEvidenceIds(evidenceList);
                    comment.getPositionsWithEvidences().add(position);
                }
                continue;
            }
            RnaEditingBuilder.createPositionListWithoutEvidences(comment, aPosition);
        }
    }

    private static void createPositionListWithoutEvidences(RnaEditingComment comment, String aPosition) {
        String[] positions;
        for (String xm : positions = aPosition.split(",")) {
            if (xm.trim().equals("")) continue;
            ArrayList<EvidenceId> evidenceList = new ArrayList<EvidenceId>();
            Position position = DefaultCommentFactory.getInstance().buildRnaEditingPosition();
            position.setPosition(xm.trim());
            position.setEvidenceIds(evidenceList);
            comment.getPositionsWithEvidences().add(position);
        }
    }
}

