/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.keywordlist;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import uk.ac.ebi.kraken.interfaces.factories.KeywordListFactory;
import uk.ac.ebi.kraken.interfaces.keywordlist.GoId;
import uk.ac.ebi.kraken.interfaces.keywordlist.GoMapping;
import uk.ac.ebi.kraken.interfaces.keywordlist.GoTerm;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordEntry;
import uk.ac.ebi.kraken.model.factories.DefaultKeywordListFactory;

public class KeywordEntryIterator
implements Iterable<KeywordEntry>,
Iterator<KeywordEntry> {
    private BufferedReader reader;
    private KeywordListFactory kwListFactory = DefaultKeywordListFactory.getInstance();
    private KeywordEntry currentEntry;
    private KeywordEntry nextEntry;
    private static final int ID = 1;
    private static final int AC = 2;
    private static final int DE = 3;
    private static final int SY = 4;
    private static final int GO = 5;
    private static final int HI = 6;
    private static final int AN = 7;
    private static final int RU = 8;
    private static final int CA = 9;
    private static final int TERM = 10;
    private static final int WW = 11;
    private static final int IC = 12;
    private Map<String, Integer> lineTypeHash;

    protected KeywordEntryIterator(File file) throws IOException {
        this.lineTypeHash = new HashMap<String, Integer>();
        this.lineTypeHash.put("ID   ", 1);
        this.lineTypeHash.put("AC   ", 2);
        this.lineTypeHash.put("DE   ", 3);
        this.lineTypeHash.put("SY   ", 4);
        this.lineTypeHash.put("GO   ", 5);
        this.lineTypeHash.put("HI   ", 6);
        this.lineTypeHash.put("AN   ", 7);
        this.lineTypeHash.put("RU   ", 8);
        this.lineTypeHash.put("CA   ", 9);
        this.lineTypeHash.put("WW   ", 11);
        this.lineTypeHash.put("IC   ", 12);
        this.lineTypeHash.put("//", 10);
        this.initializeStream();
        this.reader = new BufferedReader(new FileReader(file));
        this.nextEntry = this.getNextKeywordEntry();
    }

    protected KeywordEntryIterator(BufferedReader reader) throws IOException {
        this.reader = reader;
        this.lineTypeHash = new HashMap<String, Integer>();
        this.lineTypeHash.put("ID   ", 1);
        this.lineTypeHash.put("AC   ", 2);
        this.lineTypeHash.put("DE   ", 3);
        this.lineTypeHash.put("SY   ", 4);
        this.lineTypeHash.put("GO   ", 5);
        this.lineTypeHash.put("HI   ", 6);
        this.lineTypeHash.put("AN   ", 7);
        this.lineTypeHash.put("RU   ", 8);
        this.lineTypeHash.put("CA   ", 9);
        this.lineTypeHash.put("WW   ", 11);
        this.lineTypeHash.put("IC   ", 12);
        this.lineTypeHash.put("//", 10);
        this.initializeStream();
        this.nextEntry = this.getNextKeywordEntry();
    }

    private void initializeStream() throws IOException {
        if (this.reader.ready()) {
            String line = null;
            while ((line = this.reader.readLine()) != null && !line.startsWith("_____")) {
            }
        }
    }

    private KeywordEntry getNextKeywordEntry() throws IOException {
        if (this.reader.ready()) {
            String line = null;
            KeywordEntry keyword = this.kwListFactory.buildEntry();
            StringBuffer deSB = new StringBuffer();
            line = this.reader.readLine();
            while (line != null) {
                String lineTypeString = line.length() > 4 ? line.substring(0, 5) : (line.length() > 1 ? line : line);
                Integer lineType = this.lineTypeHash.get(lineTypeString);
                if (lineType != null) {
                    switch (lineType) {
                        case 1: {
                            keyword.setIdentifier(this.kwListFactory.buildIdentifier(line.substring(5, line.length() - 1)));
                            break;
                        }
                        case 2: {
                            keyword.setAccession(this.kwListFactory.buildAccession(line.substring(5)));
                            break;
                        }
                        case 3: {
                            if (deSB.length() > 0) {
                                deSB.append('\n');
                            }
                            deSB.append(line.substring(5));
                            break;
                        }
                        case 4: {
                            this.addSynonyms(keyword, line.substring(5));
                            break;
                        }
                        case 5: {
                            this.addGoMapping(keyword, line.substring(5));
                            break;
                        }
                        case 6: {
                            keyword.getHierachies().add(this.kwListFactory.buildHierachy(line.substring(5)));
                            break;
                        }
                        case 7: {
                            keyword.getAnnotations().add(this.kwListFactory.buildAnnotation(line.substring(5)));
                            break;
                        }
                        case 8: {
                            keyword.getRules().add(this.kwListFactory.buildRule(line.substring(5)));
                            break;
                        }
                        case 10: {
                            keyword.setDescription(this.kwListFactory.buildDescription(deSB.toString()));
                            return keyword;
                        }
                    }
                } else {
                    System.out.println("Warning: unknown linetype: " + lineTypeString);
                }
                line = this.reader.readLine();
            }
        }
        return null;
    }

    private void addSynonyms(KeywordEntry keyword, String synonymLine) {
        StringTokenizer stringTokenizer = new StringTokenizer(synonymLine, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String synonym = stringTokenizer.nextToken().trim();
            if (synonym.endsWith(".")) {
                synonym = synonym.substring(0, synonym.length() - 1);
            }
            keyword.getSynonyms().add(this.kwListFactory.buildSynonym(synonym));
        }
    }

    private void addGoMapping(KeywordEntry keyword, String goLine) {
        GoMapping goMap = this.kwListFactory.buildGoMapping();
        StringTokenizer stringTokenizer = new StringTokenizer(goLine, ";");
        String tokenOne = stringTokenizer.nextToken();
        GoId goId = this.kwListFactory.buildGoId(tokenOne.trim());
        goMap.setGoId(goId);
        if (stringTokenizer.hasMoreTokens()) {
            String tokenTwo = stringTokenizer.nextToken();
            GoTerm goTerm = this.kwListFactory.buildGoTerm(tokenTwo.trim());
            goMap.setGoTerm(goTerm);
        }
        keyword.getGoMappings().add(goMap);
    }

    @Override
    public Iterator<KeywordEntry> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.nextEntry != null;
    }

    @Override
    public KeywordEntry next() {
        try {
            this.currentEntry = this.nextEntry;
            this.nextEntry = this.getNextKeywordEntry();
        }
        catch (IOException e) {
            throw new NoSuchElementException(e.getMessage());
        }
        if (this.currentEntry == null) {
            throw new NoSuchElementException("nothing left");
        }
        return this.currentEntry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("can't remove keywords");
    }
}

