/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import uk.ac.ebi.kraken.parser.EntryReader;
import uk.ac.ebi.kraken.parser.LoaderException;

public class EntrygzFileReader
implements EntryReader {
    private BufferedReader reader;
    private boolean available = true;

    public EntrygzFileReader(String fileName) throws IOException {
        InputStream is = new FileInputStream(fileName);
        if (fileName.endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        this.reader = new BufferedReader(new InputStreamReader(is));
    }

    @Override
    public String next() throws IOException {
        try {
            StringBuilder newFileEntry = new StringBuilder();
            String newLine = null;
            if (this.available) {
                do {
                    newLine = this.reader.readLine();
                    newFileEntry.append(newLine);
                    newFileEntry.append('\n');
                } while (newLine != null && !newLine.equals("//"));
                if (newLine == null) {
                    this.available = false;
                }
            }
            if (newFileEntry.length() <= 0 || !this.available) {
                return null;
            }
            return newFileEntry.toString();
        }
        catch (IOException e) {
            throw new LoaderException("Can't load Flatfile ", e);
        }
    }

    @Override
    public void close() throws Exception {
        this.reader.close();
    }
}

