/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.features;

import uk.ac.ebi.kraken.interfaces.uniprot.features.CarbohydFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.CarbohydLinkType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureId;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.LinkedSugar;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.model.uniprot.features.FeatureImpl;

public class CarbohydFeatureImpl
extends FeatureImpl
implements CarbohydFeature {
    private LinkedSugar linkedSugar = DefaultFeatureFactory.getInstance().buildLinkedSugar("");
    private CarbohydLinkType carbohydLinkType = CarbohydLinkType.UNKNOWN;
    private FeatureDescription featureDescription = DefaultFeatureFactory.getInstance().buildFeatureDescription("");
    private FeatureId featureId;

    public CarbohydFeatureImpl() {
        this.featureId = DefaultFeatureFactory.getInstance().buildFeatureId("");
    }

    public CarbohydFeatureImpl(CarbohydFeature feature) {
        super(feature);
        if (feature.getFeatureId() != null) {
            this.featureId = DefaultFeatureFactory.getInstance().buildFeatureId(feature.getFeatureId());
        }
        if (feature.getLinkedSugar() != null) {
            this.linkedSugar = DefaultFeatureFactory.getInstance().buildLinkedSugar(feature.getLinkedSugar());
        }
        if (feature.getCarbohydLinkType() != null) {
            this.carbohydLinkType = feature.getCarbohydLinkType();
        }
        if (feature.getFeatureDescription() != null) {
            this.featureDescription = DefaultFeatureFactory.getInstance().buildFeatureDescription(feature.getFeatureDescription());
        }
    }

    @Override
    public FeatureType getType() {
        return FeatureType.CARBOHYD;
    }

    @Override
    public CarbohydLinkType getCarbohydLinkType() {
        return this.carbohydLinkType;
    }

    @Override
    public void setCarbohydLinkType(CarbohydLinkType carbohydLinkType) {
        this.carbohydLinkType = carbohydLinkType;
    }

    @Override
    public LinkedSugar getLinkedSugar() {
        return this.linkedSugar;
    }

    @Override
    public void setLinkedSugar(LinkedSugar sugar) {
        this.linkedSugar = sugar;
    }

    @Override
    public FeatureDescription getFeatureDescription() {
        return this.featureDescription;
    }

    @Override
    public void setFeatureDescription(FeatureDescription description) {
        this.featureDescription = description;
    }

    @Override
    public FeatureId getFeatureId() {
        return this.featureId;
    }

    @Override
    public void setFeatureId(FeatureId featureId) {
        this.featureId = featureId;
    }

    @Override
    public boolean hasFeatureId() {
        if (this.featureId == null) {
            return false;
        }
        return !this.featureId.getValue().equals("");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CarbohydFeature: ");
        sb.append(this.getFeatureDescription().getValue());
        sb.append(" ");
        sb.append((Object)this.getCarbohydLinkType());
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CarbohydFeatureImpl that = (CarbohydFeatureImpl)o;
        if (this.carbohydLinkType != that.carbohydLinkType) {
            return false;
        }
        if (this.featureDescription != null ? !this.featureDescription.equals(that.featureDescription) : that.featureDescription != null) {
            return false;
        }
        if (this.featureId != null ? !this.featureId.equals(that.featureId) : that.featureId != null) {
            return false;
        }
        return !(this.linkedSugar != null ? !this.linkedSugar.equals(that.linkedSugar) : that.linkedSugar != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.linkedSugar != null ? this.linkedSugar.hashCode() : 0);
        result = 29 * result + (this.carbohydLinkType != null ? this.carbohydLinkType.hashCode() : 0);
        result = 29 * result + (this.featureDescription != null ? this.featureDescription.hashCode() : 0);
        result = 29 * result + (this.featureId != null ? this.featureId.hashCode() : 0);
        return result;
    }
}

