/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtIsoformId;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.DatabaseAttribute;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.accessions.UniProtIsoformIdImpl;

public class DatabaseCrossReferenceImpl
implements PersistentObject,
DatabaseCrossReference {
    private static final long serialVersionUID = 1L;
    private DatabaseAttribute primaryId;
    private DatabaseAttribute description;
    private DatabaseAttribute third;
    private DatabaseAttribute fourth;
    private final DatabaseType dbType;
    private List<EvidenceId> evidenceIds = new ArrayList<EvidenceId>();
    private long id;
    private UniProtIsoformId isoformId = new UniProtIsoformIdImpl();

    public DatabaseCrossReferenceImpl(DatabaseType dbType) {
        this(dbType, null);
    }

    public DatabaseCrossReferenceImpl(DatabaseType dbType, List<EvidenceId> evidenceIds) {
        this.dbType = dbType;
        if (evidenceIds != null) {
            this.evidenceIds = new ArrayList<EvidenceId>();
            this.evidenceIds.addAll(evidenceIds);
        }
        this.primaryId = DefaultXRefFactory.getInstance().buildXDBAttribute("");
        this.description = DefaultXRefFactory.getInstance().buildXDBAttribute("");
        if (this.hasThird()) {
            this.third = DefaultXRefFactory.getInstance().buildXDBAttribute("");
        }
        if (this.hasFourth()) {
            this.third = DefaultXRefFactory.getInstance().buildXDBAttribute("");
            this.fourth = DefaultXRefFactory.getInstance().buildXDBAttribute("");
        }
    }

    public DatabaseCrossReferenceImpl(DatabaseCrossReference copy) {
        this(copy.getDatabase(), copy.getEvidenceIds());
        this.primaryId.setValue(copy.getPrimaryId().getValue());
        this.description.setValue(copy.getDescription().getValue());
        this.setIsoformId(copy.getIsoformId());
        this.setThird(copy.getThird());
        this.setFourth(copy.getFourth());
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidences) {
        this.evidenceIds = evidences;
    }

    @Override
    public DatabaseType getDatabase() {
        return this.dbType;
    }

    @Override
    public DatabaseAttribute getPrimaryId() {
        return this.primaryId;
    }

    @Override
    public DatabaseAttribute getDescription() {
        return this.description;
    }

    @Override
    public DatabaseAttribute getThird() {
        return this.third;
    }

    @Override
    public DatabaseAttribute getFourth() {
        return this.fourth;
    }

    @Override
    public void setPrimaryId(DatabaseAttribute value) {
        this.primaryId = value;
    }

    @Override
    public void setDescription(DatabaseAttribute value) {
        this.description = value;
    }

    @Override
    public void setThird(DatabaseAttribute value) {
        this.third = value;
    }

    @Override
    public void setFourth(DatabaseAttribute value) {
        this.fourth = value;
    }

    @Override
    public boolean hasThird() {
        return this.dbType.getNumberOfAttribute() >= 3;
    }

    @Override
    public boolean hasFourth() {
        return this.dbType.getNumberOfAttribute() >= 4;
    }

    @Override
    public void setIsoformId(UniProtIsoformId isoformId) {
        this.isoformId = isoformId;
    }

    @Override
    public UniProtIsoformId getIsoformId() {
        return this.isoformId;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseCrossReferenceImpl)) {
            return false;
        }
        DatabaseCrossReferenceImpl myClass = (DatabaseCrossReferenceImpl)o;
        if (this.getDatabase() != myClass.getDatabase()) {
            return false;
        }
        if (!this.primaryId.equals(myClass.getPrimaryId())) {
            return false;
        }
        if (!this.description.equals(myClass.getDescription())) {
            return false;
        }
        if (this.hasThird() && !this.third.equals(myClass.getThird())) {
            return false;
        }
        if (this.hasFourth() && !this.fourth.equals(myClass.getFourth())) {
            return false;
        }
        if (this.hasFourth() && !this.fourth.equals(myClass.getFourth())) {
            return false;
        }
        return this.isoformId == null || this.isoformId.equals(myClass.getIsoformId());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = this.getDatabase() != null ? this.getDatabase().hashCode() : 0;
        result = 29 * result + (this.primaryId != null ? this.primaryId.hashCode() : 0);
        result = 29 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 29 * result + (this.third != null ? this.third.hashCode() : 0);
        result = 29 * result + (this.fourth != null ? this.fourth.hashCode() : 0);
        result = 29 * result + (this.isoformId != null ? this.isoformId.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDatabase().getDisplayName());
        sb.append(this.getPrimaryId().getValue()).append("; ");
        sb.append(this.getDescription().getValue());
        if (this.hasThird()) {
            sb.append("; ");
            sb.append(this.getThird().getValue());
            if (this.hasFourth()) {
                sb.append("; ");
                sb.append(this.getFourth().getValue());
            }
        }
        sb.append(".");
        if (this.isoformId != null && !this.isoformId.getValue().isEmpty()) {
            sb.append(" [").append(this.isoformId.getValue()).append("]");
        }
        return sb.toString();
    }
}

