/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.Collection;
import java.util.Collections;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DatabaseFTP;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DatabaseName;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DatabaseNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DatabaseURL;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.WebResourceComment;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;

public class WebResourceCommentImpl
extends CommentImpl
implements WebResourceComment {
    private DatabaseName name = DefaultCommentFactory.getInstance().buildDatabaseName();
    private DatabaseNote note = DefaultCommentFactory.getInstance().buildDatabaseNote();
    private DatabaseURL url = DefaultCommentFactory.getInstance().buildDatabaseURL();
    private DatabaseFTP ftp = DefaultCommentFactory.getInstance().buildDatabaseFTP();

    public WebResourceCommentImpl() {
        this.setCommentType(CommentType.WEBRESOURCE);
    }

    public WebResourceCommentImpl(WebResourceComment copy) {
        super(copy);
        if (copy.getDatabaseName() != null) {
            this.name = DefaultCommentFactory.getInstance().buildDatabaseName(copy.getDatabaseName());
        }
        if (copy.getDatabaseNote() != null) {
            this.note = DefaultCommentFactory.getInstance().buildDatabaseNote(copy.getDatabaseNote());
        }
        if (copy.getDatabaseURL() != null) {
            this.url = DefaultCommentFactory.getInstance().buildDatabaseURL(copy.getDatabaseURL());
        }
        if (copy.getDatabaseFTP() != null) {
            this.ftp = DefaultCommentFactory.getInstance().buildDatabaseFTP(copy.getDatabaseFTP());
        }
        this.setCommentType(CommentType.WEBRESOURCE);
    }

    @Override
    public DatabaseName getDatabaseName() {
        return this.name;
    }

    @Override
    public void setDatabaseName(DatabaseName name) {
        this.name = name;
    }

    @Override
    public boolean hasDatabaseName() {
        return this.name != null && !this.name.getValue().equals("");
    }

    @Override
    public DatabaseNote getDatabaseNote() {
        return this.note;
    }

    @Override
    public void setDatabaseNote(DatabaseNote note) {
        this.note = note;
    }

    @Override
    public boolean hasDatabaseNote() {
        return this.note != null && !this.note.getValue().equals("");
    }

    @Override
    public DatabaseURL getDatabaseURL() {
        return this.url;
    }

    @Override
    public void setDatabaseFTP(DatabaseFTP databaseFTP) {
        this.ftp = databaseFTP;
    }

    @Override
    public boolean hasDatabaseURL() {
        return this.url != null && !this.url.getValue().equals("");
    }

    @Override
    public DatabaseFTP getDatabaseFTP() {
        return this.ftp;
    }

    @Override
    public void setDatabaseURL(DatabaseURL databaseURL) {
        this.url = databaseURL;
    }

    @Override
    public boolean hasDatabaseFTP() {
        return this.ftp != null && !this.ftp.getValue().equals("");
    }

    @Override
    public void setUri(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        if (uri.startsWith("ftp")) {
            this.setDatabaseFTP(DefaultCommentFactory.getInstance().buildDatabaseFTP(uri));
        } else {
            this.setDatabaseURL(DefaultCommentFactory.getInstance().buildDatabaseURL(uri));
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ftp == null ? 0 : this.ftp.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.note == null ? 0 : this.note.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebResourceCommentImpl other = (WebResourceCommentImpl)obj;
        if (this.ftp == null ? other.ftp != null : !this.ftp.equals(other.ftp)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.note == null ? other.note != null : !this.note.equals(other.note)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        sb.append("\n");
        WebResourceCommentImpl dbComment = this;
        sb.append("CC   -!- ");
        sb.append(dbComment.getCommentType().toDisplayName());
        String molecule = this.getMolecule();
        if (molecule != null && !molecule.isEmpty()) {
            sb.append(": ").append(molecule);
        }
        sb.append(": NAME=");
        sb.append(dbComment.getDatabaseName().getValue());
        sb.append(";");
        if (dbComment.getDatabaseNote() != null && sb.length() + dbComment.getDatabaseNote().getValue().length() > 75) {
            if (dbComment.getDatabaseNote() != null && dbComment.getDatabaseNote().getValue().length() > 0) {
                sb.append("\nCC       NOTE=");
                sb.append(dbComment.getDatabaseNote().getValue());
                sb.append(";");
            }
        } else if (dbComment.getDatabaseNote() != null && dbComment.getDatabaseNote().getValue().length() > 0) {
            sb.append(" NOTE=");
            sb.append(dbComment.getDatabaseNote().getValue());
            sb.append(";");
        }
        if (dbComment.getDatabaseURL() != null && !dbComment.getDatabaseURL().getValue().equals("")) {
            sb.append("\nCC       WWW=\"");
            sb.append(dbComment.getDatabaseURL().getValue());
            sb.append("\".");
        }
        if (dbComment.getDatabaseFTP() != null && !dbComment.getDatabaseFTP().getValue().equals("")) {
            sb.append("\nCC       FTP=\"");
            sb.append(dbComment.getDatabaseFTP().getValue());
            sb.append("\".");
        }
        return sb.toString();
    }

    @Override
    public Collection<EvidenceId> collectEvidences() {
        return Collections.emptySet();
    }
}

