/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.interpro;

import uk.ac.ebi.kraken.interfaces.interpro.Method;
import uk.ac.ebi.kraken.interfaces.interpro.MethodAccession;
import uk.ac.ebi.kraken.interfaces.interpro.MethodName;
import uk.ac.ebi.kraken.interfaces.interpro.MethodType;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultInterProFactory;

public class MethodImpl
implements Method,
PersistentObject {
    private MethodName name;
    private MethodAccession accession;
    private MethodType type;
    private long id;

    public MethodImpl() {
        this.name = DefaultInterProFactory.getInstance().buildMethodName();
        this.accession = DefaultInterProFactory.getInstance().buildMethodAccession();
        this.type = MethodType.UNKNOWN;
    }

    public MethodImpl(Method copy) {
        if (copy == null) {
            throw new IllegalArgumentException();
        }
        this.name = DefaultInterProFactory.getInstance().buildMethodName(copy.getName());
        this.accession = DefaultInterProFactory.getInstance().buildMethodAccession(copy.getAccession());
        this.type = copy.getType();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public MethodName getName() {
        return this.name;
    }

    @Override
    public void setName(MethodName name) {
        this.name = name;
    }

    @Override
    public MethodAccession getAccession() {
        return this.accession;
    }

    @Override
    public void setAccession(MethodAccession ac) {
        this.accession = ac;
    }

    @Override
    public MethodType getType() {
        return this.type;
    }

    @Override
    public void setType(MethodType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodImpl)) {
            return false;
        }
        MethodImpl method = (MethodImpl)o;
        if (this.accession != null ? !this.accession.equals(method.accession) : method.accession != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals((Object)method.type) : method.type != null);
    }

    public int hashCode() {
        int result = this.accession != null ? this.accession.hashCode() : 0;
        result = 29 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MethodImpl[" + this.name + ", " + this.accession + ", " + (Object)((Object)this.type) + "]";
    }
}

