/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.interpro;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import uk.ac.ebi.kraken.interfaces.interpro.Abstract;
import uk.ac.ebi.kraken.interfaces.interpro.InterProAc;
import uk.ac.ebi.kraken.interfaces.interpro.InterProGroup;
import uk.ac.ebi.kraken.interfaces.interpro.InterProType;
import uk.ac.ebi.kraken.interfaces.interpro.Name;
import uk.ac.ebi.kraken.interfaces.interpro.ShortName;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtAccession;
import uk.ac.ebi.kraken.model.annotations.IndexThisField;
import uk.ac.ebi.kraken.model.factories.DefaultInterProFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.serialize.DefaultInterProGroupSerializer;
import uk.ac.ebi.kraken.model.util.IndexField;

public class InterProGroupImpl
implements InterProGroup,
Externalizable {
    private long id;
    private Abstract entryAbstract;
    private Name name;
    private InterProAc interProAc;
    private ShortName shortName;
    private UniProtAccession uniProtAccession;
    private InterProType type;

    public InterProGroupImpl() {
        this.entryAbstract = DefaultInterProFactory.getInstance().buildAbstract("");
        this.name = DefaultInterProFactory.getInstance().buildName("");
        this.interProAc = DefaultInterProFactory.getInstance().buildInterProAc("");
        this.shortName = DefaultInterProFactory.getInstance().buildShortName("");
        this.uniProtAccession = DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession("");
        this.type = InterProType.UNKNOWN;
    }

    public InterProGroupImpl(InterProGroup copy) {
        this.entryAbstract = DefaultInterProFactory.getInstance().buildAbstract(copy.getEntryAbstract().getValue());
        this.name = DefaultInterProFactory.getInstance().buildName(copy.getName().getValue());
        this.interProAc = DefaultInterProFactory.getInstance().buildInterProAc(copy.getInterProAc().getValue());
        this.shortName = DefaultInterProFactory.getInstance().buildShortName(copy.getShortName().getValue());
        this.type = copy.getType();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    @IndexThisField(fieldName={IndexField.INTERPRO_GROUP})
    public Abstract getEntryAbstract() {
        return this.entryAbstract;
    }

    @Override
    public void setEntryAbstract(Abstract entryAbstract) {
        this.entryAbstract = entryAbstract;
    }

    @Override
    @IndexThisField(fieldName={IndexField.INTERPRO_GROUP})
    public Name getName() {
        return this.name;
    }

    @Override
    public void setName(Name name) {
        this.name = name;
    }

    @Override
    @IndexThisField(fieldName={IndexField.INTERPRO_GROUP, IndexField.INTERPRO_GROUP_ACC})
    public InterProAc getInterProAc() {
        return this.interProAc;
    }

    @Override
    public void setInterProAc(InterProAc ac) {
        this.interProAc = ac;
    }

    @Override
    @IndexThisField(fieldName={IndexField.INTERPRO_GROUP})
    public ShortName getShortName() {
        return this.shortName;
    }

    @Override
    public void setShortName(ShortName shortName) {
        this.shortName = shortName;
    }

    @Override
    public InterProType getType() {
        return this.type;
    }

    @Override
    public void setType(InterProType type) {
        this.type = type;
    }

    public String toString() {
        return "InterProGroupImpl[" + this.interProAc + ", " + this.name + ", " + this.shortName + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterProGroupImpl that = (InterProGroupImpl)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.entryAbstract != null ? !this.entryAbstract.equals(that.entryAbstract) : that.entryAbstract != null) {
            return false;
        }
        if (this.interProAc != null ? !this.interProAc.equals(that.interProAc) : that.interProAc != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.shortName != null ? !this.shortName.equals(that.shortName) : that.shortName != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.entryAbstract != null ? this.entryAbstract.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.interProAc != null ? this.interProAc.hashCode() : 0);
        result = 31 * result + (this.shortName != null ? this.shortName.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        new DefaultInterProGroupSerializer().writeObject(this, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new DefaultInterProGroupSerializer().readObject(this, in);
    }

    @Override
    public UniProtAccession getUniProtAccession() {
        return this.uniProtAccession;
    }

    @Override
    public void setUniProtAccession(UniProtAccession uniProtAccession) {
        this.uniProtAccession = uniProtAccession;
    }
}

