/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.go;

import java.util.regex.Pattern;
import uk.ac.ebi.kraken.interfaces.go.GoEcoEvidence;

public class GoEcoEvidenceImpl
implements GoEcoEvidence {
    private String ecoEvidence;
    private static final Pattern ecoEvidencePattern = Pattern.compile("ECO:\\d{7}");

    public GoEcoEvidenceImpl() {
        this.ecoEvidence = null;
    }

    public GoEcoEvidenceImpl(String ecoEvidence) {
        this.setValue(ecoEvidence);
    }

    @Override
    public String getValue() {
        return this.ecoEvidence;
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Null is not an acceptable ECO evidence value");
        }
        if (!ecoEvidencePattern.matcher(value).matches()) {
            throw new IllegalArgumentException("Provided value: " + this.ecoEvidence + " does not match the ECO code pattern");
        }
        this.ecoEvidence = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GoEcoEvidenceImpl)) {
            return false;
        }
        GoEcoEvidenceImpl that = (GoEcoEvidenceImpl)o;
        return !(this.ecoEvidence != null ? !this.ecoEvidence.equals(that.ecoEvidence) : that.ecoEvidence != null);
    }

    public int hashCode() {
        return this.ecoEvidence != null ? this.ecoEvidence.hashCode() : 0;
    }

    public String toString() {
        return "GoEcoEvidenceImpl{ecoEvidence='" + this.ecoEvidence + '\'' + '}';
    }
}

