/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.factories;

import uk.ac.ebi.kraken.interfaces.common.Database;
import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.interfaces.factories.UniRefFactory;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabase;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabaseType;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabaseVersion;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntryId;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntryName;
import uk.ac.ebi.kraken.interfaces.uniref.member.MemberId;
import uk.ac.ebi.kraken.interfaces.uniref.member.NCBITaxonomy;
import uk.ac.ebi.kraken.interfaces.uniref.member.OverlapRegion;
import uk.ac.ebi.kraken.interfaces.uniref.member.ProteinName;
import uk.ac.ebi.kraken.interfaces.uniref.member.SourceOrganism;
import uk.ac.ebi.kraken.interfaces.uniref.member.Type;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniParcAccession;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniRefMember;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniRefRepresentativeMember;
import uk.ac.ebi.kraken.model.common.SequenceImpl;
import uk.ac.ebi.kraken.model.factories.DefaultEntryFactory;
import uk.ac.ebi.kraken.model.uniref.UniRefDatabaseImpl;
import uk.ac.ebi.kraken.model.uniref.UniRefDatabaseVersionImpl;
import uk.ac.ebi.kraken.model.uniref.UniRefEntryIdImpl;
import uk.ac.ebi.kraken.model.uniref.UniRefEntryImpl;
import uk.ac.ebi.kraken.model.uniref.UniRefEntryNameImpl;
import uk.ac.ebi.kraken.model.uniref.member.MemberIdImpl;
import uk.ac.ebi.kraken.model.uniref.member.NCBITaxonomyImpl;
import uk.ac.ebi.kraken.model.uniref.member.OverlapRegionImpl;
import uk.ac.ebi.kraken.model.uniref.member.ProteinNameImpl;
import uk.ac.ebi.kraken.model.uniref.member.SourceOrganismImpl;
import uk.ac.ebi.kraken.model.uniref.member.TypeImpl;
import uk.ac.ebi.kraken.model.uniref.member.UniParcAccessionImpl;
import uk.ac.ebi.kraken.model.uniref.member.UniProtAccessionImpl;
import uk.ac.ebi.kraken.model.uniref.member.UniRefMemberImpl;
import uk.ac.ebi.kraken.model.uniref.member.UniRefRepresentativeMemberImpl;

public class DefaultUniRefFactory
extends DefaultEntryFactory
implements UniRefFactory {
    private static DefaultUniRefFactory singletonInstance;

    protected DefaultUniRefFactory() {
    }

    public static synchronized DefaultUniRefFactory getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new DefaultUniRefFactory();
        }
        return singletonInstance;
    }

    @Override
    public UniRefDatabase buildUniRefDatabase() {
        return new UniRefDatabaseImpl();
    }

    @Override
    public UniRefEntry buildUniRefEntry(UniRefDatabaseType type) {
        UniRefEntryImpl entry = new UniRefEntryImpl();
        entry.getUniRefDatabase().setType(type);
        return entry;
    }

    public UniRefEntry buildUniRefEntry() {
        UniRefEntryImpl entry = new UniRefEntryImpl();
        return entry;
    }

    @Override
    public UniRefMember buildUniRefMember() {
        return new UniRefMemberImpl();
    }

    @Override
    public UniRefRepresentativeMember buildUniRefRepresentativeMember() {
        return new UniRefRepresentativeMemberImpl();
    }

    @Override
    public UniRefDatabaseVersion buildUniRefDatabaseVersion() {
        return this.buildUniRefDatabaseVersion("");
    }

    @Override
    public UniRefDatabaseVersion buildUniRefDatabaseVersion(String value) {
        UniRefDatabaseVersionImpl result = new UniRefDatabaseVersionImpl();
        if (value != null) {
            result.setValue(value);
        }
        return result;
    }

    @Override
    public UniRefEntryId buildUniRefEntryId() {
        return this.buildUniRefEntryId("");
    }

    @Override
    public UniRefEntryId buildUniRefEntryId(String value) {
        UniRefEntryIdImpl result = new UniRefEntryIdImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public UniRefEntryName buildUniRefEntryName() {
        return this.buildUniRefEntryName("");
    }

    @Override
    public UniRefEntryName buildUniRefEntryName(String value) {
        UniRefEntryNameImpl result = new UniRefEntryNameImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public OverlapRegion buildMemberOverlapRegion() {
        return this.buildMemberOverlapRegion(0, 0);
    }

    @Override
    public OverlapRegion buildMemberOverlapRegion(int start, int end) {
        OverlapRegionImpl result = new OverlapRegionImpl();
        result.setPosition(start, end);
        return result;
    }

    @Override
    public OverlapRegion buildMemberOverlapRegion(String value) {
        OverlapRegionImpl result = new OverlapRegionImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public Type buildMemberType() {
        return this.buildMemberType("");
    }

    @Override
    public Type buildMemberType(String value) {
        TypeImpl result = new TypeImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public MemberId buildMemberId() {
        return new MemberIdImpl();
    }

    @Override
    public MemberId buildMemberId(String value) {
        MemberId result = this.buildMemberId();
        result.setValue(value);
        return result;
    }

    @Override
    public NCBITaxonomy buildMemberNCBITaxonomy() {
        return this.buildMemberNCBITaxonomy("");
    }

    @Override
    public NCBITaxonomy buildMemberNCBITaxonomy(String value) {
        NCBITaxonomyImpl result = new NCBITaxonomyImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public ProteinName buildMemberProteinName() {
        return this.buildMemberProteinName("");
    }

    @Override
    public ProteinName buildMemberProteinName(String value) {
        ProteinNameImpl result = new ProteinNameImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public SourceOrganism buildMemberSourceOrganism() {
        return this.buildMemberSourceOrganism("");
    }

    @Override
    public SourceOrganism buildMemberSourceOrganism(String value) {
        SourceOrganismImpl result = new SourceOrganismImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public UniParcAccession buildMemberUniParcAccession() {
        return this.buildMemberUniParcAccession("");
    }

    @Override
    public UniParcAccession buildMemberUniParcAccession(String value) {
        UniParcAccessionImpl result = new UniParcAccessionImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public UniProtAccession buildMemberUniProtAccession() {
        return this.buildMemberUniProtAccession("");
    }

    @Override
    public UniProtAccession buildMemberUniProtAccession(String value) {
        UniProtAccessionImpl result = new UniProtAccessionImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public Sequence buildSequence(String value) {
        SequenceImpl sequence = new SequenceImpl();
        sequence.setValue(value);
        return sequence;
    }

    @Override
    public Database buildDatabase() {
        throw new IllegalArgumentException("This data type doesn't use a database object");
    }
}

