/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.factories;

import uk.ac.ebi.kraken.interfaces.common.Database;
import uk.ac.ebi.kraken.interfaces.common.NewtTaxon;
import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.interfaces.common.Value;
import uk.ac.ebi.kraken.interfaces.factories.MsdFactory;
import uk.ac.ebi.kraken.interfaces.msd.Author;
import uk.ac.ebi.kraken.interfaces.msd.Chain;
import uk.ac.ebi.kraken.interfaces.msd.ChainId;
import uk.ac.ebi.kraken.interfaces.msd.MsdEntry;
import uk.ac.ebi.kraken.interfaces.msd.MsdId;
import uk.ac.ebi.kraken.model.common.NewtTaxonImpl;
import uk.ac.ebi.kraken.model.common.SequenceImpl;
import uk.ac.ebi.kraken.model.common.ValueImpl;
import uk.ac.ebi.kraken.model.msd.AuthorImpl;
import uk.ac.ebi.kraken.model.msd.ChainIdImpl;
import uk.ac.ebi.kraken.model.msd.ChainImpl;
import uk.ac.ebi.kraken.model.msd.MsdDatabaseImpl;
import uk.ac.ebi.kraken.model.msd.MsdEntryImpl;
import uk.ac.ebi.kraken.model.msd.MsdIdImpl;

public class DefaultMsdFactory
implements MsdFactory {
    private static DefaultMsdFactory singletonInstance;

    protected DefaultMsdFactory() {
    }

    public static DefaultMsdFactory getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new DefaultMsdFactory();
        }
        return singletonInstance;
    }

    @Override
    public MsdEntry buildEntry() {
        return new MsdEntryImpl();
    }

    @Override
    public MsdId buildId(String id) {
        MsdIdImpl msdId = new MsdIdImpl();
        msdId.setValue(id);
        return msdId;
    }

    @Override
    public Chain buildChain() {
        return new ChainImpl();
    }

    @Override
    public ChainId buildChainId(String id) {
        ChainIdImpl chainId = new ChainIdImpl();
        chainId.setValue(id);
        return chainId;
    }

    @Override
    public Author buildAuthor() {
        return new AuthorImpl();
    }

    @Override
    public NewtTaxon buildNewtTaxon(String id) {
        NewtTaxonImpl taxon = new NewtTaxonImpl();
        taxon.setValue(id);
        return taxon;
    }

    public Value buildValue(String value) {
        ValueImpl result = new ValueImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public Sequence buildSequence() {
        return new SequenceImpl();
    }

    @Override
    public Sequence buildSequence(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Sequence result = this.buildSequence();
        result.setValue(value);
        return result;
    }

    @Override
    public Sequence buildSequence(Sequence copy) {
        return new SequenceImpl(copy);
    }

    @Override
    public Database buildDatabase() {
        return new MsdDatabaseImpl();
    }
}

