/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.factories;

import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Absorption;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AbsorptionNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AllergenComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsCommentComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsEvent;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsIsoform;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.BioPhysicoChemicalPropertiesComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.BiotechnologyComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CatalyticActivityCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CautionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Cofactor;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorReference;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentText;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DatabaseFTP;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DatabaseName;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DatabaseNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DatabaseURL;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DevelopmentalStageComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Disease;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseAcronym;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReference;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReferenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DisruptionPhenotypeComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DomainComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Enzyme;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.EnzymeRegulationComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.FunctionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InductionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Interaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionGeneName;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractorAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractorUniProtId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformName;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSequenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSynonym;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameterNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameters;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryCommentNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryCommentSource;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryIsoformId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryRange;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryRangeNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaxVelocityUnit;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaximumVelocity;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstant;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstantUnit;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MiscellaneousComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PAGEDataComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PAGEDataMolecularWeight;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PAGEDataPl;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PHDependence;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PathwayComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PharmaceuticalComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PhysiologicalReaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PolymorphismComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Position;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PtmComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Reaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.ReactionReference;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.ReactionReferenceType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RedoxPotential;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionCommentNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SimilarityComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Substrate;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubunitComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TemperatureDependence;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TissueSpecificityComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.ToxicDoseComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.WebResourceComment;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.AbsorptionImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.AbsorptionNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.AllergenCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.AlternativeProductsCommentCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.AlternativeProductsCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.AlternativeProductsEventImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.AlternativeProductsIsoformImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.BioPhysicoChemicalPropertiesCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.BiotechnologyCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.CatalyticActivityCommentStructuredImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.CautionCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.CofactorCommentStructuredImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.CofactorImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.CofactorNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.CofactorReferenceImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.CommentNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.CommentTextImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DatabaseFTPImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DatabaseNameImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DatabaseNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DatabaseURLImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DevelopmentalStageCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DiseaseAcronymImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DiseaseCommentStructuredImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DiseaseDescriptionImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DiseaseIdImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DiseaseImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DiseaseNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DiseaseReferenceIdImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DiseaseReferenceImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DisruptionPhenotypeCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DomainCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.EnzymeImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.EnzymeRegulationCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.FunctionCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InductionCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InteractionCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InteractionGeneNameImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InteractionImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InteractorAccessionImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InteractorUniProtIdImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.IsoformIdImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.IsoformNameImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.IsoformNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.IsoformSequenceIdImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.IsoformSynonymImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.KineticParameterNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.KineticParametersImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MassSpectrometryCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MassSpectrometryCommentNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MassSpectrometryCommentSourceImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MassSpectrometryIsoformIdImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MassSpectrometryRangeImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MassSpectrometryRangeNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MaxVelocityUnitImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MaximumVelocityImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MichaelisConstantImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MiscellaneousCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PAGEDataCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PAGEDataMolecularWeightImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PAGEDataPlImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PHDependenceImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PathwayCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PharmaceuticalCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PhysiologicalDirectionImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PolymorphismCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PositionImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PtmCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.ReactionImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.ReactionReferenceImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.RedoxPotentialImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.RnaEditingCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.RnaEditingNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SequenceCautionCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SequenceCautionCommentNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SimilarityCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubcellularLocationCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubcellularLocationImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubcellularLocationNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubcellularLocationValueImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubstrateImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubunitCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.TemperatureDependenceImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.TissueSpecificityCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.ToxicDoseCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.WebResourceCommentImpl;

public class DefaultCommentFactory
implements CommentFactory {
    private static DefaultCommentFactory singletonInstance;

    protected DefaultCommentFactory() {
    }

    public static synchronized DefaultCommentFactory getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new DefaultCommentFactory();
        }
        return singletonInstance;
    }

    @Override
    public <T extends Comment> T buildComment(CommentType commentType) {
        CommentImpl result = null;
        switch (commentType) {
            case ALLERGEN: {
                result = new AllergenCommentImpl();
                break;
            }
            case ALTERNATIVE_PRODUCTS: {
                result = new AlternativeProductsCommentImpl();
                break;
            }
            case BIOPHYSICOCHEMICAL_PROPERTIES: {
                result = new BioPhysicoChemicalPropertiesCommentImpl();
                break;
            }
            case BIOTECHNOLOGY: {
                result = new BiotechnologyCommentImpl();
                break;
            }
            case CATALYTIC_ACTIVITY: {
                result = new CatalyticActivityCommentStructuredImpl();
                break;
            }
            case SEQUENCE_CAUTION: {
                result = new SequenceCautionCommentImpl();
                break;
            }
            case COFACTOR: {
                result = new CofactorCommentStructuredImpl();
                break;
            }
            case WEBRESOURCE: {
                result = new WebResourceCommentImpl();
                break;
            }
            case DEVELOPMENTAL_STAGE: {
                result = new DevelopmentalStageCommentImpl();
                break;
            }
            case DISEASE: {
                result = new DiseaseCommentStructuredImpl();
                break;
            }
            case DOMAIN: {
                result = new DomainCommentImpl();
                break;
            }
            case ACTIVITY_REGULATION: {
                result = new EnzymeRegulationCommentImpl();
                break;
            }
            case FUNCTION: {
                result = new FunctionCommentImpl();
                break;
            }
            case INDUCTION: {
                result = new InductionCommentImpl();
                break;
            }
            case INTERACTION: {
                result = new InteractionCommentImpl();
                break;
            }
            case MASS_SPECTROMETRY: {
                result = new MassSpectrometryCommentImpl();
                break;
            }
            case MISCELLANEOUS: {
                result = new MiscellaneousCommentImpl();
                break;
            }
            case PATHWAY: {
                result = new PathwayCommentImpl();
                break;
            }
            case PHARMACEUTICAL: {
                result = new PharmaceuticalCommentImpl();
                break;
            }
            case POLYMORPHISM: {
                result = new PolymorphismCommentImpl();
                break;
            }
            case PTM: {
                result = new PtmCommentImpl();
                break;
            }
            case RNA_EDITING: {
                result = new RnaEditingCommentImpl();
                break;
            }
            case SIMILARITY: {
                result = new SimilarityCommentImpl();
                break;
            }
            case SUBCELLULAR_LOCATION: {
                result = new SubcellularLocationCommentImpl();
                break;
            }
            case SUBUNIT: {
                result = new SubunitCommentImpl();
                break;
            }
            case TISSUE_SPECIFICITY: {
                result = new TissueSpecificityCommentImpl();
                break;
            }
            case TOXIC_DOSE: {
                result = new ToxicDoseCommentImpl();
                break;
            }
            case PAGE: {
                result = new PAGEDataCommentImpl();
                break;
            }
            case CAUTION: {
                result = new CautionCommentImpl();
                break;
            }
            case DISRUPTION_PHENOTYPE: {
                result = new DisruptionPhenotypeCommentImpl();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return (T)result;
    }

    @Override
    public <T extends Comment> T buildComment(Comment comment) {
        CommentImpl result = null;
        switch (comment.getCommentType()) {
            case ALLERGEN: {
                result = new AllergenCommentImpl((AllergenComment)comment);
                break;
            }
            case ALTERNATIVE_PRODUCTS: {
                result = new AlternativeProductsCommentImpl((AlternativeProductsComment)comment);
                break;
            }
            case BIOPHYSICOCHEMICAL_PROPERTIES: {
                result = new BioPhysicoChemicalPropertiesCommentImpl((BioPhysicoChemicalPropertiesComment)comment);
                break;
            }
            case BIOTECHNOLOGY: {
                result = new BiotechnologyCommentImpl((BiotechnologyComment)comment);
                break;
            }
            case CATALYTIC_ACTIVITY: {
                result = new CatalyticActivityCommentStructuredImpl((CatalyticActivityCommentStructured)comment);
                break;
            }
            case SEQUENCE_CAUTION: {
                result = new SequenceCautionCommentImpl((SequenceCautionComment)comment);
                break;
            }
            case COFACTOR: {
                result = new CofactorCommentStructuredImpl((CofactorCommentStructured)comment);
                break;
            }
            case WEBRESOURCE: {
                result = new WebResourceCommentImpl((WebResourceComment)comment);
                break;
            }
            case DEVELOPMENTAL_STAGE: {
                result = new DevelopmentalStageCommentImpl((DevelopmentalStageComment)comment);
                break;
            }
            case DISEASE: {
                result = new DiseaseCommentStructuredImpl((DiseaseCommentStructured)comment);
                break;
            }
            case DOMAIN: {
                result = new DomainCommentImpl((DomainComment)comment);
                break;
            }
            case ACTIVITY_REGULATION: {
                result = new EnzymeRegulationCommentImpl((EnzymeRegulationComment)comment);
                break;
            }
            case FUNCTION: {
                result = new FunctionCommentImpl((FunctionComment)comment);
                break;
            }
            case INDUCTION: {
                result = new InductionCommentImpl((InductionComment)comment);
                break;
            }
            case INTERACTION: {
                result = new InteractionCommentImpl((InteractionComment)comment);
                break;
            }
            case MASS_SPECTROMETRY: {
                result = new MassSpectrometryCommentImpl((MassSpectrometryComment)comment);
                break;
            }
            case MISCELLANEOUS: {
                result = new MiscellaneousCommentImpl((MiscellaneousComment)comment);
                break;
            }
            case PATHWAY: {
                result = new PathwayCommentImpl((PathwayComment)comment);
                break;
            }
            case PHARMACEUTICAL: {
                result = new PharmaceuticalCommentImpl((PharmaceuticalComment)comment);
                break;
            }
            case POLYMORPHISM: {
                result = new PolymorphismCommentImpl((PolymorphismComment)comment);
                break;
            }
            case PTM: {
                result = new PtmCommentImpl((PtmComment)comment);
                break;
            }
            case RNA_EDITING: {
                result = new RnaEditingCommentImpl((RnaEditingComment)comment);
                break;
            }
            case SIMILARITY: {
                result = new SimilarityCommentImpl((SimilarityComment)comment);
                break;
            }
            case SUBCELLULAR_LOCATION: {
                result = new SubcellularLocationCommentImpl((SubcellularLocationComment)comment);
                break;
            }
            case SUBUNIT: {
                result = new SubunitCommentImpl((SubunitComment)comment);
                break;
            }
            case TISSUE_SPECIFICITY: {
                result = new TissueSpecificityCommentImpl((TissueSpecificityComment)comment);
                break;
            }
            case TOXIC_DOSE: {
                result = new ToxicDoseCommentImpl((ToxicDoseComment)comment);
                break;
            }
            case PAGE: {
                result = new PAGEDataCommentImpl((PAGEDataComment)comment);
                break;
            }
            case CAUTION: {
                result = new CautionCommentImpl((CautionComment)comment);
                break;
            }
            case DISRUPTION_PHENOTYPE: {
                result = new DisruptionPhenotypeCommentImpl((DisruptionPhenotypeComment)comment);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return (T)result;
    }

    @Override
    public PAGEDataPl buildPAGEDataPl() {
        return new PAGEDataPlImpl();
    }

    @Override
    public PAGEDataPl buildPAGEDataPl(String value) {
        return new PAGEDataPlImpl(value);
    }

    @Override
    public PAGEDataMolecularWeight buildPAGEDataMolecularWeight() {
        return new PAGEDataMolecularWeightImpl();
    }

    @Override
    public PAGEDataMolecularWeight buildPAGEDataMolecularWeight(String value) {
        return new PAGEDataMolecularWeightImpl(value);
    }

    @Override
    public AlternativeProductsCommentComment buildAlternativeProductsCommentComment() {
        return new AlternativeProductsCommentCommentImpl();
    }

    @Override
    public AlternativeProductsCommentComment buildAlternativeProductsCommentComment(AlternativeProductsCommentComment copy) {
        if (copy == null) {
            throw new IllegalArgumentException();
        }
        return new AlternativeProductsCommentCommentImpl(copy);
    }

    @Override
    public AlternativeProductsEvent buildAlternativeProductsEvent() {
        return new AlternativeProductsEventImpl();
    }

    @Override
    public AlternativeProductsEvent buildAlternativeProductsEvent(String event) {
        return new AlternativeProductsEventImpl(event);
    }

    @Override
    public AlternativeProductsEvent buildAlternativeProductsEvent(AlternativeProductsEvent copy) {
        return new AlternativeProductsEventImpl(copy);
    }

    @Override
    public AlternativeProductsIsoform buildAlternativeProductsIsoform() {
        return new AlternativeProductsIsoformImpl();
    }

    @Override
    public AlternativeProductsIsoform buildAlternativeProductsIsoform(AlternativeProductsIsoform copy) {
        return new AlternativeProductsIsoformImpl(copy);
    }

    @Override
    public InteractorAccession buildIntActAccession(String acc) {
        InteractorAccessionImpl result = new InteractorAccessionImpl();
        result.setValue(acc);
        return result;
    }

    @Override
    public InteractorAccession buildIntActAccession() {
        return this.buildIntActAccession("");
    }

    @Override
    public InteractorAccession buildIntActAccession(InteractorAccession copy) {
        return new InteractorAccessionImpl(copy);
    }

    @Override
    public InteractionGeneName buildInteractionGeneName(String geneName) {
        InteractionGeneNameImpl result = new InteractionGeneNameImpl();
        result.setValue(geneName);
        return result;
    }

    @Override
    public InteractionGeneName buildInteractionGeneName() {
        return this.buildInteractionGeneName("");
    }

    @Override
    public InteractionGeneName buildInteractionGeneName(InteractionGeneName copy) {
        return new InteractionGeneNameImpl(copy);
    }

    @Override
    public Interaction buildInteraction() {
        return new InteractionImpl();
    }

    @Override
    public Interaction buildInteraction(Interaction copy) {
        return new InteractionImpl(copy);
    }

    @Override
    public InteractorUniProtId buildInteractorUniProtId(String acc) {
        InteractorUniProtIdImpl result = new InteractorUniProtIdImpl();
        result.setValue(acc);
        return result;
    }

    @Override
    public InteractorUniProtId buildInteractorUniProtId() {
        return this.buildInteractorUniProtId("");
    }

    @Override
    public InteractorUniProtId buildInteractorUniProtId(InteractorUniProtId copy) {
        return new InteractorUniProtIdImpl(copy);
    }

    @Override
    public MassSpectrometryCommentNote buildMassSpectrometryCommentNote(String note) {
        MassSpectrometryCommentNoteImpl result = new MassSpectrometryCommentNoteImpl();
        result.setValue(note);
        return result;
    }

    @Override
    public MassSpectrometryCommentNote buildMassSpectrometryCommentNote() {
        return this.buildMassSpectrometryCommentNote("");
    }

    @Override
    public MassSpectrometryCommentNote buildMassSpectrometryCommentNote(MassSpectrometryCommentNote copy) {
        return new MassSpectrometryCommentNoteImpl(copy);
    }

    @Override
    public MassSpectrometryRangeNote buildMassSpectrometryRangeNote(String note) {
        MassSpectrometryRangeNoteImpl result = new MassSpectrometryRangeNoteImpl();
        result.setValue(note);
        return result;
    }

    @Override
    public MassSpectrometryRangeNote buildMassSpectrometryRangeNote() {
        return this.buildMassSpectrometryRangeNote("");
    }

    @Override
    public MassSpectrometryRangeNote buildMassSpectrometryRangeNote(MassSpectrometryRangeNote copy) {
        return new MassSpectrometryRangeNoteImpl(copy);
    }

    @Override
    public MassSpectrometryRange buildMassSpectrometryRange() {
        return new MassSpectrometryRangeImpl();
    }

    @Override
    public MassSpectrometryRange buildMassSpectrometryRange(MassSpectrometryRange copy) {
        return new MassSpectrometryRangeImpl(copy);
    }

    @Override
    public Absorption buildAbsorption() {
        return new AbsorptionImpl();
    }

    @Override
    public Absorption buildAbsorption(boolean isApproximate, int max, String note) {
        AbsorptionImpl result = new AbsorptionImpl();
        result.setApproximation(isApproximate);
        result.setMax(max);
        AbsorptionNote aNote = this.buildAbsorptionNote();
        EvidencedValue evVal = DefaultUniProtFactory.getInstance().buildEvidencedValue();
        evVal.setValue(note);
        aNote.getTexts().add(evVal);
        result.setNote(aNote);
        return result;
    }

    @Override
    public Absorption buildAbsorption(Absorption copy) {
        return new AbsorptionImpl(copy);
    }

    @Override
    public AbsorptionNote buildAbsorptionNote() {
        return new AbsorptionNoteImpl();
    }

    @Override
    public AbsorptionNote buildAbsorptionNote(AbsorptionNote copy) {
        return new AbsorptionNoteImpl(copy);
    }

    @Override
    public PHDependence buildPHDependence() {
        return new PHDependenceImpl();
    }

    @Override
    public PHDependence buildPHDependence(PHDependence copy) {
        return new PHDependenceImpl(copy);
    }

    @Override
    public RedoxPotential buildRedoxPotential() {
        return new RedoxPotentialImpl();
    }

    @Override
    public RedoxPotential buildRedoxPotential(RedoxPotential copy) {
        return new RedoxPotentialImpl(copy);
    }

    @Override
    public TemperatureDependence buildTemperatureDependence() {
        return new TemperatureDependenceImpl();
    }

    @Override
    public TemperatureDependence buildTemperatureDependence(TemperatureDependence copy) {
        return new TemperatureDependenceImpl(copy);
    }

    @Override
    public Substrate buildSubstrate(String value) {
        SubstrateImpl result = new SubstrateImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public Substrate buildSubstrate() {
        return this.buildSubstrate("");
    }

    @Override
    public Substrate buildSubstrate(Substrate copy) {
        return new SubstrateImpl(copy);
    }

    @Override
    public Enzyme buildEnzyme(String value) {
        EnzymeImpl result = new EnzymeImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public Enzyme buildEnzyme() {
        return this.buildEnzyme("");
    }

    @Override
    public Enzyme buildEnzyme(Enzyme copy) {
        return new EnzymeImpl(copy);
    }

    @Override
    public MaximumVelocity buildMaximumVelocity() {
        return new MaximumVelocityImpl();
    }

    @Override
    public MaximumVelocity buildMaximumVelocity(MaximumVelocity copy) {
        return new MaximumVelocityImpl(copy);
    }

    @Override
    public KineticParameterNote buildKineticParameterNote() {
        return new KineticParameterNoteImpl();
    }

    @Override
    public KineticParameterNote buildKineticParameterNote(KineticParameterNote copy) {
        return new KineticParameterNoteImpl(copy);
    }

    @Override
    public KineticParameters buildKineticParameters() {
        return new KineticParametersImpl();
    }

    @Override
    public KineticParameters buildKineticParameters(KineticParameters copy) {
        return new KineticParametersImpl(copy);
    }

    @Override
    public MichaelisConstant buildMichaelisConstant() {
        return new MichaelisConstantImpl();
    }

    @Override
    public MichaelisConstant buildMichaelisConstant(float constant, MichaelisConstantUnit unit, String substrate) {
        MichaelisConstantImpl result = new MichaelisConstantImpl();
        result.setConstant(constant);
        result.setUnit(unit);
        result.setSubstrate(this.buildSubstrate(substrate));
        return result;
    }

    @Override
    public MichaelisConstant buildMichaelisConstant(MichaelisConstant copy) {
        return new MichaelisConstantImpl(copy);
    }

    @Override
    public DatabaseName buildDatabaseName() {
        return new DatabaseNameImpl();
    }

    @Override
    public DatabaseName buildDatabaseName(String name) {
        DatabaseNameImpl result = new DatabaseNameImpl();
        result.setValue(name);
        return result;
    }

    @Override
    public DatabaseName buildDatabaseName(DatabaseName copy) {
        return new DatabaseNameImpl(copy);
    }

    @Override
    public DatabaseNote buildDatabaseNote() {
        return new DatabaseNoteImpl();
    }

    @Override
    public DatabaseNote buildDatabaseNote(String note) {
        DatabaseNoteImpl result = new DatabaseNoteImpl();
        result.setValue(note);
        return result;
    }

    @Override
    public DatabaseNote buildDatabaseNote(DatabaseNote copy) {
        return new DatabaseNoteImpl(copy);
    }

    @Override
    public DatabaseURL buildDatabaseURL() {
        return new DatabaseURLImpl();
    }

    @Override
    public DatabaseURL buildDatabaseURL(String www) {
        DatabaseURLImpl result = new DatabaseURLImpl();
        result.setValue(www);
        return result;
    }

    @Override
    public DatabaseURL buildDatabaseURL(DatabaseURL copy) {
        return new DatabaseURLImpl(copy);
    }

    @Override
    public DatabaseFTP buildDatabaseFTP() {
        return new DatabaseFTPImpl();
    }

    @Override
    public DatabaseFTP buildDatabaseFTP(String ftp) {
        DatabaseFTPImpl result = new DatabaseFTPImpl();
        result.setValue(ftp);
        return result;
    }

    @Override
    public DatabaseFTP buildDatabaseFTP(DatabaseFTP copy) {
        return new DatabaseFTPImpl(copy);
    }

    @Override
    public IsoformId buildIsoformId() {
        return new IsoformIdImpl();
    }

    @Override
    public IsoformId buildIsoformId(String value) {
        IsoformIdImpl result = new IsoformIdImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public IsoformId buildIsoformId(IsoformId copy) {
        return new IsoformIdImpl(copy);
    }

    @Override
    public IsoformName buildIsoformName() {
        return new IsoformNameImpl();
    }

    @Override
    public IsoformName buildIsoformName(String value) {
        IsoformNameImpl result = new IsoformNameImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public IsoformName buildIsoformName(IsoformName copy) {
        return new IsoformNameImpl(copy);
    }

    @Override
    public IsoformNote buildIsoformNote() {
        return new IsoformNoteImpl();
    }

    @Override
    public IsoformNote buildIsoformNote(IsoformNote copy) {
        return new IsoformNoteImpl(copy);
    }

    @Override
    public IsoformSequenceId buildIsoformSequenceId() {
        return new IsoformSequenceIdImpl();
    }

    @Override
    public IsoformSequenceId buildIsoformSequenceId(String value) {
        IsoformSequenceIdImpl result = new IsoformSequenceIdImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public IsoformSequenceId buildIsoformSequenceId(IsoformSequenceId copy) {
        return new IsoformSequenceIdImpl(copy);
    }

    @Override
    public IsoformSynonym buildIsoformSynonym() {
        return new IsoformSynonymImpl();
    }

    @Override
    public IsoformSynonym buildIsoformSynonym(String value) {
        IsoformSynonymImpl result = new IsoformSynonymImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public IsoformSynonym buildIsoformSynonym(IsoformSynonym copy) {
        return new IsoformSynonymImpl(copy);
    }

    @Override
    public SequenceCautionCommentNote buildSequenceCautionCommentNote() {
        return new SequenceCautionCommentNoteImpl();
    }

    @Override
    public SequenceCautionCommentNote buildSequenceCautionCommentNote(String note) {
        return new SequenceCautionCommentNoteImpl(note);
    }

    @Override
    public MassSpectrometryCommentSource buildMassSpectrometryCommentSource() {
        return new MassSpectrometryCommentSourceImpl();
    }

    @Override
    public MassSpectrometryIsoformId buildMassSpectrometryIsoformId() {
        return new MassSpectrometryIsoformIdImpl();
    }

    @Override
    public MassSpectrometryCommentSource buildMassSpectrometryCommentSource(String value) {
        return new MassSpectrometryCommentSourceImpl(value);
    }

    @Override
    public MassSpectrometryCommentSource buildMassSpectrometryCommentSourceFromAttribute(String value) {
        String new1 = value.replace("=", ":");
        String new2 = new1.replace("Reference:", "Ref.");
        return new MassSpectrometryCommentSourceImpl(new2);
    }

    @Override
    public RnaEditingNote buildRnaEditingNote() {
        return new RnaEditingNoteImpl();
    }

    @Override
    public RnaEditingComment buildRnaEditingComment() {
        return new RnaEditingCommentImpl();
    }

    @Override
    public MassSpectrometryCommentSource buildMassSpectrometryCommentSource(MassSpectrometryCommentSource value) {
        return new MassSpectrometryCommentSourceImpl(value);
    }

    @Override
    public MassSpectrometryIsoformId buildMassSpectrometryIsoformId(String value) {
        return new MassSpectrometryIsoformIdImpl(value);
    }

    @Override
    public MassSpectrometryIsoformId buildMassSpectrometryIsoformId(MassSpectrometryIsoformId value) {
        return new MassSpectrometryIsoformIdImpl(value);
    }

    @Override
    public SubcellularLocation buildSubcellularLocation() {
        return new SubcellularLocationImpl();
    }

    @Override
    public SubcellularLocationValue buildSubcellularLocationValue() {
        return new SubcellularLocationValueImpl();
    }

    @Override
    public Position buildRnaEditingPosition() {
        return new PositionImpl();
    }

    @Override
    public DiseaseNote buildDiseaseNote() {
        return new DiseaseNoteImpl();
    }

    @Override
    public DiseaseNote buildDiseaseNote(DiseaseNote copy) {
        return new DiseaseNoteImpl(copy);
    }

    @Override
    public Disease buildDisease() {
        return new DiseaseImpl();
    }

    @Override
    public Disease buildDisease(Disease copy) {
        return new DiseaseImpl(copy);
    }

    @Override
    public DiseaseId buildDiseaseId() {
        return new DiseaseIdImpl();
    }

    @Override
    public DiseaseId buildDiseaseId(DiseaseId copy) {
        return new DiseaseIdImpl(copy);
    }

    @Override
    public DiseaseAcronym buildDiseaseAcronym() {
        return new DiseaseAcronymImpl();
    }

    @Override
    public DiseaseAcronym buildDiseaseAcronym(DiseaseAcronym copy) {
        return new DiseaseAcronymImpl(copy);
    }

    @Override
    public DiseaseDescription buildDiseaseDescription() {
        return new DiseaseDescriptionImpl();
    }

    @Override
    public DiseaseDescription buildDiseaseDescription(DiseaseDescription copy) {
        return new DiseaseDescriptionImpl(copy);
    }

    @Override
    public DiseaseReference buildDiseaseReference() {
        return new DiseaseReferenceImpl();
    }

    @Override
    public DiseaseReference buildDiseaseReference(DiseaseReference copy) {
        return new DiseaseReferenceImpl(copy);
    }

    @Override
    public DiseaseReferenceId buildDiseaseReferenceId() {
        return new DiseaseReferenceIdImpl();
    }

    @Override
    public DiseaseReferenceId buildDiseaseReferenceId(DiseaseReferenceId copy) {
        return new DiseaseReferenceIdImpl(copy);
    }

    @Override
    public CommentText buildCommentText() {
        return new CommentTextImpl();
    }

    @Override
    public CommentText buildCommentText(CommentText copy) {
        return new CommentTextImpl(copy);
    }

    @Override
    public CommentNote buildCommentNote() {
        return new CommentNoteImpl();
    }

    @Override
    public CommentNote buildCommentNote(CommentNote copy) {
        return new CommentNoteImpl(copy);
    }

    @Override
    public CofactorReference buildCofactorReference() {
        return new CofactorReferenceImpl();
    }

    @Override
    public CofactorReference buildCofactorReference(CofactorReference copy) {
        return new CofactorReferenceImpl(copy);
    }

    @Override
    public Cofactor buildCofactor() {
        return new CofactorImpl();
    }

    @Override
    public Cofactor buildCofactor(Cofactor copy) {
        return new CofactorImpl(copy);
    }

    @Override
    public CofactorCommentStructured buildCofactorCommentStructured() {
        return new CofactorCommentStructuredImpl();
    }

    @Override
    public CofactorCommentStructured buildCofactorCommentStructured(CofactorCommentStructured copy) {
        return new CofactorCommentStructuredImpl(copy);
    }

    @Override
    public SubcellularLocationNote buildSubcellularLocationNote() {
        return new SubcellularLocationNoteImpl();
    }

    @Override
    public SubcellularLocationNote buildSubcellularLocationNote(SubcellularLocationNote copy) {
        return new SubcellularLocationNoteImpl(copy);
    }

    @Override
    public CofactorNote buildCofactorNote() {
        return new CofactorNoteImpl();
    }

    @Override
    public CofactorNote buildCofactorNote(CofactorNote copy) {
        return new CofactorNoteImpl(copy);
    }

    @Override
    public MaxVelocityUnit buildMaxVelocityUnit() {
        return this.buildMaxVelocityUnit("");
    }

    @Override
    public MaxVelocityUnit buildMaxVelocityUnit(String unit) {
        return new MaxVelocityUnitImpl(unit);
    }

    @Override
    public MaxVelocityUnit buildMaxVelocityUnit(MaxVelocityUnit copy) {
        return new MaxVelocityUnitImpl(copy.getValue());
    }

    @Override
    public Reaction buildReaction() {
        return new ReactionImpl();
    }

    @Override
    public ReactionReference buildReactionReference() {
        return new ReactionReferenceImpl();
    }

    @Override
    public ReactionReference buildReactionReference(ReactionReferenceType type, String id) {
        return new ReactionReferenceImpl(type, id);
    }

    @Override
    public PhysiologicalReaction buildPhysiologicalReaction() {
        return new PhysiologicalDirectionImpl();
    }

    @Override
    public CatalyticActivityCommentStructured buildCatalyticActivityCommentStructured() {
        return new CatalyticActivityCommentStructuredImpl();
    }
}

