/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniprot.dbx.go;

import uk.ac.ebi.kraken.interfaces.annotations.XMLTagName;
import uk.ac.ebi.kraken.interfaces.common.Value;

@XMLTagName(tagName="evidence")
public enum GoEvidenceType implements Value
{
    IDA,
    IMP,
    IGI,
    IPI,
    IEP,
    TAS,
    NAS,
    IC,
    ISS,
    IEA,
    IGC,
    RCA,
    ND,
    EXP,
    IBA,
    IBD,
    IKR,
    IRD,
    ISO,
    ISA,
    ISM,
    HDA,
    HMP,
    HGI,
    HEP,
    HTP,
    UNKNOWN;


    public String getDescription() {
        switch (this) {
            case IDA: {
                return "inferred from direct assay";
            }
            case IMP: {
                return "inferred from mutant phenotype";
            }
            case IGI: {
                return "inferred from genetic interaction";
            }
            case IPI: {
                return "inferred from physical interaction";
            }
            case IEP: {
                return "inferred from expression pattern";
            }
            case TAS: {
                return "traceable author statement";
            }
            case NAS: {
                return "non-traceable author statement";
            }
            case IC: {
                return "inferred by curator";
            }
            case ISS: {
                return "inferred from sequence or structural similarity";
            }
            case IEA: {
                return "inferred from electronic annotation";
            }
            case IGC: {
                return "inferred from Genomic Context";
            }
            case RCA: {
                return "inferred from reviewed computational analysis";
            }
            case ND: {
                return "no biological data available";
            }
            case EXP: {
                return "Inferred from experiment";
            }
            case IBA: {
                return "inferred from Biological aspect of Ancestor";
            }
            case IBD: {
                return "inferred from Biological aspect of Descendant";
            }
            case IKR: {
                return "inferred from Key Residues";
            }
            case IRD: {
                return "inferred from Rapid Divergence";
            }
            case ISO: {
                return "inferred from Sequence Orthology";
            }
            case ISA: {
                return "inferred from Sequence Alignment";
            }
            case ISM: {
                return "inferred from Sequence Model";
            }
            case HDA: {
                return "high throughput direct assay evidence used in manual assertion";
            }
            case HMP: {
                return "high throughput mutant phenotype evidence used in manual assertion";
            }
            case HGI: {
                return "high throughput genetic interaction evidence used in manual assertion";
            }
            case HEP: {
                return "high throughput expression pattern evidence used in manual assertion";
            }
            case HTP: {
                return "high throughput evidence used in manual assertion";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "unknown";
    }

    @Override
    public String getValue() {
        if (this == UNKNOWN) {
            return "";
        }
        return this.name();
    }

    public static GoEvidenceType parseGoEvidenceType(String stringToParse) {
        for (GoEvidenceType enumType : GoEvidenceType.values()) {
            if (!stringToParse.startsWith(enumType.getValue())) continue;
            return enumType;
        }
        throw new IllegalArgumentException("Impossible to Parse " + stringToParse);
    }

    @Override
    public void setValue(String value) {
        throw new IllegalArgumentException();
    }
}

