/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniprot;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCategory;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.DatabaseDefContext;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.DbDisplayOrder;

public enum DatabaseType {
    EMBL("EMBL", 4, DatabaseCategory.SEQUENCE_DATABASES),
    CCDS("CCDS", DatabaseCategory.SEQUENCE_DATABASES),
    PIR("PIR", DatabaseCategory.SEQUENCE_DATABASES),
    REFSEQ("RefSeq", DatabaseCategory.SEQUENCE_DATABASES),
    PDB("PDB", 4, DatabaseCategory.D3_STRUCTURE_DATABASES),
    PDBSUM("PDBsum", DatabaseCategory.D3_STRUCTURE_DATABASES),
    PROTEINMODELPORTAL("ProteinModelPortal", DatabaseCategory.D3_STRUCTURE_DATABASES),
    SMR("SMR", DatabaseCategory.D3_STRUCTURE_DATABASES),
    BIOGRID("BioGRID", DatabaseCategory.PROTEIN_PROTEIN_INTERACTION_DATABASES),
    COMPLEXPORTAL("ComplexPortal", DatabaseCategory.PROTEIN_PROTEIN_INTERACTION_DATABASES),
    CORUM("CORUM", DatabaseCategory.PROTEIN_PROTEIN_INTERACTION_DATABASES),
    DIP("DIP", DatabaseCategory.PROTEIN_PROTEIN_INTERACTION_DATABASES),
    ELM("ELM", DatabaseCategory.PROTEIN_PROTEIN_INTERACTION_DATABASES),
    INTACT("IntAct", DatabaseCategory.PROTEIN_PROTEIN_INTERACTION_DATABASES),
    MINT("MINT", DatabaseCategory.PROTEIN_PROTEIN_INTERACTION_DATABASES),
    STRINGXREF("STRING", DatabaseCategory.PROTEIN_PROTEIN_INTERACTION_DATABASES),
    BINDINGDB("BindingDB", DatabaseCategory.CHEMISTRY),
    CHEMBL("ChEMBL", DatabaseCategory.CHEMISTRY),
    DRUGBANK("DrugBank", DatabaseCategory.CHEMISTRY),
    GUIDETOPHARMACOLOGY("GuidetoPHARMACOLOGY", DatabaseCategory.CHEMISTRY),
    SWISSLIPIDS("SwissLipids", DatabaseCategory.CHEMISTRY),
    ALLERGOME("Allergome", DatabaseCategory.PROTEIN_FAMILY_GROUP_DATABASES),
    CAZY("CAZy", DatabaseCategory.PROTEIN_FAMILY_GROUP_DATABASES),
    DISPROT("DisProt", DatabaseCategory.PROTEIN_FAMILY_GROUP_DATABASES),
    ESTHER("ESTHER", DatabaseCategory.PROTEIN_FAMILY_GROUP_DATABASES),
    IMGT_GENE_DB("IMGT_GENE-DB", DatabaseCategory.PROTEIN_FAMILY_GROUP_DATABASES),
    MEROPS("MEROPS", DatabaseCategory.PROTEIN_FAMILY_GROUP_DATABASES),
    MOONDB("MoonDB", DatabaseCategory.PROTEIN_FAMILY_GROUP_DATABASES),
    MOONPROT("MoonProt", DatabaseCategory.PROTEIN_FAMILY_GROUP_DATABASES),
    MYCOCLAP("CLAE", DatabaseCategory.PROTEIN_FAMILY_GROUP_DATABASES),
    PEROXIBASE("PeroxiBase", DatabaseCategory.PROTEIN_FAMILY_GROUP_DATABASES),
    REBASE("REBASE", DatabaseCategory.PROTEIN_FAMILY_GROUP_DATABASES),
    TCDB("TCDB", DatabaseCategory.PROTEIN_FAMILY_GROUP_DATABASES),
    UNILECTIN("UniLectin", DatabaseCategory.PROTEIN_FAMILY_GROUP_DATABASES),
    CARBONYLDB("CarbonylDB", DatabaseCategory.PTM_DATABASES),
    DEPOD("DEPOD", DatabaseCategory.PTM_DATABASES),
    GLYCONNECT("GlyConnect", DatabaseCategory.PTM_DATABASES),
    IPTMNET("iPTMnet", DatabaseCategory.PTM_DATABASES),
    PHOSPHOSITEPLUS("PhosphoSitePlus", DatabaseCategory.PTM_DATABASES),
    SWISSPALM("SwissPalm", DatabaseCategory.PTM_DATABASES),
    UNICARBKB("UniCarbKB", DatabaseCategory.PTM_DATABASES),
    BIOMUTA("BioMuta", DatabaseCategory.POLYMORPHISM_AND_MUTATION_DATABASES),
    DMDM("DMDM", DatabaseCategory.POLYMORPHISM_AND_MUTATION_DATABASES),
    DBSNP("dbSNP", DatabaseCategory.POLYMORPHISM_AND_MUTATION_DATABASES),
    COMPLUYEAST2DPAGE("COMPLUYEAST-2DPAGE", DatabaseCategory.D2_GEL_DATABASES),
    DOSACCOBS2DPAGE("DOSAC-COBS-2DPAGE", DatabaseCategory.D2_GEL_DATABASES),
    OGP("OGP", DatabaseCategory.D2_GEL_DATABASES),
    REPRODUCTION2DPAGE("REPRODUCTION-2DPAGE", DatabaseCategory.D2_GEL_DATABASES),
    SWISS2DPAGE("SWISS-2DPAGE", DatabaseCategory.D2_GEL_DATABASES),
    UCD2DPAGE("UCD-2DPAGE", DatabaseCategory.D2_GEL_DATABASES),
    WORLD2DPAGE("World-2DPAGE", DatabaseCategory.D2_GEL_DATABASES),
    EPD("EPD", DatabaseCategory.PROTEOMIC_DATABASES),
    MAXQB("MaxQB", DatabaseCategory.PROTEOMIC_DATABASES),
    PAXDB("PaxDb", DatabaseCategory.PROTEOMIC_DATABASES),
    PEPTIDEATLAS("PeptideAtlas", DatabaseCategory.PROTEOMIC_DATABASES),
    PRIDE("PRIDE", DatabaseCategory.PROTEOMIC_DATABASES),
    PROMEX("ProMEX", DatabaseCategory.PROTEOMIC_DATABASES),
    PROTEOMICSDB("ProteomicsDB", DatabaseCategory.PROTEOMIC_DATABASES),
    CTDP("TopDownProteomics", DatabaseCategory.PROTEOMIC_DATABASES),
    JPOST("jPOST", DatabaseCategory.PROTEOMIC_DATABASES),
    CPTAC("CPTAC", DatabaseCategory.PROTEOMIC_DATABASES),
    MASSIVE("MassIVE", DatabaseCategory.PROTEOMIC_DATABASES),
    DNASU("DNASU", DatabaseCategory.PROTOCOLS_AND_MATERIALS_DATABASES),
    ABCD("ABCD", DatabaseCategory.PROTOCOLS_AND_MATERIALS_DATABASES),
    ENSEMBL("Ensembl", 3, DatabaseCategory.GENOME_ANNOTATION_DATABASES),
    ENSEMBLBACTERIA("EnsemblBacteria", 3, DatabaseCategory.GENOME_ANNOTATION_DATABASES),
    ENSEMBLFUNGI("EnsemblFungi", 3, DatabaseCategory.GENOME_ANNOTATION_DATABASES),
    ENSEMBLMETAZOA("EnsemblMetazoa", 3, DatabaseCategory.GENOME_ANNOTATION_DATABASES),
    ENSEMBLPLANTS("EnsemblPlants", 3, DatabaseCategory.GENOME_ANNOTATION_DATABASES),
    ENSEMBLPROTISTS("EnsemblProtists", 3, DatabaseCategory.GENOME_ANNOTATION_DATABASES),
    GENEDB("GeneDB", DatabaseCategory.GENOME_ANNOTATION_DATABASES),
    GENEID("GeneID", DatabaseCategory.GENOME_ANNOTATION_DATABASES),
    GRAMENE("Gramene", 3, DatabaseCategory.GENOME_ANNOTATION_DATABASES),
    KEGG("KEGG", DatabaseCategory.GENOME_ANNOTATION_DATABASES),
    PATRIC("PATRIC", DatabaseCategory.GENOME_ANNOTATION_DATABASES),
    UCSC("UCSC", DatabaseCategory.GENOME_ANNOTATION_DATABASES),
    VECTORBASE("VectorBase", 3, DatabaseCategory.GENOME_ANNOTATION_DATABASES),
    WBPARASITE("WBParaSite", 3, DatabaseCategory.GENOME_ANNOTATION_DATABASES),
    ARACHNOSERVER("ArachnoServer", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    ARAPORT("Araport", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    CGD("CGD", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    CONOSERVER("ConoServer", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    CTD("CTD", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    DICTYBASE("dictyBase", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    DISGENET("DisGeNET", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    ECHOBASE("EchoBASE", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    ECOGENE("EcoGene", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    EUHCVDB("euHCVdb", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    EUPATHDB("EuPathDB", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    FLYBASE("FlyBase", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    GENECARDS("GeneCards", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    GENEREVIEWS("GeneReviews", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    HGNC("HGNC", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    HPA("HPA", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    LEGIOLIST("LegioList", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    LEPROMA("Leproma", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    MAIZEGDB("MaizeGDB", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    MALACARDS("MalaCards", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    MGI("MGI", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    MIM("MIM", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    NEXTPROT("neXtProt", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    NIAGADS("NIAGADS", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    OPENTARGETS("OpenTargets", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    ORPHANET("Orphanet", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    PHARMGKB("PharmGKB", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    POMBASE("PomBase", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    PSEUDOCAP("PseudoCAP", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    RGD("RGD", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    SGD("SGD", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    TAIR("TAIR", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    TUBERCULIST("TubercuList", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    VGNC("VGNC", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    WORMBASE("WormBase", 4, DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    XENBASE("Xenbase", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    ZFIN("ZFIN", DatabaseCategory.ORGANISM_SPECIFIC_DATABASES),
    EGGNOG("eggNOG", DatabaseCategory.PHYLOGENOMIC_DATABASES),
    GENETREE("GeneTree", DatabaseCategory.PHYLOGENOMIC_DATABASES),
    HOGENOM("HOGENOM", DatabaseCategory.PHYLOGENOMIC_DATABASES),
    HOVERGEN("HOVERGEN", DatabaseCategory.PHYLOGENOMIC_DATABASES),
    INPARANOID("InParanoid", DatabaseCategory.PHYLOGENOMIC_DATABASES),
    KO("KO", DatabaseCategory.PHYLOGENOMIC_DATABASES),
    OMA("OMA", DatabaseCategory.PHYLOGENOMIC_DATABASES),
    ORTHODB("OrthoDB", DatabaseCategory.PHYLOGENOMIC_DATABASES),
    PHYLOMEDB("PhylomeDB", DatabaseCategory.PHYLOGENOMIC_DATABASES),
    TREEFAM("TreeFam", DatabaseCategory.PHYLOGENOMIC_DATABASES),
    BIOCYC("BioCyc", DatabaseCategory.ENZYME_AND_PATHWAY_DATABASES),
    BRENDA("BRENDA", DatabaseCategory.ENZYME_AND_PATHWAY_DATABASES),
    REACTOME("Reactome", DatabaseCategory.ENZYME_AND_PATHWAY_DATABASES),
    SABIORK("SABIO-RK", DatabaseCategory.ENZYME_AND_PATHWAY_DATABASES),
    SIGNALINK("SignaLink", DatabaseCategory.ENZYME_AND_PATHWAY_DATABASES),
    SIGNOR("SIGNOR", DatabaseCategory.ENZYME_AND_PATHWAY_DATABASES),
    UNIPATHWAY("UniPathway", DatabaseCategory.ENZYME_AND_PATHWAY_DATABASES),
    PLANTREACTOME("PlantReactome", DatabaseCategory.ENZYME_AND_PATHWAY_DATABASES),
    CHITARS("ChiTaRS", DatabaseCategory.OTHER),
    EVOLUTIONARYTRACE("EvolutionaryTrace", DatabaseCategory.OTHER),
    GENEWIKI("GeneWiki", DatabaseCategory.OTHER),
    GENOMERNAI("GenomeRNAi", DatabaseCategory.OTHER),
    PMAPCUTDB("PMAP-CutDB", DatabaseCategory.OTHER),
    PRO("PRO", DatabaseCategory.OTHER),
    RNACT("RNAct", DatabaseCategory.OTHER),
    BGEE("Bgee", DatabaseCategory.GENE_EXPRESSION_DATABASES),
    CLEANEX("CleanEx", DatabaseCategory.GENE_EXPRESSION_DATABASES),
    COLLECTF("CollecTF", DatabaseCategory.GENE_EXPRESSION_DATABASES),
    EXPRESSIONATLAS("ExpressionAtlas", DatabaseCategory.GENE_EXPRESSION_DATABASES),
    GENEVISIBLE("Genevisible", DatabaseCategory.GENE_EXPRESSION_DATABASES),
    CDD("CDD", 3, DatabaseCategory.FAMILY_AND_DOMAIN_DATABASES),
    GENE3D("Gene3D", 3, DatabaseCategory.FAMILY_AND_DOMAIN_DATABASES),
    HAMAP("HAMAP", 3, DatabaseCategory.FAMILY_AND_DOMAIN_DATABASES),
    INTERPRO("InterPro", DatabaseCategory.FAMILY_AND_DOMAIN_DATABASES),
    PANTHER("PANTHER", 3, DatabaseCategory.FAMILY_AND_DOMAIN_DATABASES),
    PFAM("Pfam", 3, DatabaseCategory.FAMILY_AND_DOMAIN_DATABASES),
    PIRSF("PIRSF", 3, DatabaseCategory.FAMILY_AND_DOMAIN_DATABASES),
    PRINTS("PRINTS", DatabaseCategory.FAMILY_AND_DOMAIN_DATABASES),
    PRODOM("ProDom", 3, DatabaseCategory.FAMILY_AND_DOMAIN_DATABASES),
    SFLD("SFLD", 3, DatabaseCategory.FAMILY_AND_DOMAIN_DATABASES),
    SMART("SMART", 3, DatabaseCategory.FAMILY_AND_DOMAIN_DATABASES),
    SUPFAM("SUPFAM", 3, DatabaseCategory.FAMILY_AND_DOMAIN_DATABASES),
    TIGRFAMS("TIGRFAMs", 3, DatabaseCategory.FAMILY_AND_DOMAIN_DATABASES),
    PROSITE("PROSITE", 3, DatabaseCategory.FAMILY_AND_DOMAIN_DATABASES),
    GO("GO", 3, DatabaseCategory.UNKNOWN),
    GLYCOPROTDB("GlycoProtDB", DatabaseCategory.UNKNOWN),
    PHAROS("Pharos", DatabaseCategory.UNKNOWN),
    DRUGCENTRAL("DrugCentral", DatabaseCategory.UNKNOWN),
    PROTCLUSTDB("ProtClustDB", DatabaseCategory.UNKNOWN),
    PROTEOMES("Proteomes", DatabaseCategory.UNKNOWN),
    PATHWAYCOMMONS("PathwayCommons", DatabaseCategory.UNKNOWN),
    ANTIBODYPEDIA("Antibodypedia", DatabaseCategory.PROTOCOLS_AND_MATERIALS_DATABASES),
    METOSITE("MetOSite", DatabaseCategory.PTM_DATABASES),
    PHI_BASE("PHI-base", DatabaseCategory.OTHER),
    BIOGRID_ORCS("BioGRID-ORCS", DatabaseCategory.OTHER),
    IDEAL("IDEAL", DatabaseCategory.PROTEIN_FAMILY_GROUP_DATABASES),
    UNKNOWN("UNKNOWN", DatabaseCategory.UNKNOWN);

    private String name;
    private String displayName;
    private DatabaseCategory category;
    private DbDisplayOrder database = null;
    private int numberOfAttribute;
    private static List<DatabaseType> orderedValues;
    private static Map<String, DatabaseType> mapName2Type;
    private static Map<String, DatabaseType> mapName2TypeWithUpperCase;

    private DatabaseType(String name, DatabaseCategory category) {
        this(name, 2, category);
    }

    private DatabaseType(String name, int num, DatabaseCategory category) {
        this.name = name;
        this.displayName = name;
        this.numberOfAttribute = num;
        this.category = category;
    }

    public DatabaseCategory getCategory() {
        return this.category;
    }

    public int getNumberOfAttribute() {
        return this.numberOfAttribute;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName + "; ";
    }

    public static List<DatabaseType> getDatabaseTypes(DatabaseCategory category) {
        return Arrays.stream(DatabaseType.values()).filter(val -> val.getCategory() == category).collect(Collectors.toList());
    }

    public static DatabaseType getDatabaseType(String databaseName) {
        DatabaseType type = mapName2Type.get(databaseName);
        if (type != null) {
            return type;
        }
        type = mapName2TypeWithUpperCase.get(databaseName.toUpperCase());
        if (type == null) {
            return UNKNOWN;
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<DatabaseType> getOrderedValues() {
        if (orderedValues != null) return orderedValues;
        Class<DatabaseType> clazz = DatabaseType.class;
        synchronized (DatabaseType.class) {
            if (orderedValues != null) return orderedValues;
            orderedValues = new CopyOnWriteArrayList<DatabaseType>();
            for (DatabaseType type : DatabaseType.values()) {
                orderedValues.add(type);
            }
            Collections.sort(orderedValues, new XRefDBOrder());
            // ** MonitorExit[var0] (shouldn't be in output)
            return orderedValues;
        }
    }

    public DbDisplayOrder getXRefDBDef() {
        if (this.database == null) {
            ServiceLoader<DatabaseDefContext> sLoader = ServiceLoader.load(DatabaseDefContext.class);
            for (DatabaseDefContext cache : sLoader) {
                DbDisplayOrder db;
                if (cache == null || (db = cache.getXRefDBDef(this)) == null) continue;
                this.database = db;
                break;
            }
        }
        return this.database;
    }

    static {
        if (mapName2Type == null) {
            mapName2Type = new ConcurrentHashMap<String, DatabaseType>();
            mapName2TypeWithUpperCase = new ConcurrentHashMap<String, DatabaseType>();
            for (DatabaseType type : DatabaseType.values()) {
                mapName2Type.put(type.getName(), type);
                mapName2TypeWithUpperCase.put(type.getName().toUpperCase(), type);
            }
        }
    }

    private static class XRefDBOrder
    implements Comparator<DatabaseType> {
        private XRefDBOrder() {
        }

        @Override
        public int compare(DatabaseType o1, DatabaseType o2) {
            if (o1.getXRefDBDef() == null && o2.getXRefDBDef() == null) {
                return 0;
            }
            if (o1.getXRefDBDef() == null) {
                return 1;
            }
            if (o2.getXRefDBDef() == null) {
                return -1;
            }
            return o1.getXRefDBDef().getDisplayOrder() - o2.getXRefDBDef().getDisplayOrder();
        }
    }
}

