/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.ft;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.impl.ft.FTLineBuilderHelper;
import uk.ac.ebi.kraken.ffwriter.line.impl.ft.SimpleFeatureLineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ConflictFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ConflictReport;

public class ConflictFeatureLineBuilder
extends SimpleFeatureLineBuilder<ConflictFeature> {
    @Override
    protected List<String> buildFtNoteLines(ConflictFeature f, boolean includeFFMarkings) {
        ArrayList<String> lines = new ArrayList<String>();
        List<String> lines2 = FTLineBuilderHelper.buildNote(f, includeFFMarkings);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines2.size(); ++i) {
            if (i == lines2.size() - 1) {
                sb = new StringBuilder(lines2.get(i));
                continue;
            }
            lines.add(lines2.get(i));
        }
        sb.append(" (");
        sb.append(FTLineBuilderHelper.replaceDoubleQuoteWithDoubleDoubleQuote(this.getStringConflictReports(f)));
        sb.append(")");
        sb.append("\"");
        String[] seps = new String[]{" ", "-", "/"};
        if (includeFFMarkings) {
            lines.addAll(FFLineWrapper.buildLines(sb.toString(), seps, "FT                   ", 80));
        } else {
            lines.add(sb.toString());
        }
        return lines;
    }

    private String getStringConflictReports(ConflictFeature feature) {
        StringBuilder temp = new StringBuilder();
        boolean first = true;
        for (ConflictReport c : feature.getConflictReports()) {
            if (first) {
                first = false;
            } else {
                temp.append("; ");
            }
            temp.append(c.getValue());
        }
        return temp.toString();
    }
}

