/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.cc;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.impl.LineConstant;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CCLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationValue;

public class SubCellCCLineBuilder
extends CCLineBuilderAbstr<SubcellularLocationComment> {
    @Override
    protected List<String> buildCommentLines(SubcellularLocationComment comment, boolean includeFFMarkings, boolean showEvidence) {
        StringBuilder notes;
        StringBuilder sb = new StringBuilder();
        if (includeFFMarkings) {
            this.addFlatFileMarkingsIfRequired(includeFFMarkings, sb);
        }
        this.addCommentTypeName(comment, sb);
        this.addMolecule(comment, sb, true);
        boolean needSpace = false;
        StringBuilder locations = this.buildLocations(comment, comment.getSubcellularLocations(), showEvidence);
        if (locations.length() > 0) {
            if (needSpace) {
                sb.append(" ");
            }
            sb.append((CharSequence)locations);
            needSpace = true;
        }
        if ((notes = this.buildNote(comment, showEvidence)).length() > 0) {
            if (needSpace && !comment.getSubcellularLocationNote().getTexts().isEmpty()) {
                sb.append(" ");
            }
            sb.append((CharSequence)notes);
        }
        if (includeFFMarkings) {
            return FFLineWrapper.buildLines(sb.toString(), LineConstant.SEPS, this.linePrefix, 80);
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(sb.toString());
        return lines;
    }

    private StringBuilder buildNote(SubcellularLocationComment comment, boolean showEvidence) {
        StringBuilder noteBuilder = new StringBuilder();
        if (comment.getSubcellularLocationNote().getTexts().isEmpty()) {
            return noteBuilder;
        }
        noteBuilder.append("Note=");
        boolean isfirst = true;
        for (EvidencedValue val : comment.getSubcellularLocationNote().getTexts()) {
            if (!isfirst) {
                noteBuilder.append(" ");
            }
            noteBuilder.append(val.getValue());
            this.appendIfNot(noteBuilder, '.');
            if (showEvidence && val.getEvidenceIds() != null && !val.getEvidenceIds().isEmpty()) {
                this.addEvidence(val, noteBuilder, showEvidence, ".", "");
            }
            isfirst = false;
        }
        return noteBuilder;
    }

    private StringBuilder buildLocations(Comment comment, List<SubcellularLocation> alocations, boolean showEvidence) {
        StringBuilder builder = new StringBuilder();
        int locationCount = 0;
        for (SubcellularLocation aLocation : alocations) {
            if (aLocation == null) continue;
            if (locationCount > 0) {
                builder.append(". ");
            }
            builder.append((CharSequence)this.buildLocation(comment, aLocation.getLocation(), "", showEvidence));
            builder.append((CharSequence)this.buildLocation(comment, aLocation.getTopology(), "; ", showEvidence));
            builder.append((CharSequence)this.buildLocation(comment, aLocation.getOrientation(), "; ", showEvidence));
            ++locationCount;
        }
        if (locationCount > 0) {
            builder.append(".");
        }
        return builder;
    }

    private StringBuilder buildLocation(Comment comment, SubcellularLocationValue location, String prefix, boolean showEvidence) {
        StringBuilder sb = new StringBuilder();
        if (location != null && location.getValue().length() > 0) {
            sb.append(prefix);
            sb.append(location.getValue());
            if (location.getCommentStatus() != null && location.getCommentStatus() != CommentStatus.NONE && location.getCommentStatus() != CommentStatus.EXPERIMENTAL && location.getCommentStatus() != CommentStatus.OTHER) {
                sb.append(" (").append(location.getCommentStatus().getValue()).append(")");
            }
            if (showEvidence && location.getEvidenceIds() != null && !location.getEvidenceIds().isEmpty()) {
                this.addEvidence(location, sb, showEvidence, "", "");
            }
        }
        return sb;
    }
}

