/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.Organism;

public class OSLineBuilder
extends FFLineBuilderAbstr<Organism>
implements FFLineBuilder<Organism> {
    public OSLineBuilder() {
        super(LineType.OS);
    }

    @Override
    protected FFLine buildLine(Organism f, boolean showEvidence) {
        StringBuilder sb = this.build(f, showEvidence, true);
        List<String> lls = FFLineWrapper.buildLines(sb, " ", this.linePrefix);
        return FFLines.create(lls);
    }

    @Override
    public String buildString(Organism f) {
        return this.build(f, false, false).toString();
    }

    @Override
    public String buildStringWithEvidence(Organism f) {
        return this.build(f, true, false).toString();
    }

    private StringBuilder build(Organism organism, boolean showEvidence, boolean includeFFMarkup) {
        StringBuilder sb = new StringBuilder();
        if (includeFFMarkup) {
            sb.append(this.linePrefix);
        }
        if (organism.getScientificName() != null) {
            sb.append(organism.getScientificName().getValue());
        }
        if (organism.getCommonName() != null && !organism.getCommonName().getValue().equals("")) {
            sb.append(" (");
            sb.append(organism.getCommonName().getValue());
            sb.append(")");
        }
        if (organism.getSynonym() != null && !organism.getSynonym().getValue().equals("")) {
            sb.append(" (");
            sb.append(organism.getSynonym());
            sb.append(")");
        }
        this.appendIfNot(sb, '.');
        return sb;
    }
}

