/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.DatabaseAttribute;
import uk.ac.ebi.kraken.model.uniprot.dbx.DatabaseCrossReferences;

public class DRLineBuilder
extends FFLineBuilderAbstr<Collection<DatabaseCrossReference>>
implements FFLineBuilder<Collection<DatabaseCrossReference>> {
    public DRLineBuilder() {
        super(LineType.DR);
    }

    @Override
    public String buildString(Collection<DatabaseCrossReference> f) {
        List<String> lines = this.buildLine(f, false, false);
        return FFLines.create(lines).toString();
    }

    @Override
    public String buildStringWithEvidence(Collection<DatabaseCrossReference> f) {
        List<String> lines = this.buildLine(f, false, true);
        return FFLines.create(lines).toString();
    }

    @Override
    protected FFLine buildLine(Collection<DatabaseCrossReference> f, boolean showEvidence) {
        List<String> lines = this.buildLine(f, true, showEvidence);
        return FFLines.create(lines);
    }

    private List<String> buildLine(Collection<DatabaseCrossReference> f, boolean includeFFMarkings, boolean showEvidence) {
        DatabaseCrossReferences references = new DatabaseCrossReferences();
        ArrayList<DatabaseCrossReference> allXrefs = new ArrayList<DatabaseCrossReference>();
        allXrefs.addAll(f);
        references.setDBCrossReferences(allXrefs);
        ArrayList<String> lines = new ArrayList<String>();
        for (DatabaseType databaseType : DatabaseType.getOrderedValues()) {
            List<DatabaseCrossReference> listDBXref = references.getDBCrossReferences(databaseType.getName());
            for (DatabaseCrossReference databaseCrossReference : listDBXref) {
                lines.add(this.export(databaseCrossReference, includeFFMarkings, showEvidence));
            }
        }
        return lines;
    }

    public String export(DatabaseCrossReference reference, boolean includeFFMarkings, boolean showEvidence) {
        DatabaseType dbType = reference.getDatabase();
        if (dbType == DatabaseType.EMBL && !includeFFMarkings) {
            return DRLineBuilder.exportEMBLNoFF(reference);
        }
        StringBuilder sb = new StringBuilder();
        if (includeFFMarkings) {
            sb.append(this.linePrefix);
            sb.append(reference.getDatabase().getDisplayName());
        }
        sb.append(reference.getPrimaryId());
        this.append(sb, reference.getDescription(), true, includeFFMarkings);
        this.append(sb, reference.getThird(), reference.hasThird(), includeFFMarkings);
        this.append(sb, reference.getFourth(), reference.hasFourth(), includeFFMarkings);
        if (includeFFMarkings) {
            sb.append(".");
        }
        if (reference.getIsoformId() != null && reference.getIsoformId().getValue() != null && !reference.getIsoformId().getValue().isEmpty()) {
            sb.append(" [").append(reference.getIsoformId().getValue()).append("]");
        }
        return sb.toString();
    }

    private void append(StringBuilder sb, DatabaseAttribute value, boolean hasValue, boolean includeFFMarkings) {
        if (hasValue) {
            if (includeFFMarkings) {
                sb.append(";");
            }
            sb.append(" ");
            sb.append(value.getValue());
        }
    }

    private static String exportEMBLNoFF(DatabaseCrossReference embl) {
        StringBuilder sb = new StringBuilder();
        sb.append(embl.getPrimaryId().getValue());
        sb.append(" ");
        sb.append(embl.getDescription().getValue()).append(" ");
        for (String part : embl.getDescription().getValue().split("\\.")) {
            sb.append(part).append(" ");
        }
        sb.append(" ");
        sb.append(embl.getThird().getValue());
        sb.append(" ");
        sb.append(embl.getFourth().getValue());
        return sb.toString();
    }
}

