/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtAccession;

public class ACLineBuilder
extends FFLineBuilderAbstr<List<UniProtAccession>>
implements FFLineBuilder<List<UniProtAccession>> {
    public ACLineBuilder() {
        super(LineType.AC);
    }

    @Override
    public String buildString(List<UniProtAccession> f) {
        return this.build(f, false).toString();
    }

    @Override
    public String buildStringWithEvidence(List<UniProtAccession> f) {
        return this.build(f, true).toString();
    }

    @Override
    protected FFLine buildLine(List<UniProtAccession> f, boolean showEvidence) {
        StringBuilder sb = this.build(f, true);
        List<String> lls = FFLineWrapper.buildLines(sb, "; ", this.linePrefix);
        return FFLines.create(lls);
    }

    private StringBuilder build(List<UniProtAccession> f, boolean includeFFMarkup) {
        StringBuilder sb = new StringBuilder();
        if (includeFFMarkup) {
            sb.append(this.linePrefix);
        }
        boolean isFirst = true;
        for (UniProtAccession ac : f) {
            if (!isFirst) {
                sb.append("; ");
            }
            sb.append(ac.getValue());
            isFirst = false;
        }
        sb.append(";");
        return sb;
    }
}

