/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter;

import uk.ac.ebi.kraken.ffwriter.EvidenceLine;
import uk.ac.ebi.kraken.ffwriter.line.impl.DELineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntryType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Field;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;

public class DELine {
    private static final DELineBuilder BUILDER = new DELineBuilder();

    public static String export(UniProtEntry entry) {
        return DELine.export(entry.getProteinDescription(), true, entry.getType() == UniProtEntryType.TREMBL);
    }

    public static String export(UniProtEntry entry, boolean addEvidence) {
        return DELine.export(entry.getProteinDescription(), true, entry.getType() == UniProtEntryType.TREMBL, addEvidence);
    }

    public static String export(String name, boolean includeFlatFileMarkings) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append(" ");
        int pointer = name.indexOf(46);
        int dash = name.indexOf(45);
        while (pointer > 0) {
            if (pointer < dash || dash == -1) {
                sb.append(name.substring(0, pointer)).append(" ");
            }
            pointer = name.indexOf(46, pointer + 1);
        }
        return sb.toString();
    }

    public static String export(Name name, boolean includeFlatFileMarkings) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Field field : name.getFields()) {
            if (first) {
                sb.append("RecName: ");
            } else {
                sb.append("         ");
            }
            sb.append(field.getType().getValue()).append("=").append(field.getValue());
            sb.append(";\n");
            first = false;
        }
        return sb.toString();
    }

    public static String export(ProteinDescription description, boolean includeFlatFileMarkings) {
        return DELine.export(description, includeFlatFileMarkings, true);
    }

    public static String export(ProteinDescription description, boolean includeFlatFileMarkings, boolean isTrembl) {
        return DELine.export(description, includeFlatFileMarkings, isTrembl, false);
    }

    public static String export(ProteinDescription description, boolean includeFlatFileMarkings, boolean isTrembl, boolean addEvidence) {
        if (includeFlatFileMarkings) {
            if (addEvidence) {
                return BUILDER.buildWithEvidence(description).toString() + "\n";
            }
            return BUILDER.build(description).toString() + "\n";
        }
        return BUILDER.buildString(description);
    }

    public static String export(Section section, boolean includeFlatFileMarkings) {
        return DELine.export(section, includeFlatFileMarkings, false);
    }

    public static String export(Section section, boolean includeFlatFileMarkings, boolean addEvidence) {
        boolean first;
        StringBuilder sb = new StringBuilder();
        if (!section.getNamesByType(NameType.RECNAME).isEmpty()) {
            for (Name name : section.getNamesByType(NameType.RECNAME)) {
                first = true;
                for (Field field : name.getFields()) {
                    if (includeFlatFileMarkings) {
                        sb.append("DE     ");
                    }
                    if (first) {
                        sb.append("RecName: ");
                    } else {
                        sb.append("         ");
                    }
                    sb.append(field.getType().getValue()).append("=").append(field.getValue());
                    if (addEvidence) {
                        sb.append(EvidenceLine.export(field.getEvidenceIds()));
                    }
                    sb.append(";\n");
                    first = false;
                }
            }
        }
        if (!section.getNamesByType(NameType.ALTNAME).isEmpty()) {
            for (Name name : section.getNamesByType(NameType.ALTNAME)) {
                first = true;
                for (Field field : name.getFields()) {
                    if (includeFlatFileMarkings) {
                        sb.append("DE     ");
                    }
                    if (first) {
                        sb.append("AltName: ");
                    } else {
                        sb.append("         ");
                    }
                    sb.append(field.getType().getValue()).append("=").append(field.getValue());
                    if (addEvidence) {
                        sb.append(EvidenceLine.export(field.getEvidenceIds()));
                    }
                    sb.append(";\n");
                    first = false;
                }
            }
        }
        if (!section.getNamesByType(NameType.SUBNAME).isEmpty()) {
            for (Name name : section.getNamesByType(NameType.SUBNAME)) {
                first = true;
                for (Field field : name.getFields()) {
                    if (includeFlatFileMarkings) {
                        sb.append("DE     ");
                    }
                    if (first) {
                        sb.append("SubName: ");
                    } else {
                        sb.append("         ");
                    }
                    sb.append(field.getType().getValue()).append("=").append(field.getValue());
                    if (addEvidence) {
                        sb.append(EvidenceLine.export(field.getEvidenceIds()));
                    }
                    sb.append(";\n");
                    first = false;
                }
            }
        }
        return sb.toString();
    }
}

