/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.provider.sort;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.comparator.SequenceComparator;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.SequenceTarget;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.ComposedSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.provider.sort.SortTransformationChangeType;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupSortTransformation;

@XmlRootElement
public class SortTransformationProvider
extends AbstractTransformationProvider {
    @XmlElement
    private SequenceTarget sequenceTarget;
    @XmlElement
    private SequenceComparator sequenceComparator;
    @XmlElement
    private boolean descendingSort;

    @Override
    public Validation validate() {
        ArrayList<String> errorList = new ArrayList<String>();
        if (this.sequenceTarget == null) {
            errorList.add("Sequence target is not defined");
        }
        if (this.sequenceComparator == null) {
            errorList.add("Sequence comparator is not defined");
        }
        if (errorList.isEmpty()) {
            return new DefaultValidation(new String[0]);
        }
        return new DefaultValidation(errorList);
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        return SequencesGroupDatasetTransformation.concat(new ComposedSequencesGroupDatasetTransformation(factory, new SequencesGroupSortTransformation(this.sequenceComparator.getComparator(this.sequenceTarget), this.descendingSort, factory)));
    }

    public void setSequenceTarget(SequenceTarget sequenceTarget) {
        if (this.sequenceTarget == null || !this.sequenceTarget.equals((Object)sequenceTarget)) {
            this.sequenceTarget = sequenceTarget;
            this.fireTransformationsConfigurationModelEvent(SortTransformationChangeType.SEQUENCE_TARGET_CHANGED, (Object)this.sequenceTarget);
        }
    }

    public SequenceTarget getSequenceTarget() {
        return this.sequenceTarget;
    }

    public void setSequenceComparator(SequenceComparator sequenceComparator) {
        if (this.sequenceComparator == null || !this.sequenceComparator.equals((Object)sequenceComparator)) {
            this.sequenceComparator = sequenceComparator;
            this.fireTransformationsConfigurationModelEvent(SortTransformationChangeType.SORT_CRITERIA_CHANGED, (Object)this.sequenceComparator);
        }
    }

    public SequenceComparator getSequenceComparator() {
        return this.sequenceComparator;
    }

    public void setDescendingSort(boolean descendingSort) {
        if (this.descendingSort != descendingSort) {
            this.descendingSort = descendingSort;
            this.fireTransformationsConfigurationModelEvent(SortTransformationChangeType.SORT_ORDER_CHANGED, this.descendingSort);
        }
    }

    public boolean isDescendingSort() {
        return this.descendingSort;
    }
}

