/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class NumberedLineReader
implements AutoCloseable {
    private static final Set<String> SUPPORTED_CHARSETS = new HashSet<String>(Arrays.asList("ISO-8859-1", "ISO-8859-13", "ISO-8859-15", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "US-ASCII", "UTF-16", "UTF-16BE", "UTF-16LE", "UTF-32", "UTF-32BE", "UTF-32LE", "UTF-8", "windows-1250", "windows-1251", "windows-1252", "windows-1253", "windows-1254", "windows-1255", "windows-1256", "windows-1257", "windows-1258"));
    private final Charset charset;
    private final Reader input;
    private final LineReader reader;

    public NumberedLineReader(Path file, Charset charset) throws IOException {
        this(Files.newInputStream(file, StandardOpenOption.READ), charset);
    }

    public NumberedLineReader(InputStream input, Charset charset) throws IOException {
        if (charset == null) {
            this.charset = null;
            this.input = new InputStreamReader(input);
            this.reader = new SingleByteByCharLineReader(this.input);
        } else if (NumberedLineReader.isSupported(charset)) {
            if (charset.newEncoder().maxBytesPerChar() == 1.0f) {
                this.charset = charset;
                this.input = new InputStreamReader(input, charset);
                this.reader = new SingleByteByCharLineReader(this.input);
            } else if (NumberedLineReader.isUtf(charset)) {
                BufferedInputStream bufferedInput = new BufferedInputStream(input);
                BomInformation bomInformation = NumberedLineReader.getBomLength(charset, bufferedInput);
                this.charset = bomInformation.getCharset();
                this.input = new InputStreamReader((InputStream)bufferedInput, charset);
                this.reader = new MultipleByteByCharLineReader(this.input, bomInformation.getCharset(), bomInformation.getBomLength());
            } else {
                this.charset = charset;
                this.input = new InputStreamReader(input, charset);
                this.reader = new MultipleByteByCharLineReader(this.input, charset);
            }
        } else {
            throw new IllegalArgumentException("Unsupported charset: " + charset);
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Line readLine() throws IOException {
        return this.reader.readLine();
    }

    private static boolean isSupported(Charset charset) {
        return SUPPORTED_CHARSETS.contains(charset.displayName());
    }

    private static boolean isUtf(Charset charset) {
        return charset.displayName().startsWith("UTF-");
    }

    private static BomInformation getBomLength(Charset charset, InputStream input) throws IOException {
        input.mark(4);
        int bomLength = 0;
        switch (charset.displayName()) {
            case "UTF-8": {
                if (input.read() != 239 || input.read() != 187 || input.read() != 191) break;
                bomLength = 3;
                break;
            }
            case "UTF-16BE": 
            case "UTF-16LE": {
                bomLength = 2;
                break;
            }
            case "UTF-16": {
                int first = input.read();
                int second = input.read();
                if (first == 255 && second == 254) {
                    charset = Charset.forName("UTF-16LE");
                    bomLength = 2;
                    break;
                }
                if (first != 254 || second != 255) break;
                charset = Charset.forName("UTF-16BE");
                bomLength = 2;
                break;
            }
            case "UTF-32BE": 
            case "UTF-32LE": {
                bomLength = 4;
                break;
            }
            case "UTF-32": {
                int first = input.read();
                int second = input.read();
                int third = input.read();
                int fourth = input.read();
                if (first == 255 && second == 254 && third == 0 && fourth == 0) {
                    charset = Charset.forName("UTF-32LE");
                    bomLength = 4;
                    break;
                }
                if (first != 0 || second != 0 || third != 254 || fourth != 255) break;
                charset = Charset.forName("UTF-32BE");
                bomLength = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid charset");
            }
        }
        input.reset();
        return new BomInformation(charset, bomLength);
    }

    @Override
    public void close() {
        try {
            this.input.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class MultiByteByCharLine
    implements Line {
        private final long start;
        private final long textEnd;
        private final int textBytesCount;
        private final byte[] charByteSizes;
        private final String line;
        private final String lineEnding;

        public MultiByteByCharLine(long start, long textEnd, byte[] charByteSizes, String line, String lineEnding) {
            this.start = start;
            this.textEnd = textEnd;
            this.charByteSizes = charByteSizes;
            this.line = line;
            this.lineEnding = lineEnding;
            int textBytesCount = 0;
            int textCharsCount = this.line.length();
            for (int i = 0; i < textCharsCount; ++i) {
                textBytesCount += this.charByteSizes[i];
            }
            this.textBytesCount = textBytesCount;
        }

        @Override
        public long getStart() {
            return this.start;
        }

        @Override
        public long getTextEnd() {
            return this.textEnd;
        }

        @Override
        public String getLine() {
            return this.line;
        }

        @Override
        public String getLineEnding() {
            return this.lineEnding;
        }

        @Override
        public int countTextBytes() {
            return this.textBytesCount;
        }

        private void checkIndexBounds(int index) {
            if (index < 0 || index >= this.countTextChars()) {
                throw new IndexOutOfBoundsException("Invalid char position index: " + index);
            }
        }

        @Override
        public long getCharPosition(int index) {
            this.checkIndexBounds(index);
            return this.start + (long)this.countTextBytesBetween(0, index - 1);
        }

        @Override
        public int countTextBytesBetween(int from, int to) {
            this.checkIndexBounds(from);
            this.checkIndexBounds(to);
            if (from > to) {
                throw new IllegalArgumentException("Invalid bounds: " + from + " - " + to);
            }
            int length = 0;
            for (int i = from; i <= to; ++i) {
                length += this.charByteSizes[i];
            }
            return length;
        }
    }

    private static final class SingleByteByCharLine
    implements Line {
        private final long start;
        private final long textEnd;
        private final String line;
        private final String lineEnding;

        public SingleByteByCharLine(long start, long textEnd, String line, String lineEnding) {
            this.start = start;
            this.textEnd = textEnd;
            this.line = line;
            this.lineEnding = lineEnding;
        }

        @Override
        public long getStart() {
            return this.start;
        }

        @Override
        public long getTextEnd() {
            return this.textEnd;
        }

        @Override
        public String getLine() {
            return this.line;
        }

        @Override
        public String getLineEnding() {
            return this.lineEnding;
        }

        @Override
        public int countTextBytes() {
            return this.line.length();
        }

        private void checkIndexBounds(int index) {
            if (index < 0 || index >= this.countTextChars()) {
                throw new IndexOutOfBoundsException("Invalid char position index: " + index);
            }
        }

        @Override
        public long getCharPosition(int index) {
            this.checkIndexBounds(index);
            return this.start + (long)index;
        }

        @Override
        public int countTextBytesBetween(int from, int to) {
            this.checkIndexBounds(from);
            this.checkIndexBounds(to);
            if (from > to) {
                throw new IllegalArgumentException("Invalid bounds: " + from + " - " + to);
            }
            return to - from + 1;
        }
    }

    public static interface Line {
        public String getLine();

        public String getLineEnding();

        public long getStart();

        public long getTextEnd();

        default public int countTextChars() {
            return this.getLine().length();
        }

        public int countTextBytes();

        public long getCharPosition(int var1);

        public int countTextBytesBetween(int var1, int var2);

        default public int countTextBytesFrom(int index) {
            return this.countTextBytesBetween(index, this.countTextChars() - 1);
        }
    }

    private class MultipleByteByCharLineReader
    implements LineReader {
        private final Reader input;
        private final CharsetEncoder encoder;
        private long charStart;
        private long charEnd;
        private long nextChar;
        private int charLength;

        public MultipleByteByCharLineReader(Reader input, Charset charset) throws IOException {
            this(input, charset, 0);
        }

        public MultipleByteByCharLineReader(Reader input, Charset charset, int initialOffset) throws IOException {
            if (!charset.canEncode()) {
                throw new IllegalArgumentException("Encode not supported for charset: " + charset.displayName());
            }
            this.input = input;
            this.encoder = charset.newEncoder();
            this.charStart = initialOffset;
            this.charEnd = -1L;
            this.nextChar = initialOffset;
            this.charLength = 0;
        }

        private int readChar() throws IOException {
            int read = this.input.read();
            if (read != -1) {
                CharBuffer charBuffer = CharBuffer.wrap(new char[]{(char)read});
                ByteBuffer byteBuffer = this.encoder.encode(charBuffer);
                this.charLength = byteBuffer.rewind().remaining();
                this.charStart = this.nextChar;
                this.charEnd = this.charStart + (long)this.charLength - 1L;
                this.nextChar += (long)this.charLength;
            }
            return read;
        }

        @Override
        public Line readLine() throws IOException {
            int read;
            long start;
            StringBuilder sb = new StringBuilder();
            ArrayList<Integer> lengths = new ArrayList<Integer>();
            long endTextPosition = start = -1L;
            String endLine = null;
            boolean lfRead = false;
            boolean completed = false;
            do {
                if ((read = this.readChar()) == -1) {
                    completed = true;
                    continue;
                }
                if (start == -1L) {
                    start = this.charStart;
                    endTextPosition = this.charEnd;
                }
                lengths.add(this.charLength);
                char cread = (char)read;
                switch (cread) {
                    case '\r': {
                        if (lfRead) {
                            sb.append('\r');
                        }
                        lfRead = true;
                        break;
                    }
                    case '\n': {
                        endLine = lfRead ? "\r\n" : "\n";
                        lfRead = false;
                        completed = true;
                        break;
                    }
                    default: {
                        if (lfRead) {
                            sb.append('\r');
                            lfRead = false;
                        }
                        sb.append(cread);
                        endTextPosition = this.charEnd;
                    }
                }
            } while (!completed);
            if (read == -1 && sb.length() == 0) {
                return null;
            }
            byte[] charLengths = new byte[lengths.size()];
            for (int i = 0; i < lengths.size(); ++i) {
                charLengths[i] = ((Integer)lengths.get(i)).byteValue();
            }
            return new MultiByteByCharLine(start, endTextPosition, charLengths, sb.toString(), endLine);
        }
    }

    private static class SingleByteByCharLineReader
    implements LineReader {
        private final Reader input;
        private long location;

        public SingleByteByCharLineReader(Reader input) throws IOException {
            this.input = input;
            this.location = -1L;
        }

        private int readChar() throws IOException {
            int read = this.input.read();
            if (read != -1) {
                ++this.location;
            }
            return read;
        }

        @Override
        public Line readLine() throws IOException {
            int read;
            long start;
            StringBuilder sb = new StringBuilder();
            long endTextPosition = start = -1L;
            String endLine = null;
            boolean lfRead = false;
            boolean completed = false;
            do {
                if ((read = this.readChar()) == -1) {
                    completed = true;
                    continue;
                }
                if (start == -1L) {
                    start = this.location;
                }
                char cread = (char)read;
                switch (cread) {
                    case '\r': {
                        if (lfRead) {
                            sb.append('\r');
                        }
                        lfRead = true;
                        break;
                    }
                    case '\n': {
                        endLine = lfRead ? "\r\n" : "\n";
                        lfRead = false;
                        completed = true;
                        break;
                    }
                    default: {
                        if (lfRead) {
                            sb.append('\r');
                            lfRead = false;
                        }
                        sb.append(cread);
                        endTextPosition = this.location;
                    }
                }
            } while (!completed);
            if (read == -1 && sb.length() == 0) {
                return null;
            }
            return new SingleByteByCharLine(start, endTextPosition, sb.toString(), endLine);
        }
    }

    private static class BomInformation {
        private final Charset charset;
        private final int bomLength;

        public BomInformation(Charset charset, int bomLength) {
            this.charset = charset;
            this.bomLength = bomLength;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public int getBomLength() {
            return this.bomLength;
        }
    }

    private static interface LineReader {
        public Line readLine() throws IOException;
    }
}

