/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.sing_group.gc4s.input.filechooser.ExtensionFileFilter;
import org.sing_group.gc4s.utilities.FileDrop;
import org.sing_group.gc4s.utilities.FileDropListener;
import org.sing_group.seda.core.ncbi.NcbiDatasetProcessor;
import org.sing_group.seda.gui.CommonFileChooser;
import org.sing_group.seda.gui.CustomSwingWorker;
import org.sing_group.seda.gui.GuiUtils;
import org.sing_group.seda.gui.PathSelectionModel;
import org.sing_group.seda.gui.PathSelectionModelEvent;
import org.sing_group.seda.gui.WorkingDialog;
import org.sing_group.seda.io.IOUtils;

public class PathSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon ICON_FILES = new ImageIcon(PathSelectionPanel.class.getResource("image/files.png"));
    private static final ImageIcon ICON_FILE_TXT = new ImageIcon(PathSelectionPanel.class.getResource("image/file-txt.png"));
    private static final ImageIcon ICON_FILE_ZIP = new ImageIcon(PathSelectionPanel.class.getResource("image/file-zip.png"));
    private static final ImageIcon ICON_FOLDER = new ImageIcon(PathSelectionPanel.class.getResource("image/folder.png"));
    private static final ImageIcon ICON_ARROW_LEFT = new ImageIcon(PathSelectionPanel.class.getResource("image/arrow-left.png"));
    private static final ImageIcon ICON_ARROWS_LEFT = new ImageIcon(PathSelectionPanel.class.getResource("image/arrows-left.png"));
    private static final ImageIcon ICON_ARROW_RIGHT = new ImageIcon(PathSelectionPanel.class.getResource("image/arrow-right.png"));
    private static final ImageIcon ICON_ARROWS_RIGHT = new ImageIcon(PathSelectionPanel.class.getResource("image/arrows-right.png"));
    private static final List<FileFilter> FILE_FILTERS = Arrays.asList(new ExtensionFileFilter(".*\\.txt", "TXT files", false), new ExtensionFileFilter(".*\\.fasta|.*\\.fa", "FASTA files", false), new ExtensionFileFilter(".*\\.fasta.gz|.*\\\\.fasta.gzip|.*\\\\.fa.gz|.*\\.fa.gzip", "Compressed FASTA files", false), new ExtensionFileFilter(".*\\.gz|.*\\\\.gzip", "Gzip files", false));
    private final JLabel lblAvailable;
    private final JLabel lblSelected;
    private final JFileChooser fileChooser;
    private final PathSelectionModel model = new PathSelectionModel();
    private final JCheckBox chkRecursiveSearch;
    private final JCheckBox chkHideCommonPath;
    private final JList<String> listAvailableFiles = new JList<String>(new CustomListModel(this.model, PathSelectionModel::countAvailablePaths, PathSelectionModel::getAvailablePath, PathSelectionModel::getAvailablePaths, PathSelectionModelEvent.FileSelectionEventType.ADD_AVAILABLE, PathSelectionModelEvent.FileSelectionEventType.REMOVE_AVAILABLE, PathSelectionModelEvent.FileSelectionEventType.CLEAR_AVAILABLE));
    private final JList<String> listSelectedFiles = new JList<String>(new CustomListModel(this.model, PathSelectionModel::countSelectedPaths, PathSelectionModel::getSelectedPath, PathSelectionModel::getSelectedPaths, PathSelectionModelEvent.FileSelectionEventType.ADD_SELECTED, PathSelectionModelEvent.FileSelectionEventType.REMOVE_SELECTED, PathSelectionModelEvent.FileSelectionEventType.CLEAR_SELECTED));

    public PathSelectionPanel() {
        super(new BorderLayout());
        new FileDrop(this.listAvailableFiles, new FileDropListener(){

            public void filesDropped(File[] files) {
                Arrays.asList(files).stream().filter(File::isFile).forEach(f -> PathSelectionPanel.this.model.addAvailablePath(f.getAbsolutePath()));
            }
        });
        this.listAvailableFiles.setCellRenderer(new CustomListRenderer());
        this.listSelectedFiles.setCellRenderer(new CustomListRenderer());
        JButton btnLoadDirectory = new JButton("Load from directory", ICON_FOLDER);
        JButton btnLoadFiles = new JButton("Load files", ICON_FILES);
        JButton btnLoadFileList = new JButton("Load file list", ICON_FILE_TXT);
        JButton btnLoadNcbiDataset = new JButton("Load NCBI file", ICON_FILE_ZIP);
        btnLoadNcbiDataset.setToolTipText("Loads an NCBI ZIP file containing a dataset download");
        this.chkRecursiveSearch = new JCheckBox("Recursive load from directory", false);
        this.chkHideCommonPath = new JCheckBox("Hide common path", true);
        JButton btnAddAll = new JButton(ICON_ARROWS_RIGHT);
        JButton btnAdd = new JButton(ICON_ARROW_RIGHT);
        JButton btnRemove = new JButton(ICON_ARROW_LEFT);
        JButton btnRemoveAll = new JButton(ICON_ARROWS_LEFT);
        JButton btnClearAvailable = new JButton("Clear available list");
        JButton btnSaveAvailableList = new JButton("Save available list");
        JButton btnClearSelected = new JButton("Clear selected list");
        JButton btnSaveSelectedList = new JButton("Save selected list");
        this.fileChooser = CommonFileChooser.getInstance().getFilechooser();
        this.fileChooser.setMultiSelectionEnabled(true);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(btnLoadDirectory);
        toolBar.add(btnLoadFiles);
        toolBar.add(btnLoadFileList);
        toolBar.add(btnLoadNcbiDataset);
        toolBar.addSeparator();
        toolBar.add(this.chkRecursiveSearch);
        toolBar.add(this.chkHideCommonPath);
        JPanel panelAvailableButtons = new JPanel(new GridLayout(1, 2));
        panelAvailableButtons.add(btnClearAvailable);
        panelAvailableButtons.add(btnSaveAvailableList);
        JPanel panelAvailable = new JPanel(new BorderLayout(0, 4));
        this.lblAvailable = new JLabel("Available Files");
        this.lblAvailable.setBorder(BorderFactory.createEmptyBorder(7, 2, 2, 2));
        panelAvailable.add((Component)this.lblAvailable, "North");
        panelAvailable.add((Component)new JScrollPane(this.listAvailableFiles), "Center");
        panelAvailable.add((Component)panelAvailableButtons, "South");
        JPanel panelSelectedButtons = new JPanel(new GridLayout(1, 2));
        panelSelectedButtons.add(btnClearSelected);
        panelSelectedButtons.add(btnSaveSelectedList);
        JPanel panelSelected = new JPanel(new BorderLayout(0, 4));
        this.lblSelected = new JLabel("Selected Files");
        this.lblSelected.setBorder(BorderFactory.createEmptyBorder(7, 2, 2, 2));
        panelSelected.add((Component)this.lblSelected, "North");
        panelSelected.add((Component)new JScrollPane(this.listSelectedFiles), "Center");
        panelSelected.add((Component)panelSelectedButtons, "South");
        JPanel panelCentralButtons = new JPanel();
        BoxLayout layout = new BoxLayout(panelCentralButtons, 1);
        panelCentralButtons.setLayout(layout);
        panelCentralButtons.add(btnAddAll);
        panelCentralButtons.add(Box.createVerticalStrut(5));
        panelCentralButtons.add(btnAdd);
        panelCentralButtons.add(Box.createVerticalStrut(1));
        panelCentralButtons.add(btnRemove);
        panelCentralButtons.add(Box.createVerticalStrut(5));
        panelCentralButtons.add(btnRemoveAll);
        JPanel panelCentral = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        panelCentral.add((Component)panelAvailable, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        panelCentral.add((Component)panelCentralButtons, gbc);
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panelCentral.add((Component)panelSelected, gbc);
        this.add((Component)toolBar, "North");
        this.add((Component)panelCentral, "Center");
        btnLoadDirectory.addActionListener(e -> this.loadDirectory());
        btnLoadFiles.addActionListener(e -> this.loadFile());
        btnLoadFileList.addActionListener(e -> this.loadFileList());
        btnLoadNcbiDataset.addActionListener(e -> this.loadNcbiDataset());
        btnAddAll.addActionListener(e -> this.selectAllFiles());
        btnAdd.addActionListener(e -> this.selectFiles());
        btnRemove.addActionListener(e -> this.unselectFiles());
        btnRemoveAll.addActionListener(e -> this.unselectAllFiles());
        btnClearAvailable.addActionListener(e -> this.model.clearAvailablePaths());
        btnSaveAvailableList.addActionListener(e -> this.saveAvailablePaths());
        btnClearSelected.addActionListener(e -> this.model.clearSelectedPaths());
        btnSaveSelectedList.addActionListener(e -> this.saveSelectedPaths());
        this.chkHideCommonPath.addItemListener(e -> {
            this.listAvailableFiles.updateUI();
            this.listSelectedFiles.updateUI();
        });
        this.updateAvailableAndSelectedLabels();
        this.model.addPathSelectionModelListener(e -> this.updateAvailableAndSelectedLabels());
    }

    private void saveAvailablePaths() {
        this.showFileChooserAndProcess(0, 1, false, path -> {
            try {
                this.model.saveAvailablePaths((Path)path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void saveSelectedPaths() {
        this.showFileChooserAndProcess(0, 1, false, path -> {
            try {
                this.model.saveSelectedPaths((Path)path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public PathSelectionModel getModel() {
        return this.model;
    }

    private boolean isRecursiveSearch() {
        return this.chkRecursiveSearch.isSelected();
    }

    private boolean isHideCommonPath() {
        return this.chkHideCommonPath.isSelected();
    }

    private void selectAllFiles() {
        this.model.selectPaths((String[])this.model.getAvailablePaths().toArray(String[]::new));
    }

    private void selectFiles() {
        List<String> selectedFiles = this.listAvailableFiles.getSelectedValuesList();
        this.model.selectPaths((String[])selectedFiles.stream().toArray(String[]::new));
    }

    private void unselectFiles() {
        List<String> selectedFiles = this.listSelectedFiles.getSelectedValuesList();
        this.model.removeSelectedPaths((String[])selectedFiles.stream().toArray(String[]::new));
    }

    private void unselectAllFiles() {
        this.model.removeSelectedPaths((String[])this.model.getSelectedPaths().toArray(String[]::new));
    }

    private void loadFileList() {
        this.showFileChooserAndProcess(0, 0, false, path -> {
            try {
                Files.lines(path).filter(line -> !line.trim().isEmpty()).forEach(this.model::addAvailablePath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void loadFile() {
        this.showFileChooserAndProcess(0, 0, true, this.model::addAvailablePath, FILE_FILTERS);
    }

    private void loadDirectory() {
        this.showFileChooserAndProcess(1, 0, true, directory -> {
            try {
                if (this.isRecursiveSearch()) {
                    Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Objects.requireNonNull(file);
                            Objects.requireNonNull(attrs);
                            PathSelectionPanel.this.model.addAvailablePath(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                } else {
                    Files.list(directory).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(this.model::addAvailablePath);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        });
    }

    private void loadNcbiDataset() {
        WorkingDialog dialog = new WorkingDialog((Frame)((JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this)), "Processing NCBI ZIP file", "Processing NCBI ZIP file");
        new CustomSwingWorker(() -> this.showFileChooserAndProcess(0, 0, false, (Path zipFile) -> {
            System.out.println("Processing NCBI ZIP file" + zipFile);
            try {
                SwingUtilities.invokeLater(() -> dialog.setVisible(true));
                new NcbiDatasetProcessor(zipFile.toFile()).process(IOUtils.createSedaUserHomeDirectory("SEDA_NCBI_datasets")).forEach(f -> this.model.addAvailablePath(f.toPath()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                dialog.dispose();
            }
        }, () -> dialog.dispose())).execute();
    }

    private void updateAvailableAndSelectedLabels() {
        this.lblAvailable.setText(String.format("Available Files (%d)", this.getModel().countAvailablePaths()));
        this.lblSelected.setText(String.format("Selected Files (%d)", this.getModel().countSelectedPaths()));
    }

    private void showFileChooserAndProcess(int selectionMode, int dialogMode, boolean multipleSelection, Consumer<Path> pathProcesser) {
        this.showFileChooserAndProcess(selectionMode, dialogMode, multipleSelection, pathProcesser, Collections.emptyList(), () -> {});
    }

    private void showFileChooserAndProcess(int selectionMode, int dialogMode, boolean multipleSelection, Consumer<Path> pathProcesser, Runnable onCancel) {
        this.showFileChooserAndProcess(selectionMode, dialogMode, multipleSelection, pathProcesser, Collections.emptyList(), onCancel);
    }

    private void showFileChooserAndProcess(int selectionMode, int dialogMode, boolean multipleSelection, Consumer<Path> pathProcesser, List<FileFilter> fileFilters) {
        GuiUtils.showFileChooserAndProcess(this.fileChooser, this, selectionMode, dialogMode, multipleSelection, fileFilters, pathProcesser, () -> {});
    }

    private void showFileChooserAndProcess(int selectionMode, int dialogMode, boolean multipleSelection, Consumer<Path> pathProcesser, List<FileFilter> fileFilters, Runnable onCancel) {
        GuiUtils.showFileChooserAndProcess(this.fileChooser, this, selectionMode, dialogMode, multipleSelection, fileFilters, pathProcesser, onCancel);
    }

    private static String getDirectory(String path) {
        return path.substring(0, path.lastIndexOf(File.separatorChar) + 1);
    }

    private final class CustomListRenderer
    implements ListCellRenderer<String> {
        private final ListCellRenderer<Object> renderer = new DefaultListCellRenderer();

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = this.renderer.getListCellRendererComponent(list, this.getCellValue(list, value), index, isSelected, cellHasFocus);
            if (component instanceof JComponent) {
                ((JComponent)component).setToolTipText(value);
            }
            return component;
        }

        private String getCellValue(JList<? extends String> list, String value) {
            String commonPath;
            CustomListModel model = (CustomListModel)list.getModel();
            if (PathSelectionPanel.this.isHideCommonPath() && (commonPath = model.getCommonPath()) != null && commonPath.length() > 1) {
                return "+" + value.replaceFirst(Pattern.quote(commonPath), "");
            }
            return value;
        }
    }

    private static final class CustomListModel
    extends AbstractListModel<String> {
        private static final long serialVersionUID = 1L;
        private final IntSupplier sizeFunction = () -> sizeFunction.applyAsInt(model);
        private final IntFunction<String> getFunction = index -> (String)getFunction.apply(model, index);
        private final Supplier<Stream<String>> getPathsFunction = () -> (Stream)getPathsFunction.apply(model);
        private String commonPrefix;

        public CustomListModel(PathSelectionModel model, ToIntFunction<PathSelectionModel> sizeFunction, BiFunction<PathSelectionModel, Integer, String> getFunction, Function<PathSelectionModel, Stream<String>> getPathsFunction, PathSelectionModelEvent.FileSelectionEventType additionEvent, PathSelectionModelEvent.FileSelectionEventType removalEvent, PathSelectionModelEvent.FileSelectionEventType clearEvent) {
            model.addPathSelectionModelListener(event -> {
                Integer index = event.getIndex();
                if (event.getType() == additionEvent) {
                    this.updateCommonPrefix();
                    this.fireIntervalAdded(event, index, index);
                } else if (event.getType() == removalEvent) {
                    this.updateCommonPrefix();
                    this.fireIntervalRemoved(event, index, index);
                } else if (event.getType() == clearEvent) {
                    this.updateCommonPrefix();
                    this.fireContentsChanged(event, 0, index);
                }
            });
        }

        @Override
        public int getSize() {
            return this.sizeFunction.getAsInt();
        }

        @Override
        public String getElementAt(int index) {
            return this.getFunction.apply(index);
        }

        public String getCommonPath() {
            return this.commonPrefix;
        }

        private void updateCommonPrefix() {
            int size = this.getSize();
            if (size == 0) {
                this.commonPrefix = "";
            } else if (size == 1) {
                String path = this.getElementAt(0);
                this.commonPrefix = PathSelectionPanel.getDirectory(path);
            } else {
                this.commonPrefix = this.getPathsFunction.get().reduce("", (p1, p2) -> {
                    if (p1.isEmpty()) {
                        return p2;
                    }
                    if (p2.isEmpty()) {
                        return p1;
                    }
                    String p1ForPrefix = PathSelectionPanel.getDirectory(p1);
                    String p2ForPrefix = PathSelectionPanel.getDirectory(p2);
                    String commonPrefix = "";
                    for (int i = 0; i < Math.min(p1ForPrefix.length(), p2ForPrefix.length()) && p1ForPrefix.charAt(i) == p2ForPrefix.charAt(i); ++i) {
                        commonPrefix = commonPrefix + p1ForPrefix.charAt(i);
                    }
                    return commonPrefix;
                });
            }
        }
    }
}

