/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.sing_group.seda.io.IOUtils;

public class FilePreviewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_TEXT = "Select one file to show a preview.";
    private JTextArea fileTextArea;

    public FilePreviewPanel() {
        this.init();
    }

    private void init() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.setLayout(new BorderLayout());
        this.add(this.getFileTextArea(), "Center");
    }

    private Component getFileTextArea() {
        this.fileTextArea = new JTextArea(DEFAULT_TEXT);
        this.fileTextArea.setEditable(false);
        this.fileTextArea.setRows(10);
        this.fileTextArea.setLineWrap(true);
        return new JScrollPane(this.fileTextArea);
    }

    public void previewPath(String previewPath) {
        this.setText("Loading file " + previewPath + " ...");
        SwingUtilities.invokeLater(() -> this.setText(this.readFirstSequence(new File(previewPath))));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFirstSequence(File file) {
        try (InputStream is = IOUtils.createInputStream(file.toPath());){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder sb = new StringBuilder();
            boolean firstLine = true;
            while ((line = reader.readLine()) != null && (!line.startsWith(">") || firstLine)) {
                sb.append(line).append("\n");
                firstLine = false;
            }
            reader.close();
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Error reading file.";
        }
    }

    private void setText(String text) {
        this.fileTextArea.setText(text);
        this.scrolltop();
    }

    private void scrolltop() {
        this.fileTextArea.setSelectionStart(0);
        this.fileTextArea.setSelectionEnd(0);
    }

    public void clearPreviewPath() {
        this.setText(DEFAULT_TEXT);
    }
}

