/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.datatype.pattern;

import java.util.LinkedList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.sing_group.seda.datatype.pattern.EvaluableSequencePattern;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;

@XmlRootElement
public class SequencePattern
implements EvaluableSequencePattern {
    @XmlElement
    private String regex;
    @XmlElement
    private boolean containsRegex;
    @XmlElement
    private int requiredNumberOfMatches;
    @XmlElement
    private boolean caseSensitive;
    @XmlTransient
    private Pattern pattern;

    public SequencePattern() {
    }

    public SequencePattern(String regex, int requiredNumberOfMatches, boolean caseSensitive) {
        this(regex, requiredNumberOfMatches, caseSensitive, true);
    }

    public SequencePattern(String regex, int requiredNumberOfMatches, boolean caseSensitive, boolean containsRegex) {
        this.regex = regex;
        this.containsRegex = containsRegex;
        this.requiredNumberOfMatches = requiredNumberOfMatches;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public boolean eval(String sequence) {
        boolean patternEvaluation;
        int count = 0;
        Matcher matcher = this.getPattern().matcher(sequence);
        while (matcher.find()) {
            ++count;
        }
        boolean bl = patternEvaluation = count >= this.requiredNumberOfMatches;
        return this.containsRegex ? patternEvaluation : !patternEvaluation;
    }

    private Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = this.caseSensitive ? Pattern.compile(this.regex) : Pattern.compile(this.regex, 2);
        }
        return this.pattern;
    }

    public String getRegex() {
        return this.regex;
    }

    public boolean isContainsRegex() {
        return this.containsRegex;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public int getRequiredNumberOfMatches() {
        return this.requiredNumberOfMatches;
    }

    public String toString() {
        return (this.containsRegex ? "" : "NOT(") + this.getPattern() + (this.containsRegex ? "" : ")") + " [CS = " + (this.caseSensitive ? "yes" : "no") + ", RNoM: " + this.requiredNumberOfMatches + "]";
    }

    @Override
    public Validation validate() {
        LinkedList<String> errors = new LinkedList<String>();
        if (this.regex == null) {
            errors.add("The regex string can't be null.");
        } else {
            try {
                this.getPattern();
            }
            catch (PatternSyntaxException e) {
                errors.add("Regular expression " + this.regex + " isn't valid.");
            }
        }
        return new DefaultValidation(errors);
    }

    public int hashCode() {
        return Objects.hash(this.caseSensitive, this.containsRegex, this.regex, this.requiredNumberOfMatches);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequencePattern other = (SequencePattern)obj;
        return this.caseSensitive == other.caseSensitive && this.containsRegex == other.containsRegex && Objects.equals(this.regex, other.regex) && this.requiredNumberOfMatches == other.requiredNumberOfMatches;
    }
}

