/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.trim;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sing_group.seda.datatype.Sequence;

public class SequenceAlignmentGapsBoundaries {
    private Sequence sequence;
    private int leadingBases = -1;
    private int trailingBases = -1;

    public SequenceAlignmentGapsBoundaries(Sequence sequence) {
        this.sequence = sequence;
    }

    public int leadingBases() {
        if (this.leadingBases == -1) {
            Pattern pattern = Pattern.compile("(^-*)");
            Matcher matcher = pattern.matcher(this.sequence.getChain());
            this.leadingBases = matcher.find() ? matcher.group(1).length() : 0;
        }
        return this.leadingBases;
    }

    public int trailingBases() {
        if (this.trailingBases == -1) {
            Pattern pattern = Pattern.compile("(-*)$");
            Matcher matcher = pattern.matcher(this.sequence.getChain());
            this.trailingBases = matcher.find() ? matcher.group(1).length() : 0;
        }
        return this.trailingBases;
    }
}

