/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.parameters;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.IntegerDefaultValuedStringConstructedOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.util.ArrayList;
import java.util.List;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.core.rename.AddStringHeaderRenamer;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.plugin.core.info.plugin.RenameHeaderAddWordSedaPluginInfo;
import org.sing_group.seda.plugin.core.info.plugin.RenameHeaderSedaPluginInfo;

public class AddStringHeaderRenamerCliParameters {
    public static final DefaultValuedStringOption OPTION_TARGET = new DefaultValuedStringOption("header-target", "ht", RenameHeaderSedaPluginInfo.PARAM_TARGET_HELP, HeaderTarget.ALL.name().toLowerCase());
    public static final DefaultValuedStringOption OPTION_POSITION = new DefaultValuedStringOption("position", "p", RenameHeaderAddWordSedaPluginInfo.PARAM_POSITION_HELP, AddStringHeaderRenamer.Position.PREFIX.name().toLowerCase());
    public static final StringOption OPTION_STRING = new StringOption("string", "s", "The string to add.", true, true);
    public static final DefaultValuedStringOption OPTION_DELIMITER = new DefaultValuedStringOption("delimiter", "dl", "The string delimiter.", "_");
    public static final FlagOption OPTION_ADD_INDEX = new FlagOption("add-index", "ai", "Whether an index must be added or not.");
    public static final DefaultValuedStringOption OPTION_INDEX_DELIMITER = new DefaultValuedStringOption("index-delimiter", "idl", "The index delimiter.", "_");
    public static final IntegerDefaultValuedStringConstructedOption OPTION_START_INDEX = new IntegerDefaultValuedStringConstructedOption("start-index", "si", "The start index.", Integer.valueOf(1));
    private final boolean showAddIndexOptions;
    private final Option<?> headerTargetOption;

    public AddStringHeaderRenamerCliParameters(boolean showAddIndexOptions) {
        this(showAddIndexOptions, (Option<?>)OPTION_TARGET);
    }

    public AddStringHeaderRenamerCliParameters(boolean showAddIndexOptions, Option<?> headerTargetOption) {
        this.showAddIndexOptions = showAddIndexOptions;
        this.headerTargetOption = headerTargetOption;
    }

    public List<Option<?>> getOptionList() {
        ArrayList options = new ArrayList();
        options.add(this.headerTargetOption);
        options.add((Option<?>)OPTION_POSITION);
        options.add((Option<?>)OPTION_STRING);
        options.add((Option<?>)OPTION_DELIMITER);
        if (this.showAddIndexOptions) {
            options.add((Option<?>)OPTION_ADD_INDEX);
            options.add((Option<?>)OPTION_INDEX_DELIMITER);
            options.add((Option<?>)OPTION_START_INDEX);
        }
        return options;
    }

    public AddStringHeaderRenamer getAddStringHeaderRenamer(Parameters parameters) {
        SedaCommand.checkMandatoryOption(parameters, OPTION_STRING);
        AddStringHeaderRenamer.Position position = null;
        try {
            position = AddStringHeaderRenamer.Position.valueOf(parameters.getSingleValueString((Option)OPTION_POSITION).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            SedaCommand.invalidEnumValue(OPTION_POSITION);
        }
        String stringToAdd = (String)parameters.getSingleValue((Option)OPTION_STRING);
        String delimiter = (String)parameters.getSingleValue((Option)OPTION_DELIMITER);
        String indexDelimiter = "";
        int startIndex = 0;
        boolean hasIndex = this.showAddIndexOptions;
        if (this.showAddIndexOptions) {
            hasIndex = parameters.hasFlag((Option)OPTION_ADD_INDEX);
            startIndex = (Integer)parameters.getSingleValue((Option)OPTION_START_INDEX);
            if (hasIndex) {
                indexDelimiter = (String)parameters.getSingleValue((Option)OPTION_INDEX_DELIMITER);
            }
        }
        return new AddStringHeaderRenamer(this.getHeaderTarget(parameters), stringToAdd, delimiter, position, hasIndex, indexDelimiter, startIndex);
    }

    private HeaderTarget getHeaderTarget(Parameters parameters) {
        HeaderTarget target = null;
        try {
            target = HeaderTarget.valueOf(parameters.getSingleValueString(this.headerTargetOption).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            SedaCommand.invalidEnumValue(this.headerTargetOption);
        }
        return target;
    }
}

