/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.IntegerDefaultValuedStringConstructedOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.datatype.SequenceCase;
import org.sing_group.seda.io.LineBreakType;
import org.sing_group.seda.plugin.core.info.plugin.ReformatFastaSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.reformat.ReformatFastaTransformationProvider;

public class ReformatFastaCommand
extends SedaCommand {
    public static final FlagOption OPTION_REMOVE_LINE_BREAKS = new FlagOption("remove-line-breaks", "rlb", "Whether line breaks in sequences must be removed or not. This option overrides the 'Fragment length' option.");
    public static final IntegerDefaultValuedStringConstructedOption OPTION_FRAGMENT_LENGHT = new IntegerDefaultValuedStringConstructedOption("fragment-length", "fl", "The length of the sequence fragments. This option is ignored if the 'Remove line breaks' option is used.", Integer.valueOf(80));
    public static final DefaultValuedStringOption OPTION_LINE_BREAKS = new DefaultValuedStringOption("line-breaks", "lb", ReformatFastaSedaPluginInfo.PARAM_LINE_BREAKS_HELP, LineBreakType.defaultType().name());
    public static final DefaultValuedStringOption OPTION_SEQUENCE_CASE = new DefaultValuedStringOption("sequence-case", "sc", ReformatFastaSedaPluginInfo.PARAM_SEQUENCE_CASE_HELP, SequenceCase.defaultType().name());

    public String getName() {
        return "reformat";
    }

    public String getDescriptiveName() {
        return "Reformat file";
    }

    public String getDescription() {
        return "Change the format of a FASTA file (sequence fragment length, line break type, and sequence case).";
    }

    @Override
    protected String getSedaGroup() {
        return ReformatFastaSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        return Arrays.asList(OPTION_REMOVE_LINE_BREAKS, OPTION_FRAGMENT_LENGHT, OPTION_LINE_BREAKS, OPTION_SEQUENCE_CASE);
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        ReformatFastaTransformationProvider provider = new ReformatFastaTransformationProvider();
        LineBreakType lineBreakType = null;
        SequenceCase sequenceCase = null;
        try {
            lineBreakType = LineBreakType.valueOf(parameters.getSingleValueString((Option)OPTION_LINE_BREAKS).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            ReformatFastaCommand.invalidEnumValue(OPTION_LINE_BREAKS);
        }
        try {
            sequenceCase = SequenceCase.valueOf(parameters.getSingleValueString((Option)OPTION_SEQUENCE_CASE).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            ReformatFastaCommand.invalidEnumValue(OPTION_SEQUENCE_CASE);
        }
        provider.setRemoveLineBreaks(parameters.hasFlag((Option)OPTION_REMOVE_LINE_BREAKS));
        provider.setFragmentLength((Integer)parameters.getSingleValue((Option)OPTION_FRAGMENT_LENGHT));
        provider.setLineBreakType(lineBreakType);
        provider.setSequenceCase(sequenceCase);
        return provider;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, ReformatFastaTransformationProvider.class);
    }
}

