/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.bio.consensus;

import org.sing_group.seda.bio.SequenceType;
import org.sing_group.seda.bio.consensus.ConsensusBaseStrategy;
import org.sing_group.seda.bio.consensus.NucleotideSequencesGroupAboveThresholdConsensus;
import org.sing_group.seda.bio.consensus.NucleotideSequencesGroupMostFrequentConsensus;
import org.sing_group.seda.bio.consensus.ProteinSequencesGroupAboveThresholdConsensus;
import org.sing_group.seda.bio.consensus.ProteinSequencesGroupMostFrequentConsensus;
import org.sing_group.seda.bio.consensus.SequencesGroupConsensus;
import org.sing_group.seda.datatype.SequenceBuilder;

public class SequencesGroupConsensusFactory {
    public static SequencesGroupConsensus getConsensusCreator(SequenceType sequenceType, ConsensusBaseStrategy consensusBaseStrategy, SequenceBuilder sequenceBuilder, double minimumPresence, boolean verbose) {
        if (consensusBaseStrategy.equals((Object)ConsensusBaseStrategy.MOST_FREQUENT)) {
            if (sequenceType.equals((Object)SequenceType.NUCLEOTIDE)) {
                return new NucleotideSequencesGroupMostFrequentConsensus(sequenceBuilder, minimumPresence, verbose);
            }
            return new ProteinSequencesGroupMostFrequentConsensus(sequenceBuilder, minimumPresence, verbose);
        }
        if (sequenceType.equals((Object)SequenceType.NUCLEOTIDE)) {
            return new NucleotideSequencesGroupAboveThresholdConsensus(sequenceBuilder, minimumPresence, verbose);
        }
        return new ProteinSequencesGroupAboveThresholdConsensus(sequenceBuilder, minimumPresence, verbose);
    }
}

