/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.clustalomega.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedList;
import java.util.Optional;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.event.RunnableDocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.text.JIntegerTextField;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.clustalomega.execution.ClustalOmegaBinariesExecutor;
import org.sing_group.seda.clustalomega.gui.ClustalOmegaExecutionConfigurationPanel;
import org.sing_group.seda.clustalomega.transformation.provider.ClustalOmegaAlignmentTransformationProvider;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;

public class ClustalOmegaAlignmentTransformationConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JIntegerTextField numThreads;
    private JXTextField additionalParameters;
    private ClustalOmegaAlignmentTransformationProvider transformationProvider;
    private ClustalOmegaExecutionConfigurationPanel clustalOmegaExecutionConfigurationPanel;

    public ClustalOmegaAlignmentTransformationConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void initTransformationProvider() {
        this.transformationProvider = new ClustalOmegaAlignmentTransformationProvider();
        this.numThreadsChanged();
        this.additionalParametersChanged();
        this.clustalOmegaExecutorChanged();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add((Component)this.getQueryConfigurationPanel());
        return new CenteredJPanel((Component)mainPanel);
    }

    private InputParametersPanel getQueryConfigurationPanel() {
        return new InputParametersPanel(this.getParameters());
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getClustalOmegaExecutableParameter());
        parameters.add(this.getNumThreadsParameter());
        parameters.add(this.getAdditionalParametersParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getClustalOmegaExecutableParameter() {
        this.clustalOmegaExecutionConfigurationPanel = new ClustalOmegaExecutionConfigurationPanel(this::clustalOmegaExecutorChanged);
        return new InputParameter("", (JComponent)this.clustalOmegaExecutionConfigurationPanel, "The mode to execute Clustal Omega.");
    }

    private void clustalOmegaExecutorChanged(BinaryExecutionConfigurationPanel<ClustalOmegaBinariesExecutor> source) {
        this.clustalOmegaExecutorChanged();
    }

    private void clustalOmegaExecutorChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setBinariesExecutor(this.getClustalOmegaBinariesExecutor()));
    }

    private Optional<ClustalOmegaBinariesExecutor> getClustalOmegaBinariesExecutor() {
        return this.clustalOmegaExecutionConfigurationPanel.getBinariesExecutor();
    }

    private InputParameter getNumThreadsParameter() {
        this.numThreads = new JIntegerTextField(Integer.valueOf(1));
        this.numThreads.setColumns(4);
        this.numThreads.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::numThreadsChanged));
        return new InputParameter("Num. threads:", (JComponent)this.numThreads, "Number of threads to use.");
    }

    private void numThreadsChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setNumThreads(this.getNumThreads()));
    }

    private InputParameter getAdditionalParametersParameter() {
        this.additionalParameters = new JXTextField("Additional Clustal Omega parameters");
        this.additionalParameters.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::additionalParametersChanged));
        return new InputParameter("Additional parameters:", (JComponent)this.additionalParameters, "Additional parameters for the Clustal Omega command.");
    }

    private void additionalParametersChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setAdditionalParameters(this.getAdditionalParameters()));
    }

    public ClustalOmegaAlignmentTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    private int getNumThreads() {
        return this.numThreads.getValue();
    }

    private String getAdditionalParameters() {
        return this.additionalParameters.getText();
    }

    public void setTransformationProvider(ClustalOmegaAlignmentTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        this.numThreads.setValue((Object)this.transformationProvider.getNumThreads());
        if (this.transformationProvider.getAdditionalParameters() != null) {
            this.additionalParameters.setText(this.transformationProvider.getAdditionalParameters());
        }
        if (this.transformationProvider.getBinariesExecutor() != null) {
            this.clustalOmegaExecutionConfigurationPanel.setBinariesExecutor(this.transformationProvider.getBinariesExecutor());
        }
    }
}

