/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.clustalomega.execution;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.sing_group.seda.clustalomega.execution.AbstractClustalOmegaBinariesExecutor;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.core.execution.DockerExecutionUtils;
import org.sing_group.seda.core.execution.DockerImageChecker;

@XmlRootElement
public class DockerClustalOmegaBinariesExecutor
extends AbstractClustalOmegaBinariesExecutor {
    @XmlTransient
    private final DockerImageChecker dockerImageChecker = DockerImageChecker.getInstance();
    @XmlElement
    private final String dockerImage;

    public DockerClustalOmegaBinariesExecutor() {
        this(DockerClustalOmegaBinariesExecutor.getDefaultDockerImage());
    }

    public DockerClustalOmegaBinariesExecutor(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    @Override
    public void executeAlignment(File inputFile, File outputFile, int numThreads, String additionalParameters) throws IOException, InterruptedException {
        this.executeAlignment(this.getClustalOmegaCommandList(inputFile, outputFile), inputFile, outputFile, numThreads, additionalParameters);
    }

    private List<String> getClustalOmegaCommandList(File inputFile, File outputFile) {
        return Arrays.asList(this.getClustalOmegaCommand(inputFile, outputFile).split(" "));
    }

    private String getClustalOmegaCommand(File inputFile, File outputFile) {
        HashSet<String> directoriesToMount = new HashSet<String>();
        directoriesToMount.add(inputFile.getParent());
        directoriesToMount.add(outputFile.getParent());
        return DockerClustalOmegaBinariesExecutor.composeClustalOmegaCommand(this.dockerImage, DockerExecutionUtils.getMountDockerDirectoriesString(directoriesToMount));
    }

    @Override
    protected String getClustalOmegaCommand() {
        return DockerClustalOmegaBinariesExecutor.composeClustalOmegaCommand(this.dockerImage, "");
    }

    @Override
    protected String toFilePath(File file) {
        return DockerExecutionUtils.dockerPath(file.getAbsolutePath());
    }

    protected static String composeClustalOmegaCommand(String clustalOmegaImage, String dockerDirectories) {
        return "docker run --rm " + dockerDirectories + " " + clustalOmegaImage;
    }

    public static String getDefaultDockerImage() {
        return "singgroup/seda-clustalomega";
    }

    @Override
    public void checkBinary() throws BinaryCheckException {
        if (this.dockerImageChecker.shouldCheckDockerImage(this.dockerImage)) {
            DockerExecutionUtils.checkDockerAvailability();
            super.checkBinary();
            this.dockerImageChecker.storeImageTimestamp(this.dockerImage);
        }
    }

    public String getDockerImage() {
        return this.dockerImage;
    }
}

