/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.clustalomega.execution;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.clustalomega.execution.AbstractClustalOmegaBinariesExecutor;
import org.sing_group.seda.util.OsUtils;

@XmlRootElement
public class DefaultClustalOmegaBinariesExecutor
extends AbstractClustalOmegaBinariesExecutor {
    @XmlElement
    private final File clustalOmegaExecutable;

    public DefaultClustalOmegaBinariesExecutor() {
        this(new File(DefaultClustalOmegaBinariesExecutor.getClustalOmegaBinaryFileName()));
    }

    public DefaultClustalOmegaBinariesExecutor(File clustalOmegaExecutable) {
        this.clustalOmegaExecutable = clustalOmegaExecutable;
    }

    @Override
    public void executeAlignment(File inputFile, File outputFile, int numThreads, String additionalParameters) throws IOException, InterruptedException {
        this.executeAlignment(Arrays.asList(this.clustalOmegaExecutable.getPath()), inputFile, outputFile, numThreads, additionalParameters);
    }

    @Override
    protected String getClustalOmegaCommand() {
        return this.clustalOmegaExecutable.getPath();
    }

    @Override
    protected String toFilePath(File file) {
        return file.getAbsolutePath();
    }

    public static String getClustalOmegaBinaryFileName() {
        if (OsUtils.isWindows()) {
            return "clustalo.exe";
        }
        return "clustalo";
    }

    public File getClustalOmegaExecutable() {
        return this.clustalOmegaExecutable;
    }
}

