/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import com.github.tomakehurst.wiremock.common.AsynchronousResponseSettings;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.http.trafficlistener.WiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.jetty9.DefaultMultipartRequestConfigurer;
import com.github.tomakehurst.wiremock.jetty9.JettyFaultInjectorFactory;
import com.github.tomakehurst.wiremock.jetty9.NotFoundHandler;
import com.github.tomakehurst.wiremock.servlet.ContentTypeSettingFilter;
import com.github.tomakehurst.wiremock.servlet.MultipartRequestConfigurer;
import com.github.tomakehurst.wiremock.servlet.TrailingSlashFilter;
import com.github.tomakehurst.wiremock.servlet.WireMockHandlerDispatchingServlet;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.lang.reflect.Method;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NetworkTrafficServerConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyHttpServer
implements HttpServer {
    private static final String FILES_URL_MATCH = String.format("/%s/*", "__files");
    private static final String[] GZIPPABLE_METHODS = new String[]{"POST", "PUT", "PATCH", "DELETE"};
    private static final int DEFAULT_ACCEPTORS = 3;
    private static final int DEFAULT_HEADER_SIZE = 8192;
    private static final MutableBoolean STRICT_HTTP_HEADERS_APPLIED = new MutableBoolean(false);
    private final Server jettyServer;
    private final ServerConnector httpConnector;
    private final ServerConnector httpsConnector;
    private ScheduledExecutorService scheduledExecutorService;

    public JettyHttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        if (!options.getDisableStrictHttpHeaders() && STRICT_HTTP_HEADERS_APPLIED.isFalse()) {
            System.setProperty("org.eclipse.jetty.http.HttpGenerator.STRICT", String.valueOf(true));
            STRICT_HTTP_HEADERS_APPLIED.setTrue();
        }
        this.jettyServer = this.createServer(options);
        NetworkTrafficListenerAdapter networkTrafficListenerAdapter = new NetworkTrafficListenerAdapter(options.networkTrafficListener());
        if (options.getHttpDisabled()) {
            this.httpConnector = null;
        } else {
            this.httpConnector = this.createHttpConnector(options.bindAddress(), options.portNumber(), options.jettySettings(), networkTrafficListenerAdapter);
            this.jettyServer.addConnector((Connector)this.httpConnector);
        }
        if (options.httpsSettings().enabled()) {
            this.httpsConnector = this.createHttpsConnector(this.jettyServer, options.bindAddress(), options.httpsSettings(), options.jettySettings(), networkTrafficListenerAdapter);
            this.jettyServer.addConnector((Connector)this.httpsConnector);
        } else {
            this.httpsConnector = null;
        }
        this.applyAdditionalServerConfiguration(this.jettyServer, options);
        HandlerCollection handlers = this.createHandler(options, adminRequestHandler, stubRequestHandler);
        this.jettyServer.setHandler((Handler)handlers);
        this.finalizeSetup(options);
    }

    protected void applyAdditionalServerConfiguration(Server jettyServer, Options options) {
    }

    protected HandlerCollection createHandler(final Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        Notifier notifier = options.notifier();
        ServletContextHandler adminContext = this.addAdminContext(adminRequestHandler, notifier);
        ServletContextHandler mockServiceContext = this.addMockServiceContext(stubRequestHandler, options.filesRoot(), options.getAsynchronousResponseSettings(), options.getChunkedEncodingPolicy(), options.getStubCorsEnabled(), options.browserProxySettings().enabled(), notifier);
        HandlerCollection handlers = new HandlerCollection();
        AbstractHandler asyncTimeoutSettingHandler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                baseRequest.getHttpChannel().getState().setTimeout(options.timeout());
            }
        };
        handlers.setHandlers((Handler[])ArrayUtils.addAll((Object[])this.extensionHandlers(), (Object[])new Handler[]{adminContext, asyncTimeoutSettingHandler}));
        if (options.getGzipDisabled()) {
            handlers.addHandler((Handler)mockServiceContext);
        } else {
            this.addGZipHandler(mockServiceContext, handlers);
        }
        return handlers;
    }

    private void addGZipHandler(ServletContextHandler mockServiceContext, HandlerCollection handlers) {
        Class<?> gzipHandlerClass = null;
        try {
            gzipHandlerClass = Class.forName("org.eclipse.jetty.servlets.gzip.GzipHandler");
        }
        catch (ClassNotFoundException e) {
            try {
                gzipHandlerClass = Class.forName("org.eclipse.jetty.server.handler.gzip.GzipHandler");
            }
            catch (ClassNotFoundException e1) {
                Exceptions.throwUnchecked(e1);
            }
        }
        try {
            HandlerWrapper gzipWrapper = (HandlerWrapper)gzipHandlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            JettyHttpServer.setGZippableMethods(gzipWrapper, gzipHandlerClass);
            gzipWrapper.setHandler((Handler)mockServiceContext);
            handlers.addHandler((Handler)gzipWrapper);
        }
        catch (Exception e) {
            Exceptions.throwUnchecked(e);
        }
    }

    private static void setGZippableMethods(HandlerWrapper gzipHandler, Class<?> gzipHandlerClass) {
        try {
            Method addIncludedMethods = gzipHandlerClass.getDeclaredMethod("addIncludedMethods", String[].class);
            addIncludedMethods.invoke((Object)gzipHandler, new Object[]{GZIPPABLE_METHODS});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalizeSetup(Options options) {
        if (!options.jettySettings().getStopTimeout().isPresent()) {
            this.jettyServer.setStopTimeout(1000L);
        }
    }

    protected Server createServer(Options options) {
        Server server = new Server(options.threadPoolFactory().buildThreadPool(options));
        JettySettings jettySettings = options.jettySettings();
        Optional<Long> stopTimeout = jettySettings.getStopTimeout();
        if (stopTimeout.isPresent()) {
            server.setStopTimeout(((Long)stopTimeout.get()).longValue());
        }
        return server;
    }

    protected Handler[] extensionHandlers() {
        return new Handler[0];
    }

    @Override
    public void start() {
        try {
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long timeout = System.currentTimeMillis() + 30000L;
        while (!this.jettyServer.isStarted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= timeout) continue;
            throw new RuntimeException("Server took too long to start up.");
        }
    }

    @Override
    public void stop() {
        try {
            if (this.scheduledExecutorService != null) {
                this.scheduledExecutorService.shutdown();
            }
            this.jettyServer.stop();
            this.jettyServer.join();
        }
        catch (Exception e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.jettyServer.isRunning();
    }

    @Override
    public int port() {
        return this.httpConnector.getLocalPort();
    }

    @Override
    public int httpsPort() {
        return this.httpsConnector.getLocalPort();
    }

    public long stopTimeout() {
        return this.jettyServer.getStopTimeout();
    }

    protected ServerConnector createHttpConnector(String bindAddress, int port, JettySettings jettySettings, NetworkTrafficListener listener) {
        HttpConfiguration httpConfig = this.createHttpConfig(jettySettings);
        ServerConnector connector = this.createServerConnector(bindAddress, jettySettings, port, listener, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        return connector;
    }

    protected ServerConnector createHttpsConnector(Server server, String bindAddress, HttpsSettings httpsSettings, JettySettings jettySettings, NetworkTrafficListener listener) {
        SslContextFactory sslContextFactory = this.buildSslContextFactory();
        sslContextFactory.setKeyStorePath(httpsSettings.keyStorePath());
        sslContextFactory.setKeyStorePassword(httpsSettings.keyStorePassword());
        sslContextFactory.setKeyManagerPassword(httpsSettings.keyManagerPassword());
        sslContextFactory.setKeyStoreType(httpsSettings.keyStoreType());
        if (httpsSettings.hasTrustStore()) {
            sslContextFactory.setTrustStorePath(httpsSettings.trustStorePath());
            sslContextFactory.setTrustStorePassword(httpsSettings.trustStorePassword());
        }
        sslContextFactory.setNeedClientAuth(httpsSettings.needClientAuth());
        HttpConfiguration httpConfig = this.createHttpConfig(jettySettings);
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        int port = httpsSettings.port();
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig);
        SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, "http/1.1");
        ConnectionFactory[] connectionFactories = (ConnectionFactory[])ArrayUtils.addAll((Object[])new ConnectionFactory[]{sslConnectionFactory, httpConnectionFactory}, (Object[])this.buildAdditionalConnectionFactories(httpsSettings, httpConnectionFactory, sslConnectionFactory));
        return this.createServerConnector(bindAddress, jettySettings, port, listener, connectionFactories);
    }

    protected ConnectionFactory[] buildAdditionalConnectionFactories(HttpsSettings httpsSettings, HttpConnectionFactory httpConnectionFactory, SslConnectionFactory sslConnectionFactory) {
        return new ConnectionFactory[0];
    }

    protected SslContextFactory buildSslContextFactory() {
        return new SslContextFactory();
    }

    protected HttpConfiguration createHttpConfig(JettySettings jettySettings) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setRequestHeaderSize(((Integer)jettySettings.getRequestHeaderSize().or((Object)8192)).intValue());
        httpConfig.setResponseHeaderSize(((Integer)jettySettings.getResponseHeaderSize().or((Object)8192)).intValue());
        httpConfig.setSendDateHeader(false);
        return httpConfig;
    }

    protected ServerConnector createServerConnector(String bindAddress, JettySettings jettySettings, int port, NetworkTrafficListener listener, ConnectionFactory ... connectionFactories) {
        int acceptors = (Integer)jettySettings.getAcceptors().or((Object)3);
        NetworkTrafficServerConnector connector = new NetworkTrafficServerConnector(this.jettyServer, null, null, null, acceptors, 2, connectionFactories);
        connector.setPort(port);
        connector.addNetworkTrafficListener(listener);
        this.setJettySettings(jettySettings, (ServerConnector)connector);
        connector.setHost(bindAddress);
        return connector;
    }

    private void setJettySettings(JettySettings jettySettings, ServerConnector connector) {
        if (jettySettings.getAcceptQueueSize().isPresent()) {
            connector.setAcceptQueueSize(((Integer)jettySettings.getAcceptQueueSize().get()).intValue());
        }
        if (jettySettings.getIdleTimeout().isPresent()) {
            connector.setIdleTimeout(((Long)jettySettings.getIdleTimeout().get()).longValue());
        }
    }

    private ServletContextHandler addMockServiceContext(StubRequestHandler stubRequestHandler, FileSource fileSource, AsynchronousResponseSettings asynchronousResponseSettings, Options.ChunkedEncodingPolicy chunkedEncodingPolicy, boolean stubCorsEnabled, boolean browserProxyingEnabled, Notifier notifier) {
        ServletContextHandler mockServiceContext = new ServletContextHandler((HandlerContainer)this.jettyServer, "/");
        mockServiceContext.setInitParameter("org.eclipse.jetty.servlet.Default.maxCacheSize", "0");
        mockServiceContext.setInitParameter("org.eclipse.jetty.servlet.Default.resourceBase", fileSource.getPath());
        mockServiceContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        mockServiceContext.addServlet(DefaultServlet.class, FILES_URL_MATCH);
        mockServiceContext.setAttribute(JettyFaultInjectorFactory.class.getName(), (Object)new JettyFaultInjectorFactory());
        mockServiceContext.setAttribute(StubRequestHandler.class.getName(), (Object)stubRequestHandler);
        mockServiceContext.setAttribute("Notifier", (Object)notifier);
        mockServiceContext.setAttribute(Options.ChunkedEncodingPolicy.class.getName(), (Object)chunkedEncodingPolicy);
        mockServiceContext.setAttribute("browserProxyingEnabled", (Object)browserProxyingEnabled);
        ServletHolder servletHolder = mockServiceContext.addServlet(WireMockHandlerDispatchingServlet.class, "/");
        servletHolder.setInitOrder(1);
        servletHolder.setInitParameter("RequestHandlerClass", StubRequestHandler.class.getName());
        servletHolder.setInitParameter("FaultHandlerFactoryClass", JettyFaultInjectorFactory.class.getName());
        servletHolder.setInitParameter("shouldForwardToFilesContext", "true");
        if (asynchronousResponseSettings.isEnabled()) {
            this.scheduledExecutorService = Executors.newScheduledThreadPool(asynchronousResponseSettings.getThreads());
            mockServiceContext.setAttribute(WireMockHandlerDispatchingServlet.ASYNCHRONOUS_RESPONSE_EXECUTOR, (Object)this.scheduledExecutorService);
        }
        mockServiceContext.setAttribute(MultipartRequestConfigurer.KEY, (Object)this.buildMultipartRequestConfigurer());
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("json", "application/json");
        mimeTypes.addMimeMapping("html", "text/html");
        mimeTypes.addMimeMapping("xml", "application/xml");
        mimeTypes.addMimeMapping("txt", "text/plain");
        mockServiceContext.setMimeTypes(mimeTypes);
        mockServiceContext.setWelcomeFiles(new String[]{"index.json", "index.html", "index.xml", "index.txt"});
        NotFoundHandler errorHandler = new NotFoundHandler((ContextHandler)mockServiceContext);
        mockServiceContext.setErrorHandler((ErrorHandler)errorHandler);
        mockServiceContext.addFilter(ContentTypeSettingFilter.class, FILES_URL_MATCH, EnumSet.of(DispatcherType.FORWARD));
        mockServiceContext.addFilter(TrailingSlashFilter.class, FILES_URL_MATCH, EnumSet.allOf(DispatcherType.class));
        if (stubCorsEnabled) {
            this.addCorsFilter(mockServiceContext);
        }
        return mockServiceContext;
    }

    private ServletContextHandler addAdminContext(AdminRequestHandler adminRequestHandler, Notifier notifier) {
        ServletContextHandler adminContext = new ServletContextHandler((HandlerContainer)this.jettyServer, "/__admin");
        adminContext.setInitParameter("org.eclipse.jetty.servlet.Default.maxCacheSize", "0");
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor != null && javaVendor.toLowerCase().contains("android")) {
            adminContext.setInitParameter("org.eclipse.jetty.servlet.Default.resourceBase", "assets");
        } else {
            adminContext.setInitParameter("org.eclipse.jetty.servlet.Default.resourceBase", Resources.getResource((String)"assets").toString());
        }
        Resources.getResource((String)"assets/swagger-ui/index.html");
        adminContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        ServletHolder swaggerUiServletHolder = adminContext.addServlet(DefaultServlet.class, "/swagger-ui/*");
        swaggerUiServletHolder.setAsyncSupported(false);
        adminContext.addServlet(DefaultServlet.class, "/recorder/*");
        ServletHolder servletHolder = adminContext.addServlet(WireMockHandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", AdminRequestHandler.class.getName());
        adminContext.setAttribute(AdminRequestHandler.class.getName(), (Object)adminRequestHandler);
        adminContext.setAttribute("Notifier", (Object)notifier);
        adminContext.setAttribute(MultipartRequestConfigurer.KEY, (Object)this.buildMultipartRequestConfigurer());
        this.addCorsFilter(adminContext);
        return adminContext;
    }

    private void addCorsFilter(ServletContextHandler context) {
        context.addFilter(this.buildCorsFilter(), "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private FilterHolder buildCorsFilter() {
        FilterHolder filterHolder = new FilterHolder(CrossOriginFilter.class);
        filterHolder.setInitParameters((Map)ImmutableMap.of((Object)"chainPreflight", (Object)"false", (Object)"allowedOrigins", (Object)"*", (Object)"allowedHeaders", (Object)"*", (Object)"allowedMethods", (Object)"OPTIONS,GET,POST,PUT,PATCH,DELETE"));
        return filterHolder;
    }

    protected MultipartRequestConfigurer buildMultipartRequestConfigurer() {
        return new DefaultMultipartRequestConfigurer();
    }

    private static class NetworkTrafficListenerAdapter
    implements NetworkTrafficListener {
        private final WiremockNetworkTrafficListener wiremockNetworkTrafficListener;

        NetworkTrafficListenerAdapter(WiremockNetworkTrafficListener wiremockNetworkTrafficListener) {
            this.wiremockNetworkTrafficListener = wiremockNetworkTrafficListener;
        }

        public void opened(Socket socket) {
            this.wiremockNetworkTrafficListener.opened(socket);
        }

        public void incoming(Socket socket, ByteBuffer bytes) {
            this.wiremockNetworkTrafficListener.incoming(socket, bytes);
        }

        public void outgoing(Socket socket, ByteBuffer bytes) {
            this.wiremockNetworkTrafficListener.outgoing(socket, bytes);
        }

        public void closed(Socket socket) {
            this.wiremockNetworkTrafficListener.closed(socket);
        }
    }
}

