/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.core;

import com.github.tomakehurst.wiremock.common.AsynchronousResponseSettings;
import com.github.tomakehurst.wiremock.common.BrowserProxySettings;
import com.github.tomakehurst.wiremock.common.ClasspathFileSource;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.common.Slf4jNotifier;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSourceFactory;
import com.github.tomakehurst.wiremock.core.MappingsSaver;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.ExtensionLoader;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import com.github.tomakehurst.wiremock.http.ThreadPoolFactory;
import com.github.tomakehurst.wiremock.http.trafficlistener.DoNothingWiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.http.trafficlistener.WiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.jetty9.JettyHttpServerFactory;
import com.github.tomakehurst.wiremock.jetty9.QueuedThreadPoolFactory;
import com.github.tomakehurst.wiremock.security.Authenticator;
import com.github.tomakehurst.wiremock.security.BasicAuthenticator;
import com.github.tomakehurst.wiremock.security.NoAuthenticator;
import com.github.tomakehurst.wiremock.standalone.JsonFileMappingsSource;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.standalone.MappingsSource;
import com.github.tomakehurst.wiremock.verification.notmatched.NotMatchedRenderer;
import com.github.tomakehurst.wiremock.verification.notmatched.PlainTextStubNotMatchedRenderer;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class WireMockConfiguration
implements Options {
    private long asyncResponseTimeout = 300000L;
    private boolean disableOptimizeXmlFactoriesLoading = false;
    private int portNumber = 8080;
    private boolean httpDisabled = false;
    private String bindAddress = "0.0.0.0";
    private int containerThreads = 25;
    private int httpsPort = -1;
    private String keyStorePath = Resources.getResource((String)"keystore").toString();
    private String keyStorePassword = "password";
    private String keyManagerPassword = "password";
    private String keyStoreType = "JKS";
    private String trustStorePath;
    private String trustStorePassword = "password";
    private String trustStoreType = "JKS";
    private boolean needClientAuth;
    private boolean browserProxyingEnabled = false;
    private String caKeystorePath = BrowserProxySettings.DEFAULT_CA_KEYSTORE_PATH;
    private String caKeystorePassword = "password";
    private String caKeystoreType = "JKS";
    private KeyStoreSettings caKeyStoreSettings = null;
    private boolean trustAllProxyTargets = false;
    private final List<String> trustedProxyTargets = new ArrayList<String>();
    private ProxySettings proxySettings = ProxySettings.NO_PROXY;
    private FileSource filesRoot = new SingleRootFileSource("src/test/resources");
    private MappingsSource mappingsSource;
    private Notifier notifier = new Slf4jNotifier(false);
    private boolean requestJournalDisabled = false;
    private Optional<Integer> maxRequestJournalEntries = Optional.absent();
    private List<CaseInsensitiveKey> matchingHeaders = Collections.emptyList();
    private boolean preserveHostHeader;
    private String proxyHostHeader;
    private HttpServerFactory httpServerFactory = new JettyHttpServerFactory();
    private ThreadPoolFactory threadPoolFactory = new QueuedThreadPoolFactory();
    private Integer jettyAcceptors;
    private Integer jettyAcceptQueueSize;
    private Integer jettyHeaderBufferSize;
    private Integer jettyHeaderRequestSize;
    private Integer jettyHeaderResponseSize;
    private Long jettyStopTimeout;
    private Long jettyIdleTimeout;
    private Map<String, Extension> extensions = Maps.newLinkedHashMap();
    private WiremockNetworkTrafficListener networkTrafficListener = new DoNothingWiremockNetworkTrafficListener();
    private Authenticator adminAuthenticator = new NoAuthenticator();
    private boolean requireHttpsForAdminApi = false;
    private NotMatchedRenderer notMatchedRenderer = new PlainTextStubNotMatchedRenderer();
    private boolean asynchronousResponseEnabled;
    private int asynchronousResponseThreads;
    private Options.ChunkedEncodingPolicy chunkedEncodingPolicy;
    private boolean gzipDisabled = false;
    private boolean stubLoggingDisabled = false;
    private String permittedSystemKeys = null;
    private boolean stubCorsEnabled = false;
    private boolean disableStrictHttpHeaders;

    private MappingsSource getMappingsSource() {
        if (this.mappingsSource == null) {
            this.mappingsSource = new JsonFileMappingsSource(this.filesRoot.child("mappings"));
        }
        return this.mappingsSource;
    }

    public static WireMockConfiguration wireMockConfig() {
        return new WireMockConfiguration();
    }

    public static WireMockConfiguration options() {
        return WireMockConfiguration.wireMockConfig();
    }

    public WireMockConfiguration timeout(int timeout) {
        this.asyncResponseTimeout = timeout;
        return this;
    }

    public WireMockConfiguration port(int portNumber) {
        this.portNumber = portNumber;
        return this;
    }

    public WireMockConfiguration dynamicPort() {
        this.portNumber = 0;
        return this;
    }

    public WireMockConfiguration httpDisabled(boolean httpDisabled) {
        this.httpDisabled = httpDisabled;
        return this;
    }

    public WireMockConfiguration httpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public WireMockConfiguration dynamicHttpsPort() {
        this.httpsPort = 0;
        return this;
    }

    public WireMockConfiguration containerThreads(Integer containerThreads) {
        this.containerThreads = containerThreads;
        return this;
    }

    public WireMockConfiguration jettyAcceptors(Integer jettyAcceptors) {
        this.jettyAcceptors = jettyAcceptors;
        return this;
    }

    public WireMockConfiguration jettyAcceptQueueSize(Integer jettyAcceptQueueSize) {
        this.jettyAcceptQueueSize = jettyAcceptQueueSize;
        return this;
    }

    @Deprecated
    public WireMockConfiguration jettyHeaderBufferSize(Integer jettyHeaderBufferSize) {
        this.jettyHeaderBufferSize = jettyHeaderBufferSize;
        return this;
    }

    public WireMockConfiguration jettyHeaderRequestSize(Integer jettyHeaderRequestSize) {
        this.jettyHeaderRequestSize = jettyHeaderRequestSize;
        return this;
    }

    public WireMockConfiguration jettyHeaderResponseSize(Integer jettyHeaderResponseSize) {
        this.jettyHeaderResponseSize = jettyHeaderResponseSize;
        return this;
    }

    public WireMockConfiguration jettyStopTimeout(Long jettyStopTimeout) {
        this.jettyStopTimeout = jettyStopTimeout;
        return this;
    }

    public WireMockConfiguration jettyIdleTimeout(Long jettyIdleTimeout) {
        this.jettyIdleTimeout = jettyIdleTimeout;
        return this;
    }

    public WireMockConfiguration keystorePath(String path) {
        this.keyStorePath = path;
        return this;
    }

    public WireMockConfiguration keystorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public WireMockConfiguration keyManagerPassword(String keyManagerPassword) {
        this.keyManagerPassword = keyManagerPassword;
        return this;
    }

    public WireMockConfiguration keystoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
        return this;
    }

    public WireMockConfiguration caKeystoreSettings(KeyStoreSettings caKeyStoreSettings) {
        this.caKeyStoreSettings = caKeyStoreSettings;
        return this;
    }

    public WireMockConfiguration caKeystorePath(String path) {
        this.caKeystorePath = path;
        return this;
    }

    public WireMockConfiguration caKeystorePassword(String keyStorePassword) {
        this.caKeystorePassword = keyStorePassword;
        return this;
    }

    public WireMockConfiguration caKeystoreType(String caKeystoreType) {
        this.caKeystoreType = caKeystoreType;
        return this;
    }

    public WireMockConfiguration trustStorePath(String truststorePath) {
        this.trustStorePath = truststorePath;
        return this;
    }

    public WireMockConfiguration trustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public WireMockConfiguration trustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
        return this;
    }

    public WireMockConfiguration needClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        return this;
    }

    public WireMockConfiguration enableBrowserProxying(boolean enabled) {
        this.browserProxyingEnabled = enabled;
        return this;
    }

    public WireMockConfiguration proxyVia(String host, int port) {
        this.proxySettings = new ProxySettings(host, port);
        return this;
    }

    public WireMockConfiguration proxyVia(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
        return this;
    }

    public WireMockConfiguration withRootDirectory(String path) {
        this.filesRoot = new SingleRootFileSource(path);
        return this;
    }

    public WireMockConfiguration usingFilesUnderDirectory(String path) {
        return this.withRootDirectory(path);
    }

    public WireMockConfiguration usingFilesUnderClasspath(String path) {
        this.fileSource(new ClasspathFileSource(path));
        return this;
    }

    public WireMockConfiguration fileSource(FileSource fileSource) {
        this.filesRoot = fileSource;
        return this;
    }

    public WireMockConfiguration mappingSource(MappingsSource mappingsSource) {
        this.mappingsSource = mappingsSource;
        return this;
    }

    public WireMockConfiguration notifier(Notifier notifier) {
        this.notifier = notifier;
        return this;
    }

    public WireMockConfiguration bindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    public WireMockConfiguration disableRequestJournal() {
        this.requestJournalDisabled = true;
        return this;
    }

    @Deprecated
    public WireMockConfiguration maxRequestJournalEntries(Optional<Integer> maxRequestJournalEntries) {
        this.maxRequestJournalEntries = maxRequestJournalEntries;
        return this;
    }

    public WireMockConfiguration maxRequestJournalEntries(int maxRequestJournalEntries) {
        this.maxRequestJournalEntries = Optional.of((Object)maxRequestJournalEntries);
        return this;
    }

    public WireMockConfiguration recordRequestHeadersForMatching(List<String> headers) {
        this.matchingHeaders = Lists.transform(headers, CaseInsensitiveKey.TO_CASE_INSENSITIVE_KEYS);
        return this;
    }

    public WireMockConfiguration preserveHostHeader(boolean preserveHostHeader) {
        this.preserveHostHeader = preserveHostHeader;
        return this;
    }

    public WireMockConfiguration proxyHostHeader(String hostHeaderValue) {
        this.proxyHostHeader = hostHeaderValue;
        return this;
    }

    public WireMockConfiguration extensions(String ... classNames) {
        this.extensions.putAll(ExtensionLoader.load(classNames));
        return this;
    }

    public WireMockConfiguration extensions(Extension ... extensionInstances) {
        this.extensions.putAll(ExtensionLoader.asMap(Arrays.asList(extensionInstances)));
        return this;
    }

    public WireMockConfiguration extensions(Class<? extends Extension> ... classes) {
        this.extensions.putAll(ExtensionLoader.load(classes));
        return this;
    }

    public WireMockConfiguration httpServerFactory(HttpServerFactory serverFactory) {
        this.httpServerFactory = serverFactory;
        return this;
    }

    public WireMockConfiguration threadPoolFactory(ThreadPoolFactory threadPoolFactory) {
        this.threadPoolFactory = threadPoolFactory;
        return this;
    }

    public WireMockConfiguration networkTrafficListener(WiremockNetworkTrafficListener networkTrafficListener) {
        this.networkTrafficListener = networkTrafficListener;
        return this;
    }

    public WireMockConfiguration adminAuthenticator(Authenticator authenticator) {
        this.adminAuthenticator = authenticator;
        return this;
    }

    public WireMockConfiguration basicAdminAuthenticator(String username, String password) {
        return this.adminAuthenticator(new BasicAuthenticator(username, password));
    }

    public WireMockConfiguration requireHttpsForAdminApi() {
        this.requireHttpsForAdminApi = true;
        return this;
    }

    public WireMockConfiguration notMatchedRenderer(NotMatchedRenderer notMatchedRenderer) {
        this.notMatchedRenderer = notMatchedRenderer;
        return this;
    }

    public WireMockConfiguration asynchronousResponseEnabled(boolean asynchronousResponseEnabled) {
        this.asynchronousResponseEnabled = asynchronousResponseEnabled;
        return this;
    }

    public WireMockConfiguration asynchronousResponseThreads(int asynchronousResponseThreads) {
        this.asynchronousResponseThreads = asynchronousResponseThreads;
        return this;
    }

    public WireMockConfiguration useChunkedTransferEncoding(Options.ChunkedEncodingPolicy policy) {
        this.chunkedEncodingPolicy = policy;
        return this;
    }

    public WireMockConfiguration gzipDisabled(boolean gzipDisabled) {
        this.gzipDisabled = gzipDisabled;
        return this;
    }

    public WireMockConfiguration stubRequestLoggingDisabled(boolean disabled) {
        this.stubLoggingDisabled = disabled;
        return this;
    }

    public WireMockConfiguration stubCorsEnabled(boolean enabled) {
        this.stubCorsEnabled = enabled;
        return this;
    }

    public WireMockConfiguration trustAllProxyTargets(boolean enabled) {
        this.trustAllProxyTargets = enabled;
        return this;
    }

    public WireMockConfiguration trustedProxyTargets(String ... trustedProxyTargets) {
        return this.trustedProxyTargets(Arrays.asList(trustedProxyTargets));
    }

    public WireMockConfiguration trustedProxyTargets(List<String> trustedProxyTargets) {
        this.trustedProxyTargets.addAll(trustedProxyTargets);
        return this;
    }

    @Override
    public int portNumber() {
        return this.portNumber;
    }

    @Override
    public boolean getHttpDisabled() {
        return this.httpDisabled;
    }

    @Override
    public int containerThreads() {
        return this.containerThreads;
    }

    @Override
    public HttpsSettings httpsSettings() {
        return new HttpsSettings.Builder().port(this.httpsPort).keyStorePath(this.keyStorePath).keyStorePassword(this.keyStorePassword).keyManagerPassword(this.keyManagerPassword).keyStoreType(this.keyStoreType).trustStorePath(this.trustStorePath).trustStorePassword(this.trustStorePassword).trustStoreType(this.trustStoreType).needClientAuth(this.needClientAuth).build();
    }

    @Override
    public JettySettings jettySettings() {
        return JettySettings.Builder.aJettySettings().withAcceptors(this.jettyAcceptors).withAcceptQueueSize(this.jettyAcceptQueueSize).withRequestHeaderSize(this.jettyHeaderBufferSize).withRequestHeaderSize(this.jettyHeaderRequestSize).withResponseHeaderSize(this.jettyHeaderResponseSize).withStopTimeout(this.jettyStopTimeout).withIdleTimeout(this.jettyIdleTimeout).build();
    }

    @Override
    public boolean browserProxyingEnabled() {
        return this.browserProxyingEnabled;
    }

    @Override
    public ProxySettings proxyVia() {
        return this.proxySettings;
    }

    @Override
    public FileSource filesRoot() {
        return this.filesRoot;
    }

    @Override
    public MappingsLoader mappingsLoader() {
        return this.getMappingsSource();
    }

    @Override
    public MappingsSaver mappingsSaver() {
        return this.getMappingsSource();
    }

    @Override
    public Notifier notifier() {
        return this.notifier;
    }

    @Override
    public boolean requestJournalDisabled() {
        return this.requestJournalDisabled;
    }

    @Override
    public Optional<Integer> maxRequestJournalEntries() {
        return this.maxRequestJournalEntries;
    }

    @Override
    public String bindAddress() {
        return this.bindAddress;
    }

    @Override
    public List<CaseInsensitiveKey> matchingHeaders() {
        return this.matchingHeaders;
    }

    @Override
    public HttpServerFactory httpServerFactory() {
        return this.httpServerFactory;
    }

    @Override
    public ThreadPoolFactory threadPoolFactory() {
        return this.threadPoolFactory;
    }

    @Override
    public boolean shouldPreserveHostHeader() {
        return this.preserveHostHeader;
    }

    @Override
    public String proxyHostHeader() {
        return this.proxyHostHeader;
    }

    @Override
    public <T extends Extension> Map<String, T> extensionsOfType(Class<T> extensionType) {
        return Maps.filterEntries(this.extensions, ExtensionLoader.valueAssignableFrom(extensionType));
    }

    @Override
    public WiremockNetworkTrafficListener networkTrafficListener() {
        return this.networkTrafficListener;
    }

    @Override
    public Authenticator getAdminAuthenticator() {
        return this.adminAuthenticator;
    }

    @Override
    public boolean getHttpsRequiredForAdminApi() {
        return this.requireHttpsForAdminApi;
    }

    @Override
    public NotMatchedRenderer getNotMatchedRenderer() {
        return this.notMatchedRenderer;
    }

    @Override
    public AsynchronousResponseSettings getAsynchronousResponseSettings() {
        return new AsynchronousResponseSettings(this.asynchronousResponseEnabled, this.asynchronousResponseThreads);
    }

    @Override
    public Options.ChunkedEncodingPolicy getChunkedEncodingPolicy() {
        return this.chunkedEncodingPolicy;
    }

    @Override
    public boolean getGzipDisabled() {
        return this.gzipDisabled;
    }

    @Override
    public boolean getStubRequestLoggingDisabled() {
        return this.stubLoggingDisabled;
    }

    @Override
    public boolean getStubCorsEnabled() {
        return this.stubCorsEnabled;
    }

    @Override
    public long timeout() {
        return this.asyncResponseTimeout;
    }

    @Override
    public boolean getDisableOptimizeXmlFactoriesLoading() {
        return this.disableOptimizeXmlFactoriesLoading;
    }

    public WireMockConfiguration disableOptimizeXmlFactoriesLoading(boolean disableOptimizeXmlFactoriesLoading) {
        this.disableOptimizeXmlFactoriesLoading = disableOptimizeXmlFactoriesLoading;
        return this;
    }

    @Override
    public boolean getDisableStrictHttpHeaders() {
        return this.disableStrictHttpHeaders;
    }

    public WireMockConfiguration disableStrictHttpHeaders(boolean disableStrictHttpHeaders) {
        this.disableStrictHttpHeaders = disableStrictHttpHeaders;
        return this;
    }

    @Override
    public BrowserProxySettings browserProxySettings() {
        KeyStoreSettings keyStoreSettings = this.caKeyStoreSettings != null ? this.caKeyStoreSettings : new KeyStoreSettings(KeyStoreSourceFactory.getAppropriateForJreVersion(this.caKeystorePath, this.caKeystoreType, this.caKeystorePassword.toCharArray()));
        return new BrowserProxySettings.Builder().enabled(this.browserProxyingEnabled).trustAllProxyTargets(this.trustAllProxyTargets).trustedProxyTargets(this.trustedProxyTargets).caKeyStoreSettings(keyStoreSettings).build();
    }
}

