/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.prosplign.execution;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.core.execution.DockerExecutionUtils;
import org.sing_group.seda.core.execution.DockerImageChecker;
import org.sing_group.seda.prosplign.execution.AbstractProSplignCompartBinariesExecutor;
import org.sing_group.seda.prosplign.execution.ProSplignCompartEnvironment;

@XmlRootElement
public class DockerProSplignCompartBinariesExecutor
extends AbstractProSplignCompartBinariesExecutor {
    @XmlTransient
    private final ProSplignCompartEnvironment environment = ProSplignCompartEnvironment.getInstance();
    @XmlTransient
    private final DockerImageChecker dockerImageChecker = DockerImageChecker.getInstance();
    @XmlElement
    private final String dockerImage;

    public DockerProSplignCompartBinariesExecutor() {
        this(DockerProSplignCompartBinariesExecutor.getDefaultDockerImage());
    }

    public DockerProSplignCompartBinariesExecutor(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    @Override
    protected String toFilePath(File file) {
        return DockerExecutionUtils.dockerPath(file.getAbsolutePath());
    }

    public static String getDefaultDockerImage() {
        return "singgroup/seda-prosplign-procompart";
    }

    @Override
    public void checkBinary() throws BinaryCheckException {
        if (this.dockerImageChecker.shouldCheckDockerImage(this.dockerImage)) {
            DockerExecutionUtils.checkDockerAvailability();
            super.checkBinary();
            this.dockerImageChecker.storeImageTimestamp(this.dockerImage);
        }
    }

    @Override
    public void proSplign(File compart, File nucleotidesFasta, File proteinQueryFasta, File outputDir, String outputFileName) throws IOException, InterruptedException {
        HashSet<String> directoriesToMount = new HashSet<String>();
        directoriesToMount.add(compart.getParent());
        directoriesToMount.add(nucleotidesFasta.getParent());
        directoriesToMount.add(proteinQueryFasta.getParent());
        directoriesToMount.add(outputDir.getAbsolutePath());
        super.proSplign(this.composeProSplignCompartCommand(this.dockerImage, directoriesToMount, this.environment.getProSplignCommand()), compart, nucleotidesFasta, proteinQueryFasta, outputDir, outputFileName);
    }

    @Override
    public void proCompart(File database, File outputFile) throws IOException, InterruptedException {
        HashSet<String> directoriesToMount = new HashSet<String>();
        directoriesToMount.add(database.getParent());
        directoriesToMount.add(outputFile.getParent());
        super.proCompart(this.composeProSplignCompartCommand(this.dockerImage, directoriesToMount, this.environment.getProCompartCommand()), database, outputFile);
    }

    @Override
    protected String composeCommand(String command) {
        return this.composeProSplignCompartCommand(this.dockerImage, command);
    }

    private String composeProSplignCompartCommand(String proSplignCompart, String command) {
        return "docker run --rm " + proSplignCompart + " " + command;
    }

    private List<String> composeProSplignCompartCommand(String proSplignCompart, Set<String> directoriesToMount, String command) {
        return Arrays.asList(("docker run --rm " + DockerExecutionUtils.getMountDockerDirectoriesString(directoriesToMount) + " " + proSplignCompart + " " + command).split(" "));
    }

    public String getDockerImage() {
        return this.dockerImage;
    }
}

