/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.emboss.execution;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.sing_group.seda.core.execution.AbstractBinariesExecutor;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.emboss.execution.EmbossBinariesChecker;
import org.sing_group.seda.emboss.execution.EmbossBinariesExecutor;

public abstract class AbstractEmbossBinariesExecutor
extends AbstractBinariesExecutor
implements EmbossBinariesExecutor {
    @Override
    public void checkBinary() throws BinaryCheckException {
        EmbossBinariesChecker.checkEmbossPath(this::composeEmbossCommand);
    }

    protected abstract String composeEmbossCommand(String var1);

    protected abstract String toFilePath(File var1);

    public void getOrf(List<String> embossCommand, File input, File output, int table, int minSize, int maxSize, int find, String additionalEmbossParameters) throws IOException, InterruptedException {
        LinkedList<String> parameters = new LinkedList<String>(embossCommand);
        parameters.addAll(Arrays.asList("-sequence", this.toFilePath(input), "-outseq", this.toFilePath(output), "-table", String.valueOf(table), "-minsize", String.valueOf(minSize), "-maxsize", String.valueOf(maxSize), "-find", String.valueOf(find)));
        if (!additionalEmbossParameters.isEmpty()) {
            parameters.addAll(this.getAdditionalParameters(additionalEmbossParameters));
        }
        this.executeCommand(parameters);
    }

    private Collection<? extends String> getAdditionalParameters(String additionalParameters) {
        return Arrays.asList(additionalParameters.split(" "));
    }
}

