/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequencesgroup;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

public abstract class FilterSequencesGroupTransformation
implements SequencesGroupTransformation {
    private final SequencesGroupBuilder builder = factory::newSequencesGroup;
    private final BiPredicate<SequencesGroup, Sequence> filter;

    public FilterSequencesGroupTransformation(Predicate<Sequence> filter) {
        this((SequencesGroup sequencesGroup, Sequence sequence) -> filter.test((Sequence)sequence));
    }

    public FilterSequencesGroupTransformation(BiPredicate<SequencesGroup, Sequence> filter) {
        this(filter, DatatypeFactory.getDefaultDatatypeFactory());
    }

    public FilterSequencesGroupTransformation(Predicate<Sequence> filter, DatatypeFactory factory) {
        this((SequencesGroup sequencesGroup, Sequence sequence) -> filter.test((Sequence)sequence), factory);
    }

    public FilterSequencesGroupTransformation(BiPredicate<SequencesGroup, Sequence> filter, DatatypeFactory factory) {
        this.filter = filter;
    }

    @Override
    public SequencesGroup transform(SequencesGroup sequencesGroup) {
        try {
            List<Sequence> sequences = sequencesGroup.getSequences().filter(sequence -> this.filter.test(sequencesGroup, (Sequence)sequence)).collect(Collectors.toList());
            if (sequences.size() == 0) {
                throw new TransformationException("Empty sequences after filtering");
            }
            return this.builder.of(sequencesGroup.getName(), sequencesGroup.getProperties(), sequences);
        }
        catch (RuntimeException e) {
            if (e instanceof TransformationException) {
                throw e;
            }
            throw new TransformationException("Unexpected error during transformation", e);
        }
    }
}

